/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.integreation.conexaoExterna.method;

import br.com.system.commons.StringUtil;
import br.com.system.commons.jsoup.Document;
import br.com.system.integreation.conexaoExterna.ClientHttp;
import br.com.system.integreation.conexaoExterna.ContextHttp;
import br.com.system.integreation.conexaoExterna.Headers;
import br.com.system.integreation.conexaoExterna.RequestParameters;
import br.com.system.integreation.conexaoExterna.exception.ExternalConnectionException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.jsoup.Jsoup;

public abstract class Request {
    protected final String url;
    protected final HttpHost serverProxy;
    protected final Integer timeOut;
    protected ClientHttp httpClient;
    protected Headers header;
    protected RequestParameters parameters;
    protected ContextHttp httpContext;
    protected HttpEntity entity;
    protected HttpResponse response;

    public abstract void releaseConnection();

    public abstract Request execute() throws ExternalConnectionException;

    public Request(String url, HttpHost serverProxy, Integer timeOut) {
        this.url = url;
        this.serverProxy = serverProxy;
        this.timeOut = timeOut == 0 ? 300000 : timeOut;
    }

    public Request setClient(ClientHttp httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public Header[] getResponseHeaders() {
        return this.response.getAllHeaders();
    }

    public Request setHeaders(Headers header) {
        this.header = header;
        return this;
    }

    public Request setParameters(RequestParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    public Request setContext(ContextHttp httpContext) {
        this.httpContext = httpContext;
        return this;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public HttpEntity getEntity(boolean check) throws IOException, ExternalConnectionException {
        if (check && (this.entity == null || this.entity.getContent() == null)) {
            throw new ExternalConnectionException("N\u00e3o foi poss\u00edvel recuparar o conte\u00fado do download da fatura.");
        }
        return this.entity;
    }

    public String getReturnedHtml() throws IOException {
        return this.getReturnedHtml("UTF-8");
    }

    public String getReturnedHtml(String charSet) throws IOException {
        StringBuilder retorno = new StringBuilder();
        try (InputStream is = null;){
            if (this.entity != null) {
                String line;
                is = this.entity.getContent();
                InputStreamReader isr = new InputStreamReader(is, charSet);
                BufferedReader rd = new BufferedReader(isr);
                while ((line = rd.readLine()) != null) {
                    retorno.append(line).append("\n");
                }
            }
        }
        return retorno.toString();
    }

    public HttpResponse getHttpResponse() {
        return this.response;
    }

    public int getHttpStatus() {
        return this.response.getStatusLine().getStatusCode();
    }

    public String toString() {
        try {
            return this.getReturnedHtml();
        }
        catch (IOException ioException) {
            return "";
        }
    }

    public Document toJsoupDocumentExtended() throws IOException, ExternalConnectionException {
        return this.toJsoupDocumentExtended("UTF-8");
    }

    public Document toJsoupDocumentExtended(String charSet) throws IOException, ExternalConnectionException {
        String returnedHtml = this.getReturnedHtml(charSet);
        if (!StringUtil.isBlank((Object)returnedHtml)) {
            Document parsedHtml = new Document(Jsoup.parse((String)returnedHtml));
            return parsedHtml;
        }
        throw new ExternalConnectionException("O HTML retornado n\u00e3o pode estar em branco.");
    }

    public JSONObject toJsonObject() throws IOException {
        return new JSONObject(EntityUtils.toString((HttpEntity)this.response.getEntity()));
    }

    public String toJsonString() throws IOException {
        return EntityUtils.toString((HttpEntity)this.response.getEntity());
    }
}

