/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.components.containers;

import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.HashUtil;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.dialog.DialogVariant;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.shared.ThemeVariant;
import java.io.Serializable;
import org.vaadin.lineawesome.LineAwesomeIcon;

public class Container
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final Button btnClose = UIUtils.createCloseButton();
    private final Button btnSave = UIUtils.createSaveButton();
    private final Button bDown = new Button(LineAwesomeIcon.ARROW_CIRCLE_DOWN_SOLID.create());
    private final Button bUp = new Button(LineAwesomeIcon.ARROW_CIRCLE_UP_SOLID.create());
    private final VerticalContainer dialogLayout = new VerticalContainer(new Component[0]);
    private final Scroller scroller = new Scroller((Component)this.dialogLayout);
    private final String scrollerId = "scroller-" + HashUtil.getUUI();
    private final HorizontalContainer messageContainer = new HorizontalContainer(new Component[0]);
    private final Span spanMessage = new Span();

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public Container() {
        this.setId("containerX");
        this.setMinWidth("360px");
        this.setDraggable(true);
        this.setCloseOnOutsideClick(false);
        this.setResizable(true);
        this.setFooter();
        this.setLayout();
        this.add(new Component[]{this.messageContainer});
        this.add(new Component[]{this.scroller});
    }

    public void clear() {
        this.dialogLayout.removeAll();
    }

    public void setJustClose() {
        this.btnClose.setVisible(true);
        this.bUp.setVisible(false);
        this.bDown.setVisible(false);
        this.btnSave.setVisible(false);
    }

    public Button getButtonSave() {
        return this.btnSave;
    }

    public Button getButtonClose() {
        return this.btnClose;
    }

    public Button getButtonDown() {
        return this.bDown;
    }

    public Button getButtonUp() {
        return this.bUp;
    }

    public void setHeader(String text) {
        this.setHeaderTitle(text);
    }

    public void insert(Component ... components) {
        this.dialogLayout.add(components);
    }

    private void setFooter() {
        this.bUp.setWidth("min-content");
        this.bUp.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_ICON, ButtonVariant.LUMO_SMALL});
        this.bUp.getElement().setProperty("title", "Ir ao topo");
        this.bUp.addClickListener((ComponentEventListener & Serializable)e -> UIUtils.goToUp((String)this.scrollerId));
        this.bDown.setWidth("min-content");
        this.bDown.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_ICON, ButtonVariant.LUMO_SMALL});
        this.bDown.getElement().setProperty("title", "Ir ao final");
        this.bDown.addClickListener((ComponentEventListener & Serializable)e -> this.goToDown());
        this.getFooter().add(new Component[]{this.btnClose, this.bDown, this.bUp, this.btnSave});
    }

    private void setLayout() {
        this.addThemeVariants((ThemeVariant[])new DialogVariant[]{DialogVariant.LUMO_NO_PADDING});
        this.dialogLayout.setSizeFull();
        this.scroller.setId(this.scrollerId);
        this.scroller.addClassName("p-xs");
        this.scroller.setHeight("99%");
        this.dialogLayout.setPadding(false);
        this.dialogLayout.setSpacing(false);
        this.dialogLayout.setAlignItems(FlexComponent.Alignment.STRETCH);
        this.messageContainer.setVisible(false);
        this.messageContainer.add(new Component[]{this.spanMessage});
        this.spanMessage.getElement().getStyle().set("color", Color.WHITE.getValue());
    }

    public void setHorizontalAlign(FlexComponent.Alignment align) {
        this.dialogLayout.setAlignItems(align);
    }

    public void setSpacing(Boolean spacing) {
        this.dialogLayout.setSpacing(spacing.booleanValue());
    }

    public void setPadding(Boolean padding) {
        this.dialogLayout.setPadding(padding.booleanValue());
    }

    public void goToDown() {
        UIUtils.scrollToBottom((String)this.scrollerId);
    }
}

