/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.analisefatura.service;

import br.com.system.app.features.analisefatura.model.AnaliseFatura;
import br.com.system.app.features.analisefatura.model.StatusAnalise;
import br.com.system.app.features.analisefatura.repository.AnaliseFaturaItemRepository;
import br.com.system.app.features.analisefatura.repository.AnaliseFaturaRepository;
import br.com.system.app.features.analisefatura.service.oribt.OrbitAnalise;
import br.com.system.app.features.bots.service.BotService;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.commons.HashUtil;
import br.com.system.commons.SleepUtil;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class AnaliseFaturaBot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AnaliseFaturaBot.class);
    @Autowired
    private AnaliseFaturaItemRepository analiseFaturaItemRepository;
    @Autowired
    private AnaliseFaturaRepository analiseFaturaRepository;
    @Autowired
    private BotService botService;
    @Autowired
    private NotificacoesService notificacoesService;

    private OrbitAnalise getOrbit() {
        OrbitAnalise orbit = null;
        try {
            orbit = new OrbitAnalise();
        }
        catch (Exception e) {
            logger.error("Erro inesperado", (Throwable)e);
        }
        return orbit;
    }

    @Async(value="asyncDefault")
    public void start(String processName, Long id) {
        Thread.currentThread().setName(processName);
        OrbitAnalise orbit = this.getOrbit();
        boolean proceed = true;
        while (proceed) {
            try {
                if (this.botService.getByProcess(processName) == null) {
                    if (orbit != null) {
                        orbit.logout();
                    }
                    Thread.currentThread().setName("asyncDefault-killed" + HashUtil.getUUI());
                    break;
                }
                AnaliseFatura af = id == null || id <= 0L ? this.analiseFaturaRepository.findFirstByStatusAnaliseOrderByDataHoraImportacaoAsc(StatusAnalise.AGUARDANDO) : (AnaliseFatura)this.analiseFaturaRepository.findById((Object)id).get();
                if (af == null) {
                    if (orbit != null) {
                        orbit.logout();
                        orbit = null;
                    }
                    SleepUtil.inSeconds((Integer)20);
                    continue;
                }
                if (orbit == null) {
                    orbit = this.getOrbit();
                }
                this.analisar(orbit, af);
            }
            catch (Exception e) {
                logger.error("Erro inesperado", (Throwable)e);
            }
        }
    }

    public void analisar(OrbitAnalise orbit, AnaliseFatura af) {
        if (af == null) {
            throw new BusinessException("Fatura n\u00e3o encontrada");
        }
        af.setStatusAnalise(StatusAnalise.PROCESSANDO);
        af.setObservacao("");
        this.analiseFaturaItemRepository.deleteByAnaliseFatura(af);
        af.setItens(new HashSet());
        this.analiseFaturaRepository.save((Object)af);
        orbit.analisar(af);
        String mensagem = af.getNomeCliente() + " " + String.valueOf(af.getStatusAnalise());
        this.notificacoesService.notify(af.getEstruturaUsuario(), "Finalizei an\u00e1lise da fatura #" + af.getId(), mensagem);
        this.analiseFaturaRepository.save((Object)af);
    }

    public void breakProcess() {
        List listOf = this.analiseFaturaRepository.findByStatusAnaliseOrderByDataHoraImportacaoAsc(StatusAnalise.PROCESSANDO);
        for (AnaliseFatura af : listOf) {
            af.setStatusAnalise(StatusAnalise.AGUARDANDO);
            this.analiseFaturaRepository.save((Object)af);
        }
    }
}

