/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cep.repository;

import br.com.system.app.features.cep.model.CepLocalidade;
import br.com.system.app.features.cep.model.CepTipoLocalidadeEnum;
import br.com.system.app.features.cep.model.CepUf;
import java.io.Serializable;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface CepLocalidadeRepository
extends JpaRepository<CepLocalidade, Long>,
Serializable {
    @Query(value=" from CepLocalidade as CL where CL.cepUf=:cepUf and CL.nome = :nome and CL.cepTipoLocalidade=:tipoLocalidade")
    public CepLocalidade findByUfAndNome(@Param(value="cepUf") CepUf var1, @Param(value="nome") String var2, @Param(value="tipoLocalidade") CepTipoLocalidadeEnum var3);

    @Modifying
    @Query(value="update CepLocalidade CL set CL.ddd = :ddd where CL.cepUf = :cepUf and CL.nome = :nome")
    public void setDddByUfAndNome(@Param(value="cepUf") CepUf var1, @Param(value="nome") String var2, @Param(value="ddd") String var3);

    @Query(value=" from CepLocalidade as CL where CL.cepUf=:cepUf and CL.cepTipoLocalidade = 1")
    public List<CepLocalidade> findByCepUf(@Param(value="cepUf") CepUf var1);

    @Query(value=" from CepLocalidade as CL where CL.nome like %:nome% and CL.cepUf=:cepUf")
    public List<CepLocalidade> findLikeNomeAndCepUf(@Param(value="nome") String var1, @Param(value="cepUf") CepUf var2);

    public CepLocalidade findByCodigoIbge(String var1);

    public CepLocalidade findByCepGeral(String var1);

    @Query(nativeQuery=true, value="SELECT *, (6371 *\n        acos(\n            cos(radians(:latitudeOrigem)) *\n            cos(radians(latitude)) *\n            cos(radians(:longitudeOrigem) - radians(longitude)) +\n            sin(radians(:latitudeOrigem)) *\n            sin(radians(latitude))\n        )) AS distance\nFROM cep_localidade HAVING distance <= :kms AND id !=:localidadeOrigemId ")
    public List<CepLocalidade> findLocatesAround(@Param(value="localidadeOrigemId") Long var1, @Param(value="latitudeOrigem") Double var2, @Param(value="longitudeOrigem") Double var3, @Param(value="kms") Long var4);

    @Query(value="FROM CepLocalidade WHERE cepTipoLocalidade = 1")
    public List<CepLocalidade> findAllCidades();

    @Query(value="from CepLocalidade where codigoIbge is null or codigoIbge='' ")
    public List<CepLocalidade> findByCodigoIbge();
}

