/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cep.service;

import br.com.system.app.features.cep.dto.CepResult;
import br.com.system.app.features.cep.model.CepLocalidade;
import br.com.system.app.features.cep.model.CepLogradouro;
import br.com.system.app.features.cep.model.CepTipoLocalidadeEnum;
import br.com.system.app.features.cep.model.CepUf;
import br.com.system.app.features.cep.repository.CepLocalidadeRepository;
import br.com.system.app.features.cep.repository.CepLogradouroRepository;
import br.com.system.app.features.cep.repository.CepUfRepository;
import br.com.system.app.features.cep.repository.DddRepository;
import br.com.system.commons.StringUtil;
import br.com.system.commons.ValidationUtil;
import br.com.system.integreation.conexaoExterna.ExternalConnection;
import java.io.Serializable;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CepService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private CepLocalidadeRepository cepLocalidadeRepository;
    @Autowired
    private CepUfRepository cepUfRepository;
    @Autowired
    private CepLogradouroRepository cepLogradouroRepository;
    @Autowired
    private DddRepository dddRepository;

    public List<CepLocalidade> getLocalidadeByUf(CepUf uf) {
        return this.cepLocalidadeRepository.findByCepUf(uf);
    }

    public CepLocalidade getLocalidadeByNome(CepUf uf, String nome) {
        return this.cepLocalidadeRepository.findByUfAndNome(uf, nome, CepTipoLocalidadeEnum.MUNICIPIO);
    }

    public CepUf getUfBySigla(String sigla) {
        return this.cepUfRepository.findBySigla(sigla);
    }

    public List<CepUf> getUf() {
        return this.cepUfRepository.findAll();
    }

    public List<String> getDdd() {
        return this.getDdd("");
    }

    public List<String> getDdd(CepUf uf) {
        return this.getDdd(uf.getSigla());
    }

    public List<String> getDdd(String uf) {
        if (uf.isEmpty()) {
            return this.dddRepository.getAll();
        }
        return this.dddRepository.getByEstado(uf);
    }

    public CepResult findByCep(String cep) {
        CepLogradouro cepPorRua = this.cepLogradouroRepository.findByCep(cep);
        if (!ValidationUtil.isBlank((Object)cepPorRua)) {
            return new CepResult(cepPorRua.getCepLocalidade().getNome(), cepPorRua.getCepUf().getSigla(), cepPorRua.getNomeAbreviado(), cepPorRua.getCepBairro().getNome(), false);
        }
        CepLocalidade cepPorCidade = this.cepLocalidadeRepository.findByCepGeral(cep);
        if (!ValidationUtil.isBlank((Object)cepPorCidade)) {
            return new CepResult(cepPorCidade.getNome(), cepPorCidade.getCepUf().getSigla(), "", "", true);
        }
        ExternalConnection conexao = new ExternalConnection();
        try {
            JSONObject json = conexao.executeGet("https://viacep.com.br/ws/" + cep + "/json/").toJsonObject();
            return new CepResult(json.getString("localidade"), json.getString("uf"), json.getString("logradouro"), json.getString("bairro"), false);
        }
        catch (Exception e) {
            return null;
        }
    }

    public CepLogradouro findByCepOriginal(String cep) {
        return this.cepLogradouroRepository.findByCep(cep);
    }

    public void atualizaIbge() {
        try {
            ExternalConnection conexao = new ExternalConnection();
            List lista = this.cepLocalidadeRepository.findByCodigoIbge();
            for (CepLocalidade cepLocalidade : lista) {
                JSONObject json;
                String html;
                String cepGeral = StringUtil.numbersOnly((String)cepLocalidade.getCepGeral());
                if (cepGeral.length() != 8 || !(html = conexao.executeGet("https://viacep.com.br/ws/" + cepGeral + "/json/").getReturnedHtml()).contains("erro") && !html.contains("ibge") || (json = new JSONObject(html)).has("erro")) continue;
                cepLocalidade.setCodigoIbge(json.getString("ibge"));
                this.cepLocalidadeRepository.save((Object)cepLocalidade);
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(CepService.class).error(e.getMessage());
        }
    }
}

