/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.view;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.cep.service.CepService;
import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteDTO;
import br.com.system.app.features.cliente.model.ClienteTag;
import br.com.system.app.features.cliente.model.ClienteTagsActionEnum;
import br.com.system.app.features.cliente.service.ClienteAnexoService;
import br.com.system.app.features.cliente.service.ClienteLogService;
import br.com.system.app.features.cliente.service.ClienteProdutoService;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.cliente.service.ClienteTagService;
import br.com.system.app.features.cliente.view.ClienteAnexoView;
import br.com.system.app.features.cliente.view.ClienteAtividadeView;
import br.com.system.app.features.cliente.view.ClienteContatoView;
import br.com.system.app.features.cliente.view.ClienteFilterView;
import br.com.system.app.features.cliente.view.ClienteLogView;
import br.com.system.app.features.cliente.view.ClienteProdutoView;
import br.com.system.app.features.cliente.view.ClienteTimeLineView;
import br.com.system.app.features.cliente.view.form.ClienteFormView;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.FlexBoxLayout;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.layout.size.FontSize;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.PedidoTags;
import br.com.system.app.features.pedido.service.PedidoEmailService;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.pedido.service.PedidoTagsService;
import br.com.system.app.features.pedido.view.atividade.AtividadeView;
import br.com.system.app.features.pessoa.PessoaView;
import br.com.system.app.features.pessoa.service.PessoaService;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.features.usuario.views.HierarquiaView;
import br.com.system.app.features.vivo.model.VivoProspectBiDTO;
import br.com.system.app.features.vivo.service.VivoProspectBiService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

@Route(value="cliente", layout=MainLayout.class)
@PageTitle(value="Clientes")
@RolesAllowed(value={"CLIENTE_VIEW"})
public class ClienteView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final ClienteService clienteService;
    private final ClienteTagService clienteTagService;
    private final ClienteAnexoService clienteAnexoService;
    private final EstruturaUsuarioService estruturaUsuarioService;
    private final ClienteLogService clienteLogService;
    private final PessoaService pessoaService;
    private final CepService cepService;
    private final PedidoService pedidoService;
    private final ClienteFormView clienteFormView;
    private final ClienteProdutoService clienteProdutoService;
    private final PedidoTagsService pedidoTagsService;
    private final UsuarioHierarquiaService hierarquiaService;
    private final PedidoEmailService pedidoEmailService;
    private final ClienteContatoView clienteContatoView;
    private final VivoProspectBiService vivoProspectBiService;
    private ClienteFilterView filter;
    private Grid<ClienteDTO> grid;
    private Span cabOptions;
    private final ApplicationContext context;
    private Button btnFilterView;
    private HierarquiaView h;
    private final VerticalLayout containerCrud;
    private DownloadDialog dd;

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    @Autowired
    public ClienteView(ClienteService clienteService, ClienteTagService clienteTagService, ClienteAnexoService clienteAnexoService, EstruturaUsuarioService estruturaUsuarioService, PessoaService pessoaService, CepService cepService, PedidoService pedidoService, ClienteFormView clienteFormView, ApplicationContext context, ClienteProdutoService clienteProdutoService, ClienteLogService clienteLogService, PedidoTagsService pedidoTagsService, UsuarioHierarquiaService hierarquiaService, PedidoEmailService pedidoEmailService, ClienteContatoView clienteContatoView, VivoProspectBiService vivoProspectBiService) {
        this.vivoProspectBiService = vivoProspectBiService;
        this.clienteContatoView = clienteContatoView;
        this.pedidoEmailService = pedidoEmailService;
        this.pedidoService = pedidoService;
        this.hierarquiaService = hierarquiaService;
        this.pedidoTagsService = pedidoTagsService;
        this.clienteLogService = clienteLogService;
        this.clienteProdutoService = clienteProdutoService;
        this.context = context;
        this.clienteService = clienteService;
        this.clienteTagService = clienteTagService;
        this.clienteAnexoService = clienteAnexoService;
        this.estruturaUsuarioService = estruturaUsuarioService;
        this.pessoaService = pessoaService;
        this.cepService = cepService;
        this.clienteFormView = clienteFormView;
        this.containerCrud = new VerticalContainer(new Component[0]);
    }

    private Component createContent() {
        this.dd = new DownloadDialog();
        this.containerCrud.setHeightFull();
        FlexBoxLayout mainContainer = new FlexBoxLayout(FlexLayout.FlexDirection.COLUMN, new Component[0]).setSpacingXS();
        mainContainer.removePadding();
        mainContainer.setAlignItems(FlexComponent.Alignment.BASELINE);
        mainContainer.setHeightFull();
        this.cabOptions = UIUtils.createSmallSpan((String)"Op\u00e7\u00f5es");
        this.filter = new ClienteFilterView(this.cepService, this.clienteTagService, this.getEu(), this.estruturaUsuarioService, this.clienteService, this.clienteProdutoService, this.hierarquiaService);
        this.filter.getBtnPesquisar().addClickListener((ComponentEventListener & Serializable)e -> {
            this.povoar();
            this.filter.getBtnPesquisar().setEnabled(true);
        });
        Button btnNew = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PLUS, (String)"Adicionar novo cliente");
        btnNew.setDisableOnClick(true);
        btnNew.addClickListener((ComponentEventListener & Serializable)e -> this.clienteFormView.create(null));
        this.clienteFormView.addOpenedChangeListener((ComponentEventListener & Serializable)close -> {
            if (!close.isOpened()) {
                this.grid.getDataProvider().refreshItem((Object)this.clienteFormView.getClienteDTO());
                btnNew.setEnabled(true);
            }
        });
        Button btnResp = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.USER, (String)"Usu\u00e1rios Respons\u00e1veis pelo cliente");
        btnResp.setEnabled(this.hasPermission("CLIENTE_RESPONSAVEL_CHANGE"));
        btnResp.addClickListener((ComponentEventListener & Serializable)e -> this.movimentarEmLote("RESPONSAVEL"));
        Button btnTags = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TAGS, (String)"Tags do cliente");
        btnTags.setEnabled(this.hasPermission("CLIENTE_TAGS_CHANGE"));
        btnTags.addClickListener((ComponentEventListener & Serializable)e -> this.movimentarEmLote("TAG"));
        Button btnTask = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TASKS, (String)"Criar Atividade para clientes");
        btnTask.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.grid.getSelectedItems().size() < 0) {
                this.showNotification("Selecione um cliente");
                return;
            }
            if (this.hasPermission("CLIENTE_ATIVIDADE_LOTE")) {
                this.movimentarEmLote("ATIVIDADE");
            } else {
                this.showNotification("Voc\u00ea nao tem permissao de acessar essa funcionalidade");
            }
        });
        Button btnExportarContatos = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TABLE, (String)"Exportar contatos");
        btnExportarContatos.setEnabled(this.hasPermission("CLIENTE_EXPORTAR_CONTATOS"));
        btnExportarContatos.setDisableOnClick(true);
        btnExportarContatos.addClickListener((ComponentEventListener & Serializable)e -> this.exportar(btnExportarContatos, "Contatos"));
        Button btnExportarVencimentos = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.DOLLAR, (String)"Exportar Vencimentos");
        btnExportarVencimentos.setEnabled(this.hasPermission("CLIENTE_EXPORTAR_VENCIMENTOS"));
        btnExportarVencimentos.setDisableOnClick(true);
        btnExportarVencimentos.addClickListener((ComponentEventListener & Serializable)e -> this.exportar(btnExportarContatos, "Vencimentos"));
        Button btnExportarResp = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.USERS, (String)"Exportar Respon\u015baveis do cliente");
        btnExportarResp.setEnabled(this.hasPermission("CLIENTE_EXPORTAR_RESPONSAVEIS"));
        btnExportarResp.setDisableOnClick(true);
        btnExportarResp.addClickListener((ComponentEventListener & Serializable)e -> this.exportar(btnExportarResp, "Responsaveis"));
        Button btnExportarProd = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.CART, (String)"Exportar Produtos do cliente");
        btnExportarProd.setEnabled(this.hasPermission("CLIENTE_EXPORTAR_PRODUTOS"));
        btnExportarProd.setDisableOnClick(true);
        btnExportarProd.addClickListener((ComponentEventListener & Serializable)e -> this.exportar(btnExportarProd, "Produtos"));
        Button btnExportaPessoa = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.GROUP, (String)"Exportar Pessoas do cliente");
        btnExportaPessoa.setEnabled(this.hasPermission("CLIENTE_EXPORTAR_PESSOAS"));
        btnExportaPessoa.setDisableOnClick(true);
        btnExportaPessoa.addClickListener((ComponentEventListener & Serializable)e -> this.exportar(btnExportaPessoa, "Pessoas"));
        Button btnExportarBasico = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.CLIPBOARD_USER, (String)"Exportar Dados B\u00e1sicos");
        btnExportarBasico.setEnabled(this.hasPermission("CLIENTE_EXPORTAR_DADOS_BASICOS"));
        btnExportarBasico.setDisableOnClick(true);
        btnExportarBasico.addClickListener((ComponentEventListener & Serializable)e -> this.exportar(btnExportarBasico, "DadosBasico"));
        Button btnExportarEmails = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.AT, (String)"Exportar E-mails Enviados");
        btnExportarEmails.setEnabled(this.hasPermission("CLIENTE_EXPORTAR_EMAILS_ENVIADOS"));
        btnExportarEmails.setDisableOnClick(true);
        btnExportarEmails.addClickListener((ComponentEventListener & Serializable)e -> this.exportar(btnExportarEmails, "EmailsEnviados"));
        Button btnProspect = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.MODAL_LIST, (String)"Exportar ProspectBI");
        btnProspect.setVisible(this.isVivo());
        btnProspect.addClickListener((ComponentEventListener & Serializable)e -> this.exportar(btnProspect, "prospectbi"));
        this.btnFilterView = UIUtils.createSmallButton((String)"Esconder Filtro", (String)"");
        this.btnFilterView.setWidthFull();
        this.btnFilterView.addClickListener((ComponentEventListener & Serializable)e -> this.changeFilterView());
        this.setCrud();
        FlexBoxLayout optContainer = new FlexBoxLayout(FlexLayout.FlexDirection.ROW, new Component[0]);
        optContainer.setFlexWrap(FlexLayout.FlexWrap.WRAP);
        optContainer.add(new Component[]{btnResp, btnTags, btnExportarContatos, btnExportarResp, btnExportarProd, btnExportaPessoa, btnExportarBasico, btnExportarEmails, btnExportarVencimentos, btnProspect, btnTask, btnNew});
        mainContainer.add(new Component[]{this.filter.getContent(), this.btnFilterView, optContainer, this.containerCrud});
        return mainContainer;
    }

    private void setCrud() {
        this.containerCrud.removeAll();
        this.grid = new Grid(ClienteDTO.class);
        this.grid.setMinHeight("500px");
        this.grid.setColumns(new String[0]);
        this.grid.setSelectionMode(Grid.SelectionMode.MULTI);
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> this.getOptions(eg))).setKey("options").setFlexGrow(0).setWidth("180px").setHeader((Component)this.cabOptions).setResizable(false);
        this.grid.addColumn("cpfCnpj").setFlexGrow(0).setHeader("CPF-CNPJ").setWidth("180px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)c -> UIUtils.createBreakWrapSpan((String)c.getNome()))).setFlexGrow(0).setWidth("280px").setHeader("Cliente");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)c -> UIUtils.createBreakWrapSpan((String)c.getTags()))).setFlexGrow(0).setWidth("280px").setHeader("Tags");
        this.grid.addColumns(new String[]{"cidade", "estado"});
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getBairro() == null ? "" : p.getBairro())).setHeader("Bairro");
        this.grid.setWidthFull();
        this.grid.setHeightFull();
        this.containerCrud.add(new Component[]{this.grid});
    }

    private void povoar() {
        int qt = this.clienteService.count(this.filter.getFilter(), this.getEu());
        this.cabOptions.setText("(" + qt + ")");
        this.grid.setPageSize(60);
        this.grid.setItems((CallbackDataProvider.FetchCallback & Serializable)query -> this.clienteService.filter(this.filter.getFilter(), this.getEu(), (Pageable)PageRequest.of((int)query.getPage(), (int)query.getPageSize())).stream());
    }

    private void exportar(Button btn, String tipo) {
        Set lista = !this.grid.getSelectedItems().isEmpty() ? this.grid.getSelectedItems() : this.clienteService.filter(this.filter.getFilter(), this.getEu(), null);
        if (lista.size() <= 0) {
            this.showNotification("N\u00e3o h\u00e1 nenhum cliente na GRID, fa\u00e7a seu filtro e clique em pesquisar");
            return;
        }
        ConfirmationDialog cd = new ConfirmationDialog("Exporta\u00e7\u00e3o de " + tipo, "Confirma a exporta\u00e7\u00e3o de " + tipo + " de <B>" + lista.size() + "</B> clientes?<BR>" + (lista.size() > 100 ? " Esta a\u00e7\u00e3o pode demorar, clique em confirmar apenas 1 vez e aguarde" : ""));
        cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> {
            btn.setEnabled(true);
            cd.close();
        });
        cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
            cd.getConfirm().setEnabled(false);
            cd.close();
            switch (tipo) {
                case "Contatos": {
                    String url = this.clienteService.exportarContatos(this.getEu(), lista);
                    this.dd.open(url, "ExportacaoContatos.xlsx", true);
                    break;
                }
                case "Produtos": {
                    String url = this.clienteService.exportarProdutos(this.getEu(), lista);
                    this.dd.open(url, "ExportacaoClienteProdutos.xlsx", true);
                    break;
                }
                case "Responsaveis": {
                    String url = this.clienteService.exportarResponsaveis(this.getEu(), lista);
                    this.dd.open(url, "ExportacaoResponsaveis.xlsx", true);
                    break;
                }
                case "Pessoas": {
                    String url = this.clienteService.exportarPessoas(this.getEu(), lista);
                    this.dd.open(url, "ExportacaoPessoas.xlsx", true);
                    break;
                }
                case "DadosBasico": {
                    String url = this.clienteService.exportarDadosBasicos(this.getEu(), lista);
                    this.dd.open(url, "ExportacaoDadosBasicos.xlsx", true);
                    break;
                }
                case "EmailsEnviados": {
                    String url = this.pedidoEmailService.exportar(this.getEu(), lista);
                    this.dd.open(url, "ExportacaoEmailCliente.xlsx", true);
                    break;
                }
                case "prospectbi": {
                    ArrayList<VivoProspectBiDTO> listaDto = new ArrayList<VivoProspectBiDTO>();
                    for (ClienteDTO c : lista) {
                        VivoProspectBiDTO d = new VivoProspectBiDTO();
                        d.setCep(c.getCep());
                        d.setCnpj(c.getCpfCnpj());
                        d.setNumero(c.getNumero());
                        listaDto.add(d);
                    }
                    String url = this.vivoProspectBiService.gerarArquivo(this.getEu(), listaDto);
                    this.dd.open(url, "ExportacaoProspectBi.csv", true);
                    break;
                }
                case "Vencimentos": {
                    String url = this.clienteService.exportarVencimentos(this.getEu(), lista);
                    this.dd.open(url, "ExportacaoVencimentos.xlsx", true);
                    break;
                }
                default: {
                    this.showNotification("Nao encontrei TIPO");
                    return;
                }
            }
            btn.setEnabled(true);
        });
    }

    private FlexBoxLayout getOptions(ClienteDTO dto) {
        FlexBoxLayout container = new FlexBoxLayout(FlexLayout.FlexDirection.ROW, new Component[0]);
        container.setFlexWrap(FlexLayout.FlexWrap.WRAP);
        Button bEdit = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PENCIL, (String)"Editar cliente");
        Button bClip = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PAPERCLIP, (String)"Anexos do cliente");
        Button bGroup = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.GROUP, (String)"Pessoas do cliente");
        Button bTask = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TASKS, (String)"Atividades do cliente");
        Button bCredit = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.INVOICE, (String)"Consulta de Cr\u00e9dito");
        Button btnAtividades = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.ARCHIVE, (String)"Visualizar Atividades do cliente");
        Button btnTimeline = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TIMER, (String)"Timeline do Cliente");
        Button btnProdutos = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.CART, (String)"Produtos do Cliente");
        Button btnLog = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.LINES_LIST, (String)"Log de altera\u00e7\u00f5es do cliente");
        Button bContatos = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PHONE_LANDLINE, (String)"Contatos V\u00e1lidos do cliente");
        ((Icon)bContatos.getIcon()).setColor(Color.GREEN.getValue());
        btnLog.setEnabled(this.hasPermission("CLIENTE_LOG_VIEW"));
        btnProdutos.setEnabled(this.hasPermission("CLIENTE_PRODUTO_VIEW"));
        btnTimeline.setEnabled(this.hasPermission("CLIENTE_TIME_LINE"));
        btnAtividades.setEnabled(this.hasPermission("ATIVIDADE_VIEW"));
        bCredit.setVisible(false);
        bGroup.addClickListener((ComponentEventListener & Serializable)e -> {
            Cliente cliente = this.clienteService.getById(dto.getId());
            new PessoaView(this.pessoaService, cliente, this.clienteService);
        });
        bContatos.setEnabled(dto.getId() != null);
        bContatos.addClickListener((ComponentEventListener & Serializable)e -> {
            Cliente cliente = this.clienteService.getById(dto.getId());
            this.clienteContatoView.show(cliente, null);
        });
        bTask.setVisible(this.hasPermission("ATIVIDADE_VIEW"));
        bTask.addClickListener((ComponentEventListener & Serializable)e -> {});
        bClip.setEnabled(this.hasPermission("CLIENTE_ANEXO_VIEW"));
        bClip.addClickListener((ComponentEventListener & Serializable)e -> {
            Cliente cliente = this.clienteService.getById(dto.getId());
            new ClienteAnexoView(cliente, this.getEu(), this.clienteAnexoService);
        });
        bEdit.addClickListener((ComponentEventListener & Serializable)e -> {
            Cliente cliente = this.clienteService.getById(dto.getId());
            this.clienteFormView.create(cliente);
        });
        bCredit.addClickListener((ComponentEventListener & Serializable)e -> this.clienteService.getById(dto.getId()));
        btnAtividades.addClickListener((ComponentEventListener & Serializable)e -> {
            Cliente cliente = this.clienteService.getById(dto.getId());
            ClienteAtividadeView cav = new ClienteAtividadeView(cliente, this.getEu(), this.pedidoService, (AtividadeView)this.context.getBean(AtividadeView.class), this.estruturaUsuarioService);
            cav.open();
            cav.getCloseButton().addClickListener((ComponentEventListener & Serializable)close -> cav.close());
        });
        btnTimeline.addClickListener((ComponentEventListener & Serializable)e -> {
            Cliente cliente = this.clienteService.getById(dto.getId());
            if (!this.hasPermission("CLIENTE_TIME_LINE") || !this.clienteService.permiteAbrirDadosExtras(this.getEu(), cliente)) {
                UIUtils.showNotification((String)"Voc\u00ea n\u00e3o tem permiss\u00e3o para acessar essa funcionalidade");
                return;
            }
            ClienteTimeLineView tl = new ClienteTimeLineView(cliente, this.pedidoService, this.estruturaUsuarioService, (AtividadeView)this.context.getBean(AtividadeView.class));
            tl.createContent();
            tl.getCloseButton().addClickListener((ComponentEventListener & Serializable)close -> tl.close());
        });
        btnProdutos.addClickListener((ComponentEventListener & Serializable)e -> {
            Cliente cliente = this.clienteService.getById(dto.getId());
            new ClienteProdutoView(cliente, this.getEu(), this.clienteProdutoService);
        });
        btnLog.addClickListener((ComponentEventListener & Serializable)e -> {
            Cliente cliente = this.clienteService.getById(dto.getId());
            new ClienteLogView(cliente, this.clienteLogService);
        });
        container.add(new Component[]{bEdit, bClip, bGroup, bCredit, btnAtividades, btnTimeline, btnProdutos, btnLog, bContatos});
        return container;
    }

    private void responsavel(Set<ClienteDTO> cl) {
        HierarquiaView hierarquiaView = new HierarquiaView(this.getEu(), this.estruturaUsuarioService, this.hierarquiaService);
        hierarquiaView.setMultiple(Boolean.valueOf(true));
        hierarquiaView.getHeader().setText("Definir respons\u00e1veis do Cliente");
        Dialog dialog = new Dialog();
        dialog.setWidth("650px");
        hierarquiaView.getBtnConfirmar().addClickListener((ComponentEventListener & Serializable)conf -> {
            if (hierarquiaView.getValues().size() <= 0) {
                this.showNotification("Selecione os usu\u00e1rios");
                return;
            }
            this.clienteService.insereResponsaveis(this.getEu(), cl, hierarquiaView.getValues());
            this.showNotification("Processo iniciado ao final vc sera notificado");
            this.povoar();
            dialog.close();
        });
        hierarquiaView.getBtnFechar().addClickListener((ComponentEventListener & Serializable)close -> dialog.close());
        dialog.add(new Component[]{UIUtils.createSmallSpan((String)("Total: " + cl.size())), hierarquiaView});
        dialog.open();
    }

    private void atividade(Set<ClienteDTO> cl) {
        Dialog dialog = new Dialog();
        VerticalContainer v = new VerticalContainer(new Component[0]);
        this.h = new HierarquiaView(this.getEu(), this.estruturaUsuarioService, this.hierarquiaService);
        this.h.setMultiple(Boolean.TRUE);
        this.h.getBtnFechar().setVisible(false);
        this.h.getBtnConfirmar().setVisible(false);
        MultiComboBox tags = new MultiComboBox("Tags", (Collection)this.pedidoTagsService.getTags(this.getEstrutura(), PedidoTipoEnum.COMERCIAL));
        tags.setItemLabelGenerator(PedidoTags::getTag);
        RadioButtonGroup rbTipo = new RadioButtonGroup();
        rbTipo.setItems((Object[])PedidoTipoEnum.values());
        rbTipo.setValue((Object)PedidoTipoEnum.COMERCIAL);
        UIUtils.setFontSize((FontSize)FontSize.XXS, (Component[])new Component[]{rbTipo});
        rbTipo.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> tags.setItems((Collection)this.pedidoTagsService.getTags(this.getEstrutura(), (PedidoTipoEnum)e.getValue())));
        TextArea ta = new TextArea("Informa\u00e7\u00f5es iniciais");
        ta.setWidthFull();
        v.add(new Component[]{UIUtils.createHeader((String)"Criar atividades")});
        Button btnFechar = UIUtils.createSmallButton((String)"Fechar");
        btnFechar.addClickListener((ComponentEventListener & Serializable)e -> dialog.close());
        Button btnConfirmar = UIUtils.createSmallButton((String)"Distribuir");
        btnConfirmar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (rbTipo.getValue() == null) {
                this.showNotification("Selecione o tipo");
                return;
            }
            if (this.h.getValues().size() <= 0) {
                UIUtils.showNotification((String)"Selecione pelo menos 1 usu\u00e1rio");
                return;
            }
            if (cl.size() < this.h.getUsuarioId().size()) {
                UIUtils.showNotification((String)"H\u00e1 mais usu\u00e1rios que clientes, imposs\u00edvel distribuir.");
                return;
            }
            this.clienteService.distribuir(this.getEu(), cl, this.h.getEstruturaUsuarioId(), ta.getValue(), (PedidoTipoEnum)rbTipo.getValue(), tags.getValue());
            dialog.close();
            this.showNotification("Atividades criadas e distribuidas, voce pode conferir em Notificacoes");
        });
        v.add(new Component[]{rbTipo, tags, ta, this.h, new FooterContainer(new Component[]{btnFechar, btnConfirmar})});
        dialog.add(new Component[]{v});
        dialog.open();
    }

    private void tag(Set<ClienteDTO> cl) {
        Dialog dialog = new Dialog();
        dialog.setWidth("500px");
        MultiComboBox cbTags = new MultiComboBox("Redefinir Tags do Cliente", (Collection)this.clienteTagService.getTags(this.getEstrutura()));
        cbTags.setWidthFull();
        cbTags.setItemLabelGenerator(ClienteTag::getTag);
        Button btnc = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
        btnc.addClickListener((ComponentEventListener & Serializable)close -> dialog.close());
        Button btn = UIUtils.createSmallButton((String)"Atribuir", (VaadinIcon)VaadinIcon.CHECK);
        RadioButtonGroup rb = new RadioButtonGroup();
        rb.setItems((Object[])ClienteTagsActionEnum.values());
        rb.setValue((Object)ClienteTagsActionEnum.INSERIR);
        btn.addClickListener((ComponentEventListener & Serializable)eclick -> {
            if (cbTags.getValue().isEmpty()) {
                ConfirmationDialog cd = new ConfirmationDialog("Limpar tags", "Nenhuma tag definida, deseja limpar as tags dos clientes selecionados?");
                cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
                cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                    this.clienteService.alterarTags((ClienteTagsActionEnum)rb.getValue(), this.getEu(), cl, "");
                    this.showNotification("Atribuidos com sucesso");
                    cd.close();
                    dialog.close();
                    this.povoar();
                });
            } else {
                this.clienteService.alterarTags((ClienteTagsActionEnum)rb.getValue(), this.getEu(), cl, this.clienteTagService.getStringtags(cbTags.getValue()));
                this.showNotification("Atribuidos com sucesso");
                dialog.close();
                this.povoar();
            }
        });
        dialog.add(new Component[]{new VerticalContainer(new Component[]{UIUtils.createSmallSpan((String)("Total: " + cl.size())), rb, cbTags}), new HorizontalContainer(new Component[]{btnc, btn})});
        dialog.open();
    }

    private void movimentarEmLote(String tipo) {
        if (this.grid.getSelectedItems().size() > 0) {
            if (tipo.equals("RESPONSAVEL")) {
                this.responsavel(this.grid.getSelectedItems());
            } else if (tipo.equals("TAG")) {
                this.tag(this.grid.getSelectedItems());
            } else if (tipo.equals("ATIVIDADE")) {
                this.atividade(this.grid.getSelectedItems());
            }
            return;
        }
        HashSet lista = new HashSet(this.clienteService.filter(this.filter.getFilter(), this.getEu(), null));
        if (lista.size() > 50000) {
            this.showNotification("Limite maximo 50 mil clientes");
            return;
        }
        Dialog dialog = new Dialog();
        Div div = new Div();
        div.getElement().setProperty("innerHTML", "<span>Voc\u00ea est\u00e1 prestes a " + (tipo.equals("ATIVIDADE") ? "CRIAR" : "ALTERAR") + " " + tipo + " de <B>" + lista.size() + "</b> Clientes, tem certeza que quer fazer isso?<BR>Caso afirmativo, digite o n\u00famero de clientes no campo abaixo.</span>");
        NumberField antiBosta = new NumberField("Confirme nro clientes");
        antiBosta.setWidth("180px");
        Button btnClose = UIUtils.createSmallButton((String)"Cancelar", (VaadinIcon)VaadinIcon.CLOSE);
        btnClose.addClickListener((ComponentEventListener & Serializable)e -> dialog.close());
        Button btnConfirmar = UIUtils.createSmallButton((String)"Sim, Tenho certeza", (VaadinIcon)VaadinIcon.CHECK);
        btnConfirmar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (antiBosta.getValue() == null || ((Double)antiBosta.getValue()).intValue() != lista.size()) {
                this.showNotification("Quantidade n\u00e3o bate");
                return;
            }
            if (tipo.equals("RESPONSAVEL")) {
                this.responsavel(lista);
            } else if (tipo.equals("TAG")) {
                this.tag(lista);
            } else if (tipo.equals("ATIVIDADE")) {
                this.atividade(lista);
            }
            dialog.close();
        });
        dialog.add(new Component[]{new VerticalContainer(new Component[]{div, antiBosta, new FooterContainer(new Component[]{btnClose, btnConfirmar})})});
        dialog.open();
    }

    private void changeFilterView() {
        if (this.btnFilterView.getText().equals("Esconder Filtro")) {
            this.btnFilterView.setText("Mostrar Filtro");
            this.filter.getContent().setVisible(false);
        } else {
            this.btnFilterView.setText("Esconder Filtro");
            this.filter.getContent().setVisible(true);
        }
    }
}

