/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.view.form;

import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.serasa.SerasaPendenciaView;
import br.com.system.app.features.serasa.model.Serasa;
import br.com.system.app.features.serasa.report.SerasaReport;
import br.com.system.app.features.serasa.service.SerasaService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Hr;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class ClienteFormSerasa
extends VerticalLayout
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    @Autowired
    private SerasaService serasaService;
    private Button btnRestricao;
    private Button infoSerasa;
    private Serasa serasa;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public VerticalLayout create(Cliente cliente) {
        VerticalLayout layout = new VerticalLayout();
        layout.removeAll();
        layout.setEnabled(cliente != null && cliente.getId() != null);
        layout.add(new com.vaadin.flow.component.Component[]{new Hr()});
        layout.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Consulta de Cr\u00e9dito")});
        this.btnRestricao = UIUtils.createSmallButton((String)"");
        this.infoSerasa = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.INFO_CIRCLE, (String)"Abrir informa\u00e7\u00f5es de restri\u00e7\u00e3o de cr\u00e9dito");
        UIUtils.setTextColor((String)"#FFFFFF", (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{this.btnRestricao});
        this.serasa = this.serasaService.getByEstruturaUsuarioAndCliente(this.getEu(), cliente);
        this.setSerasa(this.serasa);
        Checkbox cbProtesto = new Checkbox("Protesto");
        cbProtesto.setValue((Object)Boolean.TRUE);
        Button btnPdf = UIUtils.createSmallButton((String)"PDF");
        btnPdf.setVisible(this.serasa != null);
        btnPdf.addClickListener((ComponentEventListener & Serializable)e -> {
            SerasaReport report = new SerasaReport(this.serasa);
            String url = report.getPDF();
            if (url.isBlank()) {
                UIUtils.showNotification((String)"Erro ao criar PDF");
                return;
            }
            try {
                Dialog dialog = new Dialog();
                Button btnClose = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
                btnClose.addClickListener((ComponentEventListener & Serializable)close -> dialog.close());
                Anchor anchor = new Anchor(url, new com.vaadin.flow.component.Component[0]);
                anchor.getElement().setAttribute("download", true);
                anchor.setTarget("_blank");
                anchor.setText("Abrir PDF");
                anchor.setTitle("Abrir PDF da consulta de cr\u00e9dito");
                anchor.setVisible(!url.isEmpty());
                VerticalContainer v = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
                v.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
                v.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Arquivo gerado com sucesso")});
                v.add(new com.vaadin.flow.component.Component[]{anchor, btnClose});
                dialog.add(new com.vaadin.flow.component.Component[]{v});
                dialog.open();
            }
            catch (Exception ex) {
                UIUtils.showNotification((String)ex.getMessage());
            }
        });
        Button btnConsultarSerasa = UIUtils.createSmallButton((String)"Consultar Pendencias Financeiras");
        btnConsultarSerasa.addClickListener((ComponentEventListener & Serializable)e -> {
            ConfirmationDialog cd = new ConfirmationDialog("Pendencias Financeiras", "Confirma consulta pendencias financeiras " + ((Boolean)cbProtesto.getValue() != false ? " com protesto?" : " sem protesto?"));
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                try {
                    this.serasa = this.serasaService.executaConsulta(cliente.getCpfCnpj(), (Boolean)cbProtesto.getValue(), this.getEu());
                    this.setSerasa(this.serasa);
                    btnPdf.setVisible(this.serasa != null);
                }
                catch (Exception ex) {
                    if (ex.getMessage().contains("SEM_CREDITO")) {
                        UIUtils.showNotification((String)"Voc\u00ea est\u00e1 sem cr\u00e9ditos para essa consulta");
                    }
                    UIUtils.showNotification((String)ex.getMessage());
                }
                cd.close();
            });
        });
        layout.add(new com.vaadin.flow.component.Component[]{new HorizontalLayout(new com.vaadin.flow.component.Component[]{this.btnRestricao, this.infoSerasa, cbProtesto, btnConsultarSerasa, btnPdf})});
        return layout;
    }

    private void setSerasa(Serasa serasa) {
        String data;
        String string = data = serasa == null ? "" : serasa.getDataHora().format(FormatDate.DATETIME_BR.toDTF());
        if (serasa == null) {
            UIUtils.setBackgroundColor((Color)Color.GRAY, (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{this.btnRestricao});
            this.btnRestricao.setText("SEM CONSULTA");
            this.btnRestricao.getElement().setProperty("title", "Este cliente ainda n\u00e3o teve consulta de cr\u00e9dito");
            this.infoSerasa.setVisible(false);
        } else if (serasa.isTemRestricao()) {
            this.infoSerasa.setVisible(true);
            UIUtils.setBackgroundColor((Color)Color.RED, (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{this.btnRestricao});
            this.btnRestricao.setText("COM RESTRI\u00c7\u00d5ES");
            this.btnRestricao.getElement().setProperty("title", "Cliente com restri\u00e7\u00f5es de cr\u00e9dito, clique no bot\u00e3o ao lado para visualizar, consulta efetuada em " + data);
            this.infoSerasa.addClickListener((ComponentEventListener & Serializable)e -> {
                SerasaPendenciaView spv = new SerasaPendenciaView(serasa);
                spv.create();
                spv.getCloseButton().addClickListener((ComponentEventListener & Serializable)close -> spv.close());
            });
        } else {
            this.infoSerasa.setVisible(false);
            UIUtils.setBackgroundColor((Color)Color.GREEN, (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{this.btnRestricao});
            this.btnRestricao.setText("SEM RESTRI\u00c7\u00d5ES");
            this.btnRestricao.getElement().setProperty("title", "Cliente sem restri\u00e7\u00e3o, consulta efetuada em " + data);
        }
    }
}

