/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cobranca.service;

import br.com.system.app.features.cep.model.CepLocalidade;
import br.com.system.app.features.cep.model.CepUf;
import br.com.system.app.features.cep.service.CepService;
import br.com.system.app.features.cobranca.model.EnotasDTO;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.commons.StringUtil;
import br.com.system.commons.ValidationUtil;
import br.com.system.commons.datetime.FormatDate;
import br.com.system.integreation.conexaoExterna.ExternalConnection;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnotasService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String URL = "https://app.enotas.com.br/api/";
    @Autowired
    private CepService cepService;

    public void getClientes() {
        try {
            ExternalConnection conexao = this.getConnection();
            String html = conexao.addParameter("pageNumber", "0").addParameter("pageSize", "10000").executeGet("https://app.enotas.com.br/api//clientes/getFilterBy").getReturnedHtml();
            JSONObject json = new JSONObject(html);
            JSONArray arr = json.getJSONArray("data");
            for (int i = 0; i < arr.length(); ++i) {
                arr.getJSONObject(i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<EnotasDTO> getNotas(String cnpj) {
        try {
            ArrayList<EnotasDTO> retorno = new ArrayList<EnotasDTO>();
            ExternalConnection conexao = this.getConnection();
            String html = conexao.addParameter("pageNumber", "0").addParameter("filter", "cliente/cpfCnpj eq '" + cnpj + "'").addParameter("pageSize", "1000").executeGet("https://app.enotas.com.br/api//vendas/getFilterBy").getReturnedHtml();
            JSONObject json = new JSONObject(html);
            if (!json.has("data")) {
                throw new BusinessException("Erro ao buscar Notas fiscais");
            }
            JSONArray arr = json.getJSONArray("data");
            for (int i = 0; i < arr.length(); ++i) {
                try {
                    JSONObject j = arr.getJSONObject(i);
                    EnotasDTO e = new EnotasDTO();
                    e.setData(j.getString("data"));
                    e.setValor(j.get("valorTotal").toString());
                    JSONObject nfe = j.getJSONObject("nfe");
                    JSONObject pref = nfe.getJSONObject("prefeitura");
                    JSONObject cli = j.getJSONObject("cliente");
                    if (!cnpj.equals(cli.get("cpfCnpj").toString())) continue;
                    e.setLinkXml(pref.getString("linkXml"));
                    e.setLinkImpressao(pref.getString("linkImpressao"));
                    e.setSituacao(this.getSituacao(Integer.valueOf(nfe.getInt("situacao"))));
                    e.setCpfCnpj(cli.get("cpfCnpj").toString());
                    e.setNomeCliente(cli.get("nome").toString());
                    retorno.add(e);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return retorno;
        }
        catch (Exception e) {
            throw new BusinessException("Erro pegar notas fiscais " + e.getMessage());
        }
    }

    private String getSituacao(Integer situacao) {
        HashMap<Integer, String> hm = new HashMap<Integer, String>();
        hm.put(0, "Pendente");
        hm.put(1, "Emitindo");
        hm.put(2, "Emitida");
        hm.put(3, "Falha Ao Emitir");
        hm.put(4, "Cancelando");
        hm.put(5, "Cancelada");
        hm.put(6, "Falha ao Cancelar");
        hm.put(7, "Nao Emitir");
        hm.put(8, "Enviada Por Email");
        return (String)hm.get(situacao);
    }

    public String cadatrarCliente(String cpfCnpj, String nome, String email, String telefone, String logradouro, String numero, String compl, String bairro, String cidade, String estado, String cep) {
        try {
            String email3;
            CepUf uf = this.cepService.getUfBySigla(estado);
            if (uf == null) {
                throw new BusinessException("Estado inv\u00e1lido");
            }
            CepLocalidade loc = this.cepService.getLocalidadeByNome(uf, cidade);
            if (loc == null || loc.getCodigoIbge() == null || loc.getCodigoIbge().isEmpty()) {
                throw new BusinessException("Cidade inv\u00e1lida");
            }
            if (email == null || email.isEmpty() || telefone == null || telefone.isEmpty() || nome == null || nome.isEmpty() || logradouro == null || logradouro.isEmpty() || bairro == null || bairro.isEmpty() || cep == null || cep.isEmpty() || !ValidationUtil.isValidCnpjAndCpf((String)cpfCnpj)) {
                throw new BusinessException("CPF-CNPJ, Nome, Telefone, Email, Logradouro, Bairro, Cep s\u00e3o obrigatorios");
            }
            if ((numero = StringUtil.removeNonNumber((String)numero)) == null || numero.isEmpty()) {
                numero = "00";
            }
            String[] arrEmail = email.split(",");
            String email1 = arrEmail[0];
            String email2 = arrEmail.length > 1 ? arrEmail[1] : "";
            String string = email3 = arrEmail.length > 2 ? arrEmail[2] : "";
            if (compl != null && compl.length() > 30) {
                compl = compl.substring(0, 29);
            }
            String j = "{\n  \"nomeFantasia\": null,\n  \"inscricaoMunicipal\": null,\n  \"inscricaoEstadual\": null,\n  \"email\": \"" + email1 + "\",\n  \"email2\": \"" + email2 + "\",\n  \"email3\": \"" + email3 + "\",\n  \"telefone\": \"" + StringUtil.numbersOnly((String)telefone) + "\",\n  \"nome\": \"" + nome + "\",\n  \"cpfCnpj\": \"" + StringUtil.numbersOnly((String)cpfCnpj) + "\",\n  \"endereco\": {\n    \"cidade\": \"" + cidade + "\",\n    \"codigoIbgeCidade\": \"" + loc.getCodigoIbge() + "\",\n    \"logradouro\": \"" + logradouro + "\",\n    \"numero\": \"" + numero + "\",\n    \"complemento\": \"" + compl + "\",\n    \"bairro\":\" " + bairro + "\",\n    \"cep\": \"" + cep + "\"\n  }\n}";
            ExternalConnection conexao = this.getConnection();
            conexao.setJsonParameters(new JSONObject(j));
            JSONObject jRetorno = conexao.executePost("https://app.enotas.com.br/api//clientes").toJsonObject();
            return jRetorno.getString("clienteId");
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao cadastrar cliente: " + e.getMessage());
        }
    }

    public void cancelarVenda(String vendaId) {
        try {
            ExternalConnection conexao = this.getConnection();
            conexao.executePost("https://app.enotas.com.br/api//vendas/" + vendaId + "/cancelar");
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao cancelar nota fiscal");
        }
    }

    public String emitirVenda(String clienteId, LocalDate data, BigDecimal valor, String produto) {
        try {
            String dataStr = data.format(FormatDate.DATE_BR.toDTF());
            String valorStr = valor.toString();
            String j = "{\n  \"cliente\": {\n    \"id\": \"" + clienteId + "\"\n  },\n  \"data\": \"" + dataStr + "\",\n  \"vencimento\": \"" + dataStr + "\",\n  \"produto\": {\n    \"nome\": \"" + produto + "\",\n    \"idExterno\": \"1\",\n    \"valorTotal\": \"" + valorStr + "\",\n    \"diasGarantia\": 30,\n    \"tags\": \"MENSALIDADE\"\n  },\n  \"valorTotal\": \"" + valorStr + "\",\n  \"quandoEmitirNFe\": 0,\n  \"enviarNFeCliente\": true,\n  \"meioPagamento\": 7,\n  \"tags\": \"MENSALIDADE\",\n  \"municipioPrestacao\": {\n    \"nome\": \"Balne\u00e1rio Cambori\u00fa\",\n    \"codigoIbge\": 4202008\n  },\n  \"dataCompetencia\": \"" + dataStr + "\",\n  \"discriminacao\": \"" + produto + "\",\n  \"valorTotalNFe\": \"" + valorStr + "\",\n  \"aliquotaIss\": 4.65,\n  \"valorIss\": null,\n  \"issRetidoFonte\": false,\n  \"deducoes\": null,\n  \"observacoes\": null,\n  \"porcentagemCofins\": 0,\n  \"porcentagemCsll\": 0,\n  \"porcentagemInss\": 0,\n  \"porcentagemIr\": 0,\n  \"porcentagemPis\": 0\n}";
            ExternalConnection conexao = this.getConnection();
            conexao.setJsonParameters(new JSONObject(j));
            JSONObject jRetorno = conexao.executePost("https://app.enotas.com.br/api//vendas").toJsonObject();
            return jRetorno.getString("vendaId");
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao emitir a nota: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        new EnotasService().getLinkNota("d8b41864-b25a-4a4c-a7a7-4e9da6410900");
    }

    public String getLinkNota(String id) {
        try {
            JSONObject j = this.getConnection().executeGet("https://app.enotas.com.br/api//vendas/" + id).toJsonObject();
            JSONObject nfe = j.getJSONObject("nfe");
            JSONObject pref = nfe.getJSONObject("prefeitura");
            return pref.getString("linkImpressao");
        }
        catch (Exception e) {
            return "";
        }
    }

    private ExternalConnection getConnection() {
        ExternalConnection conexao = new ExternalConnection();
        conexao.addHeader("Authorization", "Basic YmQ0MmRlY2ItZGY0NS00NDJlLTgyNGItYjg5YTA1NTkzZTUw");
        return conexao;
    }
}

