/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.creditos;

import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.creditos.service.CreditosService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.textfield.NumberField;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;

public class CreditosTransferView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final CreditosService creditosService;
    private final EstruturaUsuarioService eus;
    private final EstruturaUsuario eu;
    private final UsuarioHierarquiaService hierarquiaService;
    private Button btnFechar;

    public CreditosTransferView(EstruturaUsuario eu, CreditosService creditosService, EstruturaUsuarioService eus, UsuarioHierarquiaService hierarquiaService) {
        this.creditosService = creditosService;
        this.hierarquiaService = hierarquiaService;
        this.eu = eu;
        this.eus = eus;
    }

    public void create() {
        this.setCloseOnOutsideClick(false);
        this.add(new Component[]{UIUtils.createHeader((String)"Transferir cr\u00e9ditos para outro usu\u00e1rio")});
        this.btnFechar = UIUtils.createSmallButton((String)"Fechar");
        this.add(new Component[]{this.createContent()});
        this.open();
    }

    public Button getCloseButton() {
        return this.btnFechar;
    }

    private VerticalContainer createContent() {
        VerticalContainer v = new VerticalContainer(new Component[0]);
        ComboBox cb = new ComboBox("Usu\u00e1rio");
        cb.setWidthFull();
        cb.setItemLabelGenerator(HierarquiaDTO::getLogin);
        cb.setItems((Collection)this.hierarquiaService.getHierarquiaDto(this.eu));
        NumberField valor = new NumberField("Valor");
        Button btnTransferir = UIUtils.createSmallButton((String)"Transferir");
        btnTransferir.addClickListener((ComponentEventListener & Serializable)e -> {
            if (cb.getValue() == null) {
                UIUtils.showNotification((String)"Selecione um usu\u00e1rio para transferir");
                return;
            }
            if (valor.getValue() == null || (Double)valor.getValue() <= 0.0) {
                UIUtils.showNotification((String)"Informe um valor para transferir");
                return;
            }
            if (this.eu.getUsuario().getId().equals(((HierarquiaDTO)cb.getValue()).getUsuarioId())) {
                UIUtils.showNotification((String)"Imposs\u00edvel tranferir para o mesmo usu\u00e1rio");
                return;
            }
            if (!this.creditosService.temCredito(this.eu, BigDecimal.valueOf((Double)valor.getValue()))) {
                UIUtils.showNotification((String)"Valor maior que seu saldo");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Transferir cr\u00e9ditos", "Confirma a transferencia de R$ " + String.valueOf(valor.getValue()) + " para o usu\u00e1rio " + ((HierarquiaDTO)cb.getValue()).getLogin() + "?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                EstruturaUsuario euCredito = this.eus.getById(((HierarquiaDTO)cb.getValue()).getEstruturaUsuarioId());
                this.creditosService.transacionar(this.eu, "Cr\u00e9ditos transferidos para " + ((HierarquiaDTO)cb.getValue()).getLogin(), BigDecimal.valueOf((Double)valor.getValue()).negate());
                this.creditosService.transacionar(euCredito, "Cr\u00e9ditos transferidos de " + this.eu.getUsuario().getLogin(), BigDecimal.valueOf((Double)valor.getValue()));
                UIUtils.showNotification((String)"Transferido com sucesso");
                cb.clear();
                valor.clear();
                cd.close();
            });
        });
        v.add(new Component[]{cb, valor, new FooterContainer(new Component[]{this.btnFechar, btnTransferir})});
        return v;
    }
}

