/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.datastone.service;

import br.com.system.app.features.datastone.service.DataStoneEnriquecimento;
import br.com.system.app.features.enriquecimento.model.Enriquecimento;
import br.com.system.app.features.enriquecimento.service.EnriquecimentoService;
import br.com.system.app.features.shared.model.StatusProcessoEnum;
import br.com.system.commons.InputStreamUtil;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataStoneWebhook
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private EnriquecimentoService enriquecimentoService;
    @Autowired
    private DataStoneEnriquecimento dataStoneEnriquecimento;
    private PrintWriter out;

    public void webhook(ServletRequest request, ServletResponse response) {
        try {
            this.out = response.getWriter();
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            response.setContentType("json");
        }
        catch (IOException e) {
            return;
        }
        try {
            String token = request.getParameter("token");
            if (!"e3b0c44298fc1b149afbf4c8596fb92427aa41e4649c934ca495791b7852b855".equals(token)) {
                this.printError("Token Inv\u00e1lido");
                return;
            }
            String body = InputStreamUtil.toString((InputStream)request.getInputStream());
            if (body.isEmpty()) {
                this.printError("Body is empty");
                return;
            }
            JSONObject jsonBody = new JSONObject(body);
            if (!jsonBody.has("job_id") || !jsonBody.has("status")) {
                this.printError("job_id or status not present");
                return;
            }
            if (!jsonBody.getString("status").equals("done") && !jsonBody.getString("status").equals("error")) {
                this.printSucess();
                return;
            }
            Enriquecimento enriquecimento = this.enriquecimentoService.getByDataStone(Integer.valueOf(jsonBody.getInt("job_id")));
            if (enriquecimento != null) {
                if (!enriquecimento.getStatusAnalise().equals((Object)StatusProcessoEnum.NA_FILA)) {
                    this.printSucess();
                    return;
                }
            } else {
                throw new Exception("Oportunidade nao pode ser processado nessa funcionalidade, utilize o enriquecimento");
            }
            this.dataStoneEnriquecimento.goEnriquecimento(enriquecimento, jsonBody);
            this.printSucess();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void printError(String message) {
        JSONObject jsonRetorno = new JSONObject();
        jsonRetorno.put("success", false);
        jsonRetorno.put("erro", (Object)message);
        this.out.print(jsonRetorno.toString());
    }

    private void printSucess() {
        JSONObject jsonRetorno = new JSONObject();
        jsonRetorno.put("success", false);
        jsonRetorno.put("erro", (Object)"");
        this.out.print(jsonRetorno.toString());
    }
}

