/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.enriquecimento;

import br.com.system.app.MainLayout;
import br.com.system.app.components.Card;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.ListField;
import br.com.system.app.components.ListFieldTypeEnum;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.configurations.model.ConfigurationEnum;
import br.com.system.app.features.configurations.service.ConfigurationsService;
import br.com.system.app.features.creditos.CreditosCompraView;
import br.com.system.app.features.creditos.CreditosExtratoView;
import br.com.system.app.features.creditos.CreditosTransferView;
import br.com.system.app.features.creditos.service.CreditosService;
import br.com.system.app.features.enriquecimento.model.Enriquecimento;
import br.com.system.app.features.enriquecimento.service.EnriquecimentoReprocessoService;
import br.com.system.app.features.enriquecimento.service.EnriquecimentoService;
import br.com.system.app.features.estrutura.model.EstruturaTipoEnum;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.mailing.projection.MailingLimited;
import br.com.system.app.features.mailing.repository.filter.MailingFilter;
import br.com.system.app.features.mailing.service.MailingService;
import br.com.system.app.features.shared.handle.HandlerExcel;
import br.com.system.app.features.shared.model.TipoProcessoEnum;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.app.features.util.TempFileMultiBuffer;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.FileUtil;
import br.com.system.commons.SleepUtil;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import elemental.json.Json;
import elemental.json.JsonValue;
import jakarta.annotation.security.PermitAll;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="enriquecimento-de-base", layout=MainLayout.class)
@PageTitle(value="Enriquecimento de Base")
@PermitAll
public class EnriquecimentoView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final EnriquecimentoService enriquecimentoService;
    private final EnriquecimentoReprocessoService enriquecimentoReprocessoService;
    private final UsuarioService usuarioService;
    private final CreditosService creditosService;
    private final EstruturaUsuarioService eus;
    private final CreditosCompraView creditosCompraView;
    private final UsuarioHierarquiaService hierarquiaService;
    private final TextField saldo = new TextField("Seus cr\u00e9ditos");
    private final RadioButtonGroup<TipoProcessoEnum> rb = new RadioButtonGroup();
    private final GridCrud<Enriquecimento> crud = new GridCrud(Enriquecimento.class);
    private final MailingService mailingService;
    private final ConfigurationsService configurationsService;
    private final HandlerExcel handlerExcel = new HandlerExcel();
    private String nomeArquivo = "";
    private TempFileMultiBuffer mBuffer;
    private ListField txtListaCnpjs;
    private Card cardCampanha;
    private Checkbox cbWhats;
    private Checkbox cbSocios;
    private Checkbox cbJustConsult;
    private DownloadDialog dd;

    @Autowired
    public EnriquecimentoView(EnriquecimentoService enriquecimentoService, UsuarioService usuarioService, CreditosService creditosService, EstruturaUsuarioService eus, CreditosCompraView creditosCompraView, UsuarioHierarquiaService hierarquiaService, MailingService mailingservice, ConfigurationsService configurationsService, EnriquecimentoReprocessoService enriquecimentoReprocessoService) {
        this.enriquecimentoService = enriquecimentoService;
        this.enriquecimentoReprocessoService = enriquecimentoReprocessoService;
        this.configurationsService = configurationsService;
        this.mailingService = mailingservice;
        this.hierarquiaService = hierarquiaService;
        this.creditosCompraView = creditosCompraView;
        this.eus = eus;
        this.creditosService = creditosService;
        this.usuarioService = usuarioService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        this.dd = new DownloadDialog();
        this.setHeightFull();
        this.cbWhats = new Checkbox("Consultar Se Tem Whatsapp R$ " + String.valueOf(this.configurationsService.get(ConfigurationEnum.VALOR_TEM_WHATS).getBigDecimal()) + " por n\u00famero");
        this.cbWhats.setVisible(false);
        this.cbWhats.setValue((Object)false);
        this.cbSocios = new Checkbox("Consultar socios", true);
        this.cbJustConsult = new Checkbox("Somente Consultar");
        this.cbJustConsult.setVisible(this.isMaster());
        this.rb.setItems((Object[])TipoProcessoEnum.values());
        this.rb.setValue((Object)TipoProcessoEnum.CNPJ);
        this.rb.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (e != null && e.getValue() != null && ((TipoProcessoEnum)e.getValue()).equals((Object)TipoProcessoEnum.CEP_NUMERO)) {
                this.cardCampanha.setEnabled(false);
            } else {
                this.cardCampanha.setEnabled(true);
                this.txtListaCnpjs.setLabel(e != null && e.getValue() != null ? ((TipoProcessoEnum)e.getValue()).name() : "");
            }
        });
        this.saldo.setReadOnly(true);
        Button btnAtualizarSaldo = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.REFRESH, (String)"Atualizar Saldo");
        btnAtualizarSaldo.addClickListener((ComponentEventListener & Serializable)e -> this.atualizarSaldo());
        Button btnExtrato = UIUtils.createSmallButton((String)"Extrato");
        btnExtrato.addClickListener((ComponentEventListener & Serializable)e -> {
            CreditosExtratoView cv = new CreditosExtratoView(this.creditosService);
            cv.create();
            cv.getCloseButton().addClickListener((ComponentEventListener & Serializable)close -> {
                cv.close();
                this.atualizarSaldo();
            });
        });
        Button btnComprarCreditos = UIUtils.createSmallButton((String)"Comprar Cr\u00e9ditos");
        btnComprarCreditos.addClickListener((ComponentEventListener & Serializable)e -> {
            this.creditosCompraView.addOpenedChangeListener((ComponentEventListener & Serializable)c -> this.atualizarSaldo());
            this.creditosCompraView.create(this.getEu());
        });
        Button btnTransferir = UIUtils.createSmallButton((String)"Transferir Cr\u00e9ditos");
        btnTransferir.addClickListener((ComponentEventListener & Serializable)e -> {
            CreditosTransferView ctv = new CreditosTransferView(this.getEu(), this.creditosService, this.eus, this.hierarquiaService);
            ctv.create();
            ctv.getCloseButton().addClickListener((ComponentEventListener & Serializable)close -> {
                ctv.close();
                this.atualizarSaldo();
            });
        });
        VerticalContainer v = new VerticalContainer(new Component[0]);
        v.add(new Component[]{new HorizontalContainer(new Component[]{this.saldo, btnAtualizarSaldo, btnExtrato, btnComprarCreditos, btnTransferir}).setSpacingOn()});
        v.add(new Component[]{this.cbSocios, this.cbJustConsult, this.cbWhats});
        v.add(new Component[]{new HorizontalContainer(new Component[]{this.createUpload(), this.createCampanha()}).setSpacingOn()});
        v.add(new Component[]{this.getGrid()});
        this.atualizarSaldo();
        return v;
    }

    private GridCrud<Enriquecimento> getGrid() {
        this.crud.getGrid().setColumns(new String[0]);
        if (this.isMaster()) {
            this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> {
                Button btn = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.REFRESH, (String)"Reprocessar");
                btn.setEnabled(this.isMaster());
                btn.addClickListener((ComponentEventListener & Serializable)e -> {
                    ConfirmationDialog cd = new ConfirmationDialog("Reprocessamento", "Confirma reprocessamento do arquivo?");
                    cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
                    cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                        this.reprocessar(p);
                        this.showNotification("Solicita\u00e7\u00e3o de reprocessamento efetuada com sucesso");
                        cd.close();
                    });
                });
                return btn;
            })).setHeader("Rep").setFlexGrow(0).setWidth("80px");
        }
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getEstruturaUsuario().getUsuario().getLogin()))).setHeader("Usu\u00e1rio").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getNomeArquivo()))).setHeader("Nome").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataHora().format(FormatDate.DATETIME_BR.toDTF()))).setHeader("Data/Hora");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getStatusAnalise().name())).setHeader("Status");
        this.crud.getGrid().addColumn("totalRegistros");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getObservacao()))).setHeader("Observa\u00e7\u00e3o").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addComponentColumn((ValueProvider & Serializable)item -> {
            Button b = UIUtils.createSmallButton((String)"Download");
            b.setVisible(item.getUrlArquivo() != null && !item.getUrlArquivo().isEmpty());
            b.addClickListener((ComponentEventListener & Serializable)e -> {
                String url;
                String string = url = item.getUrlArquivo() == null ? "" : item.getUrlArquivo();
                if (item.getUrlArquivo() == null) {
                    item.setUrlArquivo("");
                }
                if (item.getUrlArquivo().isEmpty()) {
                    b.setVisible(false);
                } else {
                    String ext = FileUtil.getExtension((String)item.getNomeArquivo());
                    if (ext == null || ext.isEmpty()) {
                        ext = FileUtil.getExtension((String)item.getUrlArquivo());
                        item.setNomeArquivo(item.getNomeArquivo() + ext);
                    }
                    this.dd.open(url, item.getNomeArquivo());
                }
            });
            return b;
        }).setHeader("Download");
        this.crud.getCrudFormFactory().setVisibleProperties(new String[0]);
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(this.hasPermission("ENRIQUECIMENTO_BASE_DELETE"));
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.crud;
    }

    private Card createUpload() {
        this.mBuffer = new TempFileMultiBuffer();
        Upload upload = new Upload((Receiver)this.mBuffer);
        upload.setMaxFiles(1);
        upload.setAcceptedFileTypes(new String[]{".xlsx"});
        upload.addFinishedListener((ComponentEventListener & Serializable)e -> {
            this.nomeArquivo = e.getFileName();
            UIUtils.showNotification((String)"Arquivo carregado, clique em processar");
        });
        upload.addFileRejectedListener((ComponentEventListener & Serializable)event -> UIUtils.showNotification((String)"Formato inv\u00e1lido, apenas .xlxs"));
        Button processar = UIUtils.createSmallButton((String)(this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.CLARO) ? "Inserir" : "Processar"), (VaadinIcon)VaadinIcon.COGS, (String)"Iniciar processamento");
        processar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.nomeArquivo.isEmpty()) {
                UIUtils.showNotification((String)"Selecione o arquivo.");
            } else {
                try {
                    if (((TipoProcessoEnum)this.rb.getValue()).equals((Object)TipoProcessoEnum.CEP_NUMERO)) {
                        this.cepFilter();
                    } else {
                        Set cpfCnpj = this.handlerExcel.getValueFirstColumn(this.mBuffer.getInputStream());
                        this.enriquecimentoService.processar(this.getEu(), cpfCnpj, this.nomeArquivo, (TipoProcessoEnum)this.rb.getValue(), ((Boolean)this.cbWhats.getValue()).booleanValue(), ((Boolean)this.cbSocios.getValue()).booleanValue(), ((Boolean)this.cbJustConsult.getValue()).booleanValue());
                        UIUtils.showProcessNotification();
                        this.nomeArquivo = "";
                        this.mBuffer.clear();
                    }
                }
                catch (Exception ex) {
                    this.showNotification(ex.getMessage());
                }
                SleepUtil.inSeconds((Integer)3);
                upload.getElement().setPropertyJson("files", (JsonValue)Json.createArray());
                SleepUtil.inSeconds((Integer)3);
                this.crud.refreshGrid();
            }
        });
        Card card = new Card();
        card.setHeader("Upload arquivos");
        card.setContent(new Component[]{this.rb, upload});
        card.setFooter(new Component[]{processar});
        card.getContentBox().setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        card.getContentBox().setHeightFull();
        card.setWidth("310px");
        card.setHeightFull();
        return card;
    }

    private void cepFilter() {
        Set ceps = null;
        try {
            if (this.mBuffer != null && this.mBuffer.getInputStream().available() > 0) {
                ceps = this.handlerExcel.getFilterCep(this.mBuffer.getInputStream());
            }
            MailingFilter f = new MailingFilter().initialize();
            f.setFilterCep(ceps);
            f.setFilterStatus(true);
            int registros = this.mailingService.count(f, this.getEu()).intValue();
            ConfirmationDialog cd = new ConfirmationDialog("Filtrar por CEP", "Essa lista retornou um total de " + registros + " cnpjs. Confirma o processamento?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                List mailings = this.mailingService.filter(f, this.getEu(), (Pageable)PageRequest.of((int)0, (int)registros));
                HashSet<String> cnpjs = new HashSet<String>();
                for (MailingLimited m : mailings) {
                    cnpjs.add(m.getCnpj());
                }
                this.enriquecimentoService.processar(this.getEu(), cnpjs, this.nomeArquivo, TipoProcessoEnum.CNPJ, ((Boolean)this.cbWhats.getValue()).booleanValue(), ((Boolean)this.cbSocios.getValue()).booleanValue(), ((Boolean)this.cbJustConsult.getValue()).booleanValue());
                this.nomeArquivo = "";
                cd.close();
                UIUtils.showProcessNotification();
            });
        }
        catch (Exception ex) {
            this.showNotification("Erro ao filtrar ceps " + ex.getMessage());
        }
    }

    private Component createCampanha() {
        TextField txtNomeProcesso = new TextField();
        txtNomeProcesso.setLabel("Nome Campanha");
        this.txtListaCnpjs = new ListField(ListFieldTypeEnum.CPF_CNPJ, "CNPJ");
        Button btnLista = UIUtils.createSmallButton((String)"Processar", (VaadinIcon)VaadinIcon.COGS, (String)"Iniciar processamento");
        btnLista.addClickListener((ComponentEventListener & Serializable)event -> {
            if (txtNomeProcesso.isEmpty() || this.txtListaCnpjs.isEmpty()) {
                UIUtils.showNotification((String)"Nome Campanha e lista Cnpj's s\u00e3o obrigat\u00f3rios.");
            } else {
                try {
                    this.enriquecimentoService.processar(this.getEu(), this.txtListaCnpjs.getValue(), txtNomeProcesso.getValue().replace(".", "_"), (TipoProcessoEnum)this.rb.getValue(), ((Boolean)this.cbWhats.getValue()).booleanValue(), ((Boolean)this.cbSocios.getValue()).booleanValue(), ((Boolean)this.cbJustConsult.getValue()).booleanValue());
                }
                catch (Exception ex) {
                    this.showNotification(ex.getMessage());
                    return;
                }
                SleepUtil.inSeconds((Integer)3);
                UIUtils.showProcessNotification();
                this.crud.refreshGrid();
                txtNomeProcesso.setValue("");
                this.txtListaCnpjs.clear();
            }
        });
        this.cardCampanha = new Card();
        this.cardCampanha.setHeader("Campanha processo");
        this.cardCampanha.setContent(new Component[]{txtNomeProcesso, this.txtListaCnpjs});
        this.cardCampanha.setFooter(new Component[]{btnLista});
        this.cardCampanha.getContentBox().setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        this.cardCampanha.setWidth("310px");
        return this.cardCampanha;
    }

    private void atualizarSaldo() {
        BigDecimal saldoUsuario = this.usuarioService.getCreditos(this.getEu().getUsuario());
        if (saldoUsuario == null) {
            saldoUsuario = BigDecimal.ZERO;
        }
        this.saldo.setValue("R$ " + saldoUsuario.toString());
    }

    private void reprocessar(Enriquecimento p) {
        if (p.getDataHora().plusHours(1L).isAfter(LocalDateTime.now())) {
            this.showNotification("So pode reprocessar depois de uma hora");
            return;
        }
        this.enriquecimentoReprocessoService.reprocessar(p);
    }
}

