/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.estrutura.service;

import br.com.system.app.features.cobranca.model.CobrancaAssinatura;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.repository.EstruturaComplementoRepository;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EstruturaComplementoService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private EstruturaComplementoRepository repository;

    public EstruturaComplemento getByInstanceChatApi(String instanceId) {
        return this.repository.findByInstanceChatapi(instanceId);
    }

    public EstruturaComplemento getComplementos(Estrutura estrutura) {
        return this.repository.findByEstrutura(estrutura);
    }

    public EstruturaComplemento save(EstruturaComplemento ec) {
        return (EstruturaComplemento)this.repository.save((Object)ec);
    }

    public EstruturaComplemento getByTokenIntegration(String tokenIntegration) {
        return this.repository.findByTokenIntegration(tokenIntegration);
    }

    public List<EstruturaComplemento> getByOportunidadeAuto() {
        return this.repository.findByOportunidadeAutoAndEstruturaAtivo(true, true);
    }

    public List<EstruturaComplemento> getByCobrancaAssinatura(CobrancaAssinatura ca) {
        return this.repository.findByCobrancaAssinaturaAndEstruturaAtivo(ca, true);
    }

    public Boolean getObrigaTagRetornoFuturo(Estrutura estrutura) {
        return this.repository.findByEstrutura(estrutura).getObrigaTagRetornoFuturo();
    }
}

