/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.estrutura.service;

import br.com.system.app.features.cliente.model.ClienteTag;
import br.com.system.app.features.cliente.service.ClienteTagService;
import br.com.system.app.features.estrutura.dto.EstruturaBIDTO;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.model.EstruturaTipo;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.EstruturaRepository;
import br.com.system.app.features.estrutura.repository.EstruturaTipoRepository;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.kanbanpedidos.model.KanbanPedidos;
import br.com.system.app.features.kanbanpedidos.service.KanbanPedidosService;
import br.com.system.app.features.modeloproposta.model.ModeloProposta;
import br.com.system.app.features.modeloproposta.repository.ModeloPropostaRepository;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import br.com.system.app.features.pedido.model.PedidoItemEtapa;
import br.com.system.app.features.pedido.model.PedidoTags;
import br.com.system.app.features.pedido.service.PedidoEtapaService;
import br.com.system.app.features.pedido.service.PedidoItemEtapaService;
import br.com.system.app.features.pedido.service.PedidoTagsService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.usuario.dto.UsuarioDTO;
import br.com.system.app.features.usuario.model.UsuarioPerfilEnum;
import br.com.system.app.features.usuario.model.UsuarioTag;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.app.features.usuario.service.UsuarioTagService;
import br.com.system.commons.FileUtil;
import br.com.system.commons.HashUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.ValidationUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EstruturaService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private EstruturaRepository estruturaRepository;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private EstruturaTipoRepository estruturaTipoRepository;
    @Autowired
    private PedidoEtapaService pedidoEtapaService;
    @Autowired
    private PedidoItemEtapaService pedidoItemEtapaService;
    @Autowired
    private UsuarioTagService usuarioTagService;
    @Autowired
    private PedidoTagsService pedidoTagsService;
    @Autowired
    private ClienteTagService clienteTagService;
    @Autowired
    private KanbanPedidosService kanbanPedidosService;
    @Autowired
    private EstruturaUsuarioService estruturaUsuarioService;
    @Autowired
    private ModeloPropostaRepository modeloPropostaRepository;
    @Autowired
    private EstruturaComplementoService complementoService;

    public List<Estrutura> get(String nome, String cnpj, Pageable pageable) {
        if (nome != null && !nome.isBlank()) {
            return this.estruturaRepository.findByNomeContains(nome, pageable);
        }
        if (cnpj != null && !cnpj.isBlank()) {
            return this.estruturaRepository.findByCpfCnpj(cnpj, pageable);
        }
        return this.estruturaRepository.findAll(pageable).getContent();
    }

    public long count(String nome, String cnpj) {
        if (nome != null && !nome.isBlank()) {
            return this.estruturaRepository.countByNomeContains(nome);
        }
        if (cnpj != null && !cnpj.isBlank()) {
            return this.estruturaRepository.countByCpfCnpj(cnpj);
        }
        return this.estruturaRepository.count();
    }

    public void changeStatus(Estrutura estrutura) {
        estrutura.setAtivo(!estrutura.isAtivo());
        this.save(estrutura);
    }

    public List<Long> getAtivas() {
        return this.estruturaRepository.findAtivas();
    }

    public List<Estrutura> getByStatus(Boolean status) {
        return this.estruturaRepository.findByAtivo(status);
    }

    public List<Estrutura> getAtivas(Long estruturaTipoid) {
        return this.estruturaRepository.findByEstruturaTipoIdAndAtivo(estruturaTipoid, true);
    }

    public List<Estrutura> getAtivas(EstruturaTipo et) {
        return this.estruturaRepository.findByEstruturaTipoIdAndAtivo(et.getId(), true);
    }

    @Transactional
    public Estrutura add(Estrutura estrutura, EstruturaComplemento complemento, EstruturaUsuario euContext) {
        try {
            estrutura.setCpfCnpj(StringUtil.numbersOnly((String)estrutura.getCpfCnpj()));
            if (estrutura.getId() != null) {
                throw new BusinessException("Incluindo estrutura com id setado???");
            }
            if (estrutura.getNome().isEmpty()) {
                throw new BusinessException("Dominio obrigatorio");
            }
            String nome = StringUtil.removeWhitelines((String)estrutura.getNome().trim().toLowerCase());
            if (this.estruturaRepository.findByNome(nome) != null) {
                throw new BusinessException("Dominio em uso");
            }
            if (estrutura.getEstruturaTipo() == null) {
                estrutura.setEstruturaTipo(euContext.getEstrutura().getEstruturaTipo());
            }
            estrutura = this.save(estrutura);
            complemento.setUsuarioMaster(this.usuarioService.insertMaster(estrutura).toUsuario());
            complemento.setTokenIntegration(HashUtil.getUUI());
            this.complementoService.save(complemento);
            this.setDefaultParameters(estrutura);
        }
        catch (Exception e) {
            estrutura.setId(null);
            throw e;
        }
        return estrutura;
    }

    public Estrutura getByNome(String nome) {
        return this.estruturaRepository.findByNome(nome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDefaultParameters(Estrutura estrutura) {
        EstruturaUsuario euMaster = this.estruturaUsuarioService.getMasterEstrutura(estrutura);
        Estrutura modelo = this.estruturaRepository.findByNome("modelo" + estrutura.getEstruturaTipo().getNome());
        if (modelo == null) {
            return;
        }
        List modeloEtapa = this.pedidoEtapaService.getAllAtivos(modelo);
        for (Object pe : modeloEtapa) {
            PedidoEtapa newPe = new PedidoEtapa();
            BeanUtils.copyProperties((Object)pe, (Object)newPe, (String[])new String[]{"id"});
            newPe.setAtivo(true);
            newPe.setEstrutura(estrutura);
            this.pedidoEtapaService.salvar(newPe, estrutura);
        }
        List modeloEtapaItem = this.pedidoItemEtapaService.getAllAtivos(modelo);
        for (Object pie : modeloEtapaItem) {
            PedidoItemEtapa newPie = new PedidoItemEtapa();
            BeanUtils.copyProperties((Object)pie, (Object)newPie, (String[])new String[]{"id"});
            newPie.setAtivo(true);
            newPie.setEstrutura(estrutura);
            this.pedidoItemEtapaService.salvar(newPie);
        }
        List modeloUsuarioTag = this.usuarioTagService.getTags(modelo);
        for (Object ut : modeloUsuarioTag) {
            try {
                if (ut.getTag().isBlank() || ut.getUsuario().isMaster()) continue;
                UsuarioTag newUt = new UsuarioTag();
                newUt.setTag(ut.getTag());
                newUt.setEstrutura(estrutura);
                newUt.setUsuario(euMaster.getUsuario());
                this.usuarioTagService.save(newUt);
            }
            catch (Exception newUt) {}
        }
        List modeloPedidoTag = this.pedidoTagsService.getAllTags(modelo);
        for (Object pt : modeloPedidoTag) {
            PedidoTags newPt = new PedidoTags();
            BeanUtils.copyProperties((Object)pt, (Object)newPt, (String[])new String[]{"id"});
            newPt.setEstrutura(estrutura);
            newPt.setUsuario(euMaster.getUsuario());
            this.pedidoTagsService.save(newPt);
        }
        List modeloClienteTag = this.clienteTagService.getTags(modelo);
        for (ClienteTag ct : modeloClienteTag) {
            ClienteTag newCt = new ClienteTag();
            BeanUtils.copyProperties((Object)ct, (Object)newCt, (String[])new String[]{"id"});
            newCt.setEstrutura(estrutura);
            newCt.setUsuario(euMaster.getUsuario());
            this.clienteTagService.save(newCt);
        }
        for (HierarquiaDTO h : this.estruturaUsuarioService.getAtivosByEstrutura(modelo)) {
            if (h.isMaster()) continue;
            UsuarioDTO dto = new UsuarioDTO();
            dto.setAtivo(Boolean.TRUE);
            dto.setCelular("");
            dto.setDataCadastro(LocalDate.now());
            dto.setEmail(h.getEmail());
            dto.setLogin(h.getLogin().replace("modelo" + estrutura.getEstruturaTipo().getNome().toLowerCase(), estrutura.getNome()));
            dto.setMaster(Boolean.valueOf(false));
            dto.setNome(h.getUsuarioNome());
            dto.setPerfil(UsuarioPerfilEnum.valueOf((String)h.getPerfil()));
            dto.setRules(h.getRules());
            dto.setSaldo(BigDecimal.ZERO);
            dto.setTags(h.getTags());
            dto = this.usuarioService.saveAndCreate(dto, estrutura, this.estruturaUsuarioService.getById(h.getEstruturaUsuarioId()));
            EstruturaUsuario eu = this.estruturaUsuarioService.getById(dto.getEstruturaUsuarioId());
            for (KanbanPedidos kp : this.kanbanPedidosService.getAllKanban(h.getEstruturaUsuarioId())) {
                List lpe = this.pedidoEtapaService.getAtivos(estrutura, kp.getPedidoEtapa().getNome(), kp.getPedidoEtapa().getPedidoTipo());
                if (lpe == null || lpe.size() <= 0) continue;
                KanbanPedidos kpNew = new KanbanPedidos();
                kpNew.setEstruturaUsuario(eu);
                kpNew.setPedidoEtapa((PedidoEtapa)lpe.get(0));
                kpNew.setPosition(kp.getPosition());
                kpNew.setNome(kp.getNome());
                kpNew.setBackgroundColor(kp.getBackgroundColor());
                this.kanbanPedidosService.save(kpNew);
            }
        }
        List modeloProposta = this.modeloPropostaRepository.findByEstruturaAndAtivo(modelo, Boolean.TRUE);
        for (ModeloProposta mp : modeloProposta) {
            ModeloProposta mpNew = new ModeloProposta();
            mpNew.setAtivo(Boolean.TRUE);
            mpNew.setConteudoHtml(mp.getConteudoHtml());
            mpNew.setEstrutura(estrutura);
            if (!mp.getHashImages().isBlank()) {
                String[] arr = mp.getHashImages().split(",");
                HashSet<CallSite> imgs = new HashSet<CallSite>();
                for (String img : arr) {
                    InputStream is = null;
                    try {
                        String newHash = HashUtil.getUUI() + FileUtil.getExtension((String)img);
                        is = StorageUtil.getObject((String)img);
                        StorageUtil.uploadObjectInputStream((String)newHash, (String)FileUtil.getContentType((String)img), (InputStream)is);
                        imgs.add((CallSite)((Object)newHash));
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                mpNew.setHashImages(StringUtils.join(imgs, (String)","));
            }
            mpNew.setNome(mp.getNome());
            this.modeloPropostaRepository.save((Object)mpNew);
        }
    }

    @Transactional
    public Estrutura save(Estrutura estrutura) {
        Estrutura estruturaSalva = this.getById(estrutura.getId());
        if (estruturaSalva != null && !estrutura.getEstruturaTipo().getId().equals(estruturaSalva.getEstruturaTipo().getId())) {
            throw new BusinessException("Imposs\u00edvel alterar o tipo da estrutura.");
        }
        if (estrutura.getEstruturaTipo() == null || estrutura.getEstruturaTipo() == null || estrutura.getEstruturaTipo().getId() <= 0L) {
            throw new BusinessException("Tipo da estrutura \u00e9 obrigatorio.");
        }
        if (!ValidationUtil.isValidCnpjAndCpf((String)estrutura.getCpfCnpj())) {
            throw new BusinessException("Cpf/Cnpj est\u00e1 inv\u00e1lido");
        }
        estrutura.setDataHoraAtualizacao(LocalDateTime.now());
        return (Estrutura)this.estruturaRepository.save((Object)estrutura);
    }

    public Estrutura getById(Long id) {
        if (id == null) {
            return null;
        }
        return this.estruturaRepository.findById((Object)id).orElse(null);
    }

    public List<EstruturaTipo> getEstruturaTipo() {
        return this.estruturaTipoRepository.findAll();
    }

    public List<Estrutura> getByCnpjCobranca(String cnpjCobranca) {
        return this.estruturaRepository.findByCpfCnpjAndAtivo(cnpjCobranca, Boolean.TRUE);
    }

    public List<EstruturaBIDTO> getForBI() {
        return this.estruturaRepository.findForBi();
    }

    @Transactional
    public Estrutura changeName(Estrutura estrutura, String newName) {
        if ((newName = newName.replaceAll(" ", "").trim().toLowerCase()).isEmpty()) {
            throw new BusinessException("Dominio inv\u00e1lido");
        }
        if (this.getByNome(newName) != null) {
            throw new BusinessException("Este dominio j\u00e1 est\u00e1 em uso");
        }
        this.usuarioService.changeDomain(estrutura, "@" + estrutura.getNome(), "@" + newName);
        estrutura.setNome(newName);
        this.estruturaRepository.changeDomain(estrutura.getId(), newName);
        return estrutura;
    }
}

