/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.estrutura.views;

import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.cep.model.CepLocalidade;
import br.com.system.app.features.cep.model.CepUf;
import br.com.system.app.features.cep.service.CepService;
import br.com.system.app.features.cobranca.model.CobrancaAssinatura;
import br.com.system.app.features.cobranca.service.CobrancaAssinaturaService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.model.EstruturaTipo;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.estrutura.service.EstruturaService;
import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.mailing.model.Mailing;
import br.com.system.app.features.mailing.service.MailingService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.StringUtil;
import br.com.system.commons.ValidationUtil;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class EstruturaFormView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    @Autowired
    private EstruturaService es;
    @Autowired
    private EstruturaComplementoService ecs;
    @Autowired
    private MailingService mailingService;
    @Autowired
    private CobrancaAssinaturaService cobrancaAssinaturaService;
    @Autowired
    private CepService cepService;
    private TextField cpfCnpj;
    private TextField razaoSocial;
    private TextField proxyPort;
    private TextField proxyServer;
    private TextField urlBi;
    private TextField emailSendler;
    private ComboBox<CobrancaAssinatura> cbAssinatura;
    private NumberField limiteOportunidade;
    private RadioButtonGroup<String> ativo;
    private RadioButtonGroup<String> oportunidadeVelho;
    private RadioButtonGroup<String> oportunidadeAuto;
    private RadioButtonGroup<String> enviarEmailTroca;
    private RadioButtonGroup<String> mostrarAtividadeVinculada;
    private ComboBox<EstruturaTipo> cbTipo;
    private MultiComboBox<CepLocalidade> cbCidades;
    private TextField nome;
    private ComboBox<CepUf> cbUf;
    private TextField txtInstancia;
    private NumberField txtValorEnriquecimento;
    private Checkbox cbObrigaTagRetornoFuturo;
    private TextField nomeCampoCategoria;
    private TextField nomeCampoSubCategoria;
    private Checkbox cbObrigaCategoria;
    private Checkbox cbObrigaSubCategoria;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public void create(Estrutura estrutura) {
        this.setWidth("600px");
        this.removeAll();
        if (estrutura == null) {
            UIUtils.showNotification((String)"Estrutura = null");
            return;
        }
        EstruturaComplemento estruturaComplemento = estrutura.getId() == null ? new EstruturaComplemento() : this.ecs.getComplementos(estrutura);
        this.cbTipo = new ComboBox("Tipo Estrutura", (Collection)this.es.getEstruturaTipo());
        this.cbTipo.setItemLabelGenerator(EstruturaTipo::getNome);
        if (estrutura.getId() != null) {
            this.cbTipo.setEnabled(false);
            this.cbTipo.setValue((Object)estrutura.getEstruturaTipo());
        }
        this.cbObrigaTagRetornoFuturo = new Checkbox("Obriga Tag Retorno Futuro");
        if (estruturaComplemento.getObrigaTagRetornoFuturo() != null) {
            this.cbObrigaTagRetornoFuturo.setValue((Object)estruturaComplemento.getObrigaTagRetornoFuturo());
        } else {
            this.cbObrigaTagRetornoFuturo.setValue((Object)true);
        }
        this.nome = this.createField("Nome", estrutura.getNome());
        this.nome.setReadOnly(estrutura.getId() != null);
        VerticalContainer v = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        this.cpfCnpj = this.createField("CPF-CNPJ", estrutura.getCpfCnpj());
        this.razaoSocial = this.createField("Raz\u00e3o Social", estrutura.getRazaoSocial());
        this.cbCidades = new MultiComboBox("Cidades Oportunidades");
        this.cbCidades.setItemLabelGenerator(CepLocalidade::getNome);
        this.cbUf = new ComboBox("UF Estrutura", (Collection)this.cepService.getUf());
        this.cbUf.setItemLabelGenerator(CepUf::getSigla);
        this.cbUf.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.povoaCidade((CepUf)e.getValue(), estruturaComplemento.getOportunidadeCidades()));
        if (estrutura.getEstado() != null) {
            this.cbUf.setValue((Object)this.cepService.getUfBySigla(estrutura.getEstado()));
        }
        this.cpfCnpj.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (StringUtil.numbersOnly((String)((String)e.getValue())).length() == 14) {
                ((TextField)e.getSource()).setValue(StringUtil.numbersOnly((String)((String)e.getValue())));
                Mailing m = this.mailingService.buscarCnpj(StringUtil.numbersOnly((String)((String)e.getValue())));
                if (m != null) {
                    this.razaoSocial.setValue(m.getNome());
                    this.cbUf.setValue((Object)this.cepService.getUfBySigla(m.getEstado()));
                }
            }
        });
        this.txtInstancia = new TextField("Instancia Whatsapp Marketing");
        if (estruturaComplemento.getInstanceChatapi() != null) {
            this.txtInstancia.setValue(estruturaComplemento.getInstanceChatapi());
        }
        TextField txtBloqueio = new TextField("Bloqueio Financeiro");
        txtBloqueio.setReadOnly(true);
        txtBloqueio.setValue("BLOQUEADO");
        Icon icon = new Icon(VaadinIcon.BAN);
        icon.setColor(Color.RED.getValue());
        HorizontalContainer bloqueio = new HorizontalContainer(new com.vaadin.flow.component.Component[]{txtBloqueio, icon});
        bloqueio.setVisible(estruturaComplemento.getCobrancaAssinatura() != null && estruturaComplemento.getCobrancaAssinatura().isBloqueado());
        this.ativo = new RadioButtonGroup();
        this.ativo.setLabel("Situa\u00e7\u00e3o");
        this.ativo.setItems((Object[])new String[]{"Ativo", "Inativo"});
        if (estrutura.getId() == null || estrutura.isAtivo()) {
            this.ativo.setValue((Object)"Ativo");
        } else {
            this.ativo.setValue((Object)"Inativo");
        }
        this.oportunidadeVelho = new RadioButtonGroup();
        this.oportunidadeVelho.setLabel("Oportunidade Antigo");
        this.oportunidadeVelho.setItems((Object[])new String[]{"SIM", "N\u00c3O"});
        if (estruturaComplemento.isOportunidadeVelho()) {
            this.oportunidadeVelho.setValue((Object)"SIM");
        } else {
            this.oportunidadeVelho.setValue((Object)"N\u00c3O");
        }
        this.oportunidadeAuto = new RadioButtonGroup();
        this.oportunidadeAuto.setLabel("Oportunidade Auto");
        this.oportunidadeAuto.setItems((Object[])new String[]{"SIM", "N\u00c3O"});
        if (estruturaComplemento.isOportunidadeAuto()) {
            this.oportunidadeAuto.setValue((Object)"SIM");
        } else {
            this.oportunidadeAuto.setValue((Object)"N\u00c3O");
        }
        if (estrutura.getId() != null) {
            TextField id = new TextField("ID");
            id.setValue(estrutura.getId().toString());
            id.setReadOnly(true);
            v.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{id, bloqueio})});
        }
        List assinaturas = this.cobrancaAssinaturaService.getAssinaturas();
        this.cbAssinatura = new ComboBox("Assinatura", (Collection)assinaturas);
        this.cbAssinatura.setWidth("300px");
        this.cbAssinatura.setItemLabelGenerator(CobrancaAssinatura::getCpfCnpjAndNomeAndAtivo);
        if (estruturaComplemento.getCobrancaAssinatura() != null && assinaturas.contains(estruturaComplemento.getCobrancaAssinatura())) {
            this.cbAssinatura.setValue((Object)estruturaComplemento.getCobrancaAssinatura());
        }
        this.txtValorEnriquecimento = new NumberField("Valor Enriquecimento");
        if (estruturaComplemento.getValorEnriquecimento() != null) {
            this.txtValorEnriquecimento.setValue((Number)estruturaComplemento.getValorEnriquecimento().doubleValue());
        } else {
            this.txtValorEnriquecimento.setValue((Number)Double.valueOf("0.05"));
        }
        this.enviarEmailTroca = new RadioButtonGroup();
        this.enviarEmailTroca.setLabel("Enviar Email Troca Propriet\u00e1rio");
        this.enviarEmailTroca.setItems((Object[])new String[]{"SIM", "N\u00c3O"});
        if (estruturaComplemento.getId() == null || estruturaComplemento.getEnviarEmailTrocaProprietario().booleanValue()) {
            this.enviarEmailTroca.setValue((Object)"SIM");
        } else {
            this.enviarEmailTroca.setValue((Object)"N\u00c3O");
        }
        this.limiteOportunidade = new NumberField("Limite Oportunidade");
        if (estruturaComplemento.getLimiteDiarioOportunidade() != null) {
            this.limiteOportunidade.setValue((Number)estruturaComplemento.getLimiteDiarioOportunidade().doubleValue());
        }
        this.mostrarAtividadeVinculada = new RadioButtonGroup();
        this.mostrarAtividadeVinculada.setLabel("Mostrar Atividade Vinculada");
        this.mostrarAtividadeVinculada.setItems((Object[])new String[]{"SIM", "N\u00c3O"});
        if (estruturaComplemento.getId() == null || estruturaComplemento.isMostrarAtividadeVinculada()) {
            this.mostrarAtividadeVinculada.setValue((Object)"SIM");
        } else {
            this.mostrarAtividadeVinculada.setValue((Object)"N\u00c3O");
        }
        this.proxyServer = new TextField("Proxy Server");
        if (estruturaComplemento.getProxyServer() != null) {
            this.proxyServer.setValue(estruturaComplemento.getProxyServer());
        }
        this.proxyPort = new TextField("Proxy Port");
        if (estruturaComplemento.getProxyPort() != null) {
            this.proxyPort.setValue(estruturaComplemento.getProxyPort().toString());
        }
        this.urlBi = new TextField("Url BI");
        if (estruturaComplemento.getUrlBi() != null) {
            this.urlBi.setValue(estruturaComplemento.getUrlBi());
        }
        this.nomeCampoCategoria = new TextField("Titulo Campo Categoria atividade");
        this.nomeCampoCategoria.setWidth("300px");
        if (estruturaComplemento.getNomeCampoCategoria() != null) {
            this.nomeCampoCategoria.setValue(estruturaComplemento.getNomeCampoCategoria());
        }
        this.cbObrigaCategoria = new Checkbox("Obriga Categoria Atividade");
        if (estruturaComplemento.getObrigaCampoCategoria() != null) {
            this.cbObrigaCategoria.setValue((Object)estruturaComplemento.getObrigaCampoCategoria());
        }
        this.nomeCampoSubCategoria = new TextField("Titulo Campo Sub Categoria atividade");
        this.nomeCampoSubCategoria.setWidth("300px");
        if (estruturaComplemento.getNomeCampoSubCategoria() != null) {
            this.nomeCampoSubCategoria.setValue(estruturaComplemento.getNomeCampoSubCategoria());
        }
        this.cbObrigaSubCategoria = new Checkbox("Obriga Sub Categoria Atividade");
        if (estruturaComplemento.getObrigaCampoSubCategoria() != null) {
            this.cbObrigaSubCategoria.setValue((Object)estruturaComplemento.getObrigaCampoSubCategoria());
        }
        this.emailSendler = new TextField("Email Envio Parceiro");
        if (estruturaComplemento.getEmailSendler() != null) {
            this.emailSendler.setValue(estruturaComplemento.getEmailSendler());
        }
        TextField tokenIntegration = new TextField("Token Integration");
        tokenIntegration.setReadOnly(true);
        tokenIntegration.setVisible(estruturaComplemento.getTokenIntegration() != null);
        tokenIntegration.setValue(estruturaComplemento.getTokenIntegration() == null ? "" : estruturaComplemento.getTokenIntegration());
        Button btnFechar = UIUtils.createSmallButton((String)"Fechar");
        btnFechar.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        Button btnSalvar = UIUtils.createSmallButton((String)"Salvar");
        btnSalvar.addClickListener((ComponentEventListener & Serializable)e -> {
            String erros = this.getFormErros(estrutura);
            if (erros.isEmpty()) {
                this.salvar(estrutura, estruturaComplemento);
                UIUtils.showNotification((String)"Salvo com sucesso");
                this.close();
            } else {
                UIUtils.showNotification((String)erros);
            }
        });
        v.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.cbTipo, this.nome, this.cpfCnpj, this.razaoSocial, this.ativo, this.cbUf})});
        v.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Complementos")});
        v.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.cbAssinatura, this.enviarEmailTroca, this.mostrarAtividadeVinculada, this.oportunidadeVelho, this.oportunidadeAuto, this.txtValorEnriquecimento, this.cbCidades})});
        v.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.limiteOportunidade, tokenIntegration, this.emailSendler, this.cbObrigaTagRetornoFuturo})});
        v.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.nomeCampoCategoria, this.cbObrigaCategoria, this.nomeCampoSubCategoria, this.cbObrigaSubCategoria})});
        v.add(new com.vaadin.flow.component.Component[]{new FooterContainer(new com.vaadin.flow.component.Component[]{btnFechar, btnSalvar})});
        this.add(new com.vaadin.flow.component.Component[]{v});
        this.open();
    }

    private Estrutura salvar(Estrutura estrutura, EstruturaComplemento estruturaComplemento) {
        estruturaComplemento.setCobrancaAssinatura((CobrancaAssinatura)this.cbAssinatura.getValue());
        estruturaComplemento.setEnviarEmailTrocaProprietario(Boolean.valueOf(((String)this.enviarEmailTroca.getValue()).equals("SIM")));
        estruturaComplemento.setEstrutura(estrutura);
        estruturaComplemento.setLimiteDiarioOportunidade(this.limiteOportunidade.getValue() == null ? null : Integer.valueOf(((Double)this.limiteOportunidade.getValue()).intValue()));
        estruturaComplemento.setMostrarAtividadeVinculada(((String)this.mostrarAtividadeVinculada.getValue()).equals("SIM"));
        estruturaComplemento.setProxyPort(this.proxyPort.getValue() == null ? null : Integer.valueOf(StringUtil.toInt((String)this.proxyPort.getValue())));
        estruturaComplemento.setProxyServer(this.proxyServer.getValue());
        estruturaComplemento.setUrlBi(this.urlBi.getValue());
        estruturaComplemento.setInstanceChatapi(StringUtil.numbersOnly((String)this.txtInstancia.getValue()));
        estruturaComplemento.setOportunidadeVelho(((String)this.oportunidadeVelho.getValue()).equals("SIM"));
        estruturaComplemento.setOportunidadeAuto(((String)this.oportunidadeAuto.getValue()).equals("SIM"));
        estruturaComplemento.setValorEnriquecimento(BigDecimal.valueOf((Double)this.txtValorEnriquecimento.getValue()));
        estruturaComplemento.setObrigaTagRetornoFuturo((Boolean)this.cbObrigaTagRetornoFuturo.getValue());
        estruturaComplemento.setNomeCampoCategoria(this.nomeCampoCategoria.getValue());
        estruturaComplemento.setNomeCampoSubCategoria(this.nomeCampoSubCategoria.getValue());
        estruturaComplemento.setObrigaCampoCategoria((Boolean)this.cbObrigaCategoria.getValue());
        estruturaComplemento.setObrigaCampoSubCategoria((Boolean)this.cbObrigaSubCategoria.getValue());
        estruturaComplemento.setEmailSendler(this.emailSendler.getValue());
        if (!this.cbCidades.getValue().isEmpty()) {
            ArrayList cidades = new ArrayList();
            this.cbCidades.getValue().forEach(e -> cidades.add(e.getNome()));
            estruturaComplemento.setOportunidadeCidades(String.join((CharSequence)",", cidades));
        } else {
            estruturaComplemento.setOportunidadeCidades(null);
        }
        estrutura.setAtivo(((String)this.ativo.getValue()).equals("Ativo"));
        estrutura.setCpfCnpj(this.cpfCnpj.getValue());
        estrutura.setRazaoSocial(this.razaoSocial.getValue());
        estrutura.setEstado(((CepUf)this.cbUf.getValue()).getSigla());
        if (estrutura.getId() == null) {
            estrutura.setEstruturaTipo((EstruturaTipo)this.cbTipo.getValue());
            estrutura.setNome(this.nome.getValue());
            estrutura = this.es.add(estrutura, estruturaComplemento, this.getEu());
        } else {
            estrutura = this.es.save(estrutura);
            this.ecs.save(estruturaComplemento);
        }
        return estrutura;
    }

    private String getFormErros(Estrutura estrutura) {
        Object retorno = "";
        if (this.txtValorEnriquecimento.getValue() == null || (Double)this.txtValorEnriquecimento.getValue() <= 0.0) {
            retorno = (String)retorno + "Valor enriquecimento obrigatorio\n";
        }
        if (this.cbTipo.getValue() == null) {
            retorno = (String)retorno + "Estrutura Tipo Inv\u00e1lido\n";
        }
        if (this.cbUf.getValue() == null) {
            retorno = (String)retorno + "Estado \u00e9 obrigatorio.\n";
        }
        if (this.nome.getValue() == null || this.nome.getValue().isBlank() || this.nome.getValue().length() < 2) {
            retorno = (String)retorno + "Nome inv\u00e1lido\n";
        } else if (estrutura.getId() == null && this.es.getByNome(this.nome.getValue()) != null) {
            retorno = (String)retorno + "Este nome j\u00e1 est\u00e1 em uso";
        }
        if (!ValidationUtil.isValidCnpjAndCpf((String)this.cpfCnpj.getValue())) {
            retorno = (String)retorno + "CPF-CNPJ Inv\u00e1lido\n";
        }
        if (this.razaoSocial.getValue() == null || this.razaoSocial.getValue().isBlank()) {
            retorno = (String)retorno + "Raz\u00e3o social inv\u00e1lida\n";
        }
        if (this.cbAssinatura.getValue() == null) {
            retorno = (String)retorno + "Selecione uma assinatura\n";
        }
        if (this.cbAssinatura.getValue() != null && !((CobrancaAssinatura)this.cbAssinatura.getValue()).getCpfCnpj().equals(this.cpfCnpj.getValue())) {
            retorno = (String)retorno + "Cnpj da estrutura n\u00e3o bate com CNPJ da assinatura\n";
        }
        if (((String)this.oportunidadeVelho.getValue()).equals("SIM") && ((String)this.oportunidadeAuto.getValue()).equals("SIM")) {
            retorno = (String)retorno + "Oportunidade velho n\u00e3o pode ser autom\u00e1tico\n";
        }
        return retorno;
    }

    private TextField createField(String label, String value) {
        TextField tf = new TextField(label);
        if (value != null) {
            tf.setValue(value);
        }
        return tf;
    }

    private void povoaCidade(CepUf value, String cidades) {
        this.cbCidades.setItems((Collection)this.cepService.getLocalidadeByUf(value));
        if (cidades == null || cidades.isEmpty()) {
            return;
        }
        String[] arr = cidades.split(",");
        HashSet<CepLocalidade> locs = new HashSet<CepLocalidade>();
        for (String c : arr) {
            CepLocalidade loc = this.cepService.getLocalidadeByNome(value, c);
            locs.add(loc);
        }
        this.cbCidades.setValue(locs);
    }
}

