/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.estrutura.views;

import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaSenhas;
import br.com.system.app.features.estrutura.service.EstruturaSenhasService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.sistemasexternos.model.SistemasExternos;
import br.com.system.app.features.sistemasexternos.repository.SistemasExternosRepository;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import java.util.Collection;

public class EstruturaSenhasFormView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final EstruturaSenhas es;
    private final SistemasExternosRepository ser;
    private final Estrutura estrutura;
    private final EstruturaSenhasService ess;

    public EstruturaSenhasFormView(Estrutura estrutura, EstruturaSenhas es, SistemasExternosRepository ser, EstruturaSenhasService ess) {
        this.es = es;
        this.ser = ser;
        this.ess = ess;
        this.estrutura = estrutura;
    }

    public void create() {
        if (this.es == null) {
            UIUtils.showNotification((String)"ES null");
            return;
        }
        TextField nome = new TextField("Nome");
        if (this.es.getNome() != null) {
            nome.setValue(this.es.getNome());
        }
        ComboBox cbSistemas = new ComboBox("Sistema", (Collection)this.ser.findByEstruturaTipo(this.estrutura.getEstruturaTipo()));
        if (this.es.getSistemasExternos() != null) {
            cbSistemas.setValue((Object)this.es.getSistemasExternos());
        }
        RadioButtonGroup rbAtivo = new RadioButtonGroup();
        rbAtivo.setItems((Object[])new String[]{"Ativo", "Inativo"});
        if (this.es.getId() == null || !this.es.getAtivo().booleanValue()) {
            rbAtivo.setValue((Object)"Inativo");
        } else {
            rbAtivo.setValue((Object)"Ativo");
        }
        TextField login = new TextField("Login");
        if (this.es.getLogin() != null) {
            login.setValue(this.es.getLogin());
        }
        RadioButtonGroup rbSc = new RadioButtonGroup();
        rbSc.setItems((Object[])new String[]{"Sim", "N\u00e3o"});
        if (this.es.getId() == null || !this.es.getSenhaCorreta().booleanValue()) {
            rbSc.setValue((Object)"N\u00e3o");
        } else {
            rbSc.setValue((Object)"Sim");
        }
        VerticalContainer v = new VerticalContainer(new Component[0]);
        v.add(new Component[]{nome, cbSistemas, rbAtivo, login});
        this.add(new Component[]{v});
        Button btnFechar = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE, (String)"Fechar tela");
        btnFechar.addClickListener((ComponentEventListener & Serializable)close -> this.close());
        Button btnSalvar = UIUtils.createSmallButton((String)"Salvar", (VaadinIcon)VaadinIcon.INBOX, (String)"Salvar");
        btnSalvar.setEnabled(this.hasPermission("ESTRUTURA_SENHAS_SAVE"));
        btnSalvar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (nome.getValue() == null || nome.getValue().isBlank()) {
                UIUtils.showNotification((String)"Nome \u00e9 obrigatorio");
                return;
            }
            if (this.estrutura == null) {
                UIUtils.showNotification((String)"Estrutura \u00e9 obrigatorio");
                return;
            }
            if (login.getValue() == null || nome.getValue().isBlank()) {
                UIUtils.showNotification((String)"Login \u00e9 obrigatorio");
                return;
            }
            this.es.setAtivo(Boolean.valueOf(((String)rbAtivo.getValue()).equals("Ativo")));
            this.es.setEstrutura(this.estrutura);
            this.es.setLogin(login.getValue().replace(" ", ""));
            this.es.setSistemasExternos((SistemasExternos)cbSistemas.getValue());
            this.es.setNome(nome.getValue());
            this.es.setSenha(null);
            this.es.setSenhaCorreta(Boolean.valueOf(((String)rbSc.getValue()).equals("Sim")));
            this.ess.save(this.es);
            this.close();
        });
        v.add(new Component[]{new FooterContainer(new Component[]{btnFechar, btnSalvar})});
        this.open();
    }
}

