/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.importacoes;

import br.com.system.app.MainLayout;
import br.com.system.app.features.importacoes.model.Importacoes;
import br.com.system.app.features.importacoes.model.ImportacoesTipoEnum;
import br.com.system.app.features.importacoes.service.ImportacoesService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="importacao-cadastro", layout=MainLayout.class)
@PageTitle(value="Cadastro colunas importacao")
@RolesAllowed(value={"MASTER"})
public class ImportacoesColunasView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final ImportacoesService is;
    private GridCrud<Importacoes> crud;
    private ComboBox<ImportacoesTipoEnum> cbTipoFilter;

    @Autowired
    public ImportacoesColunasView(ImportacoesService is) {
        this.is = is;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado() && this.isMaster()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        this.cbTipoFilter = new ComboBox("Tipo Importa\u00e7\u00e3o");
        this.cbTipoFilter.setItems((Object[])ImportacoesTipoEnum.values());
        this.cbTipoFilter.setItemLabelGenerator(Enum::name);
        this.cbTipoFilter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.crud.refreshGrid());
        this.crud = new GridCrud(Importacoes.class);
        this.crud.getCrudLayout().addToolbarComponent((Component)this.cbTipoFilter);
        this.crud.getAddButton().setText("Adicionar");
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getTipo().name()))).setHeader("Tipo").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getCampo().name()))).setHeader("Campo").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getNome()))).setHeader("Nome Coluna").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getPosicao().toString()));
        this.crud.getGrid().setColumnReorderingAllowed(true);
        this.crud.getCrudFormFactory().setUseBeanValidation(true);
        this.crud.getCrudFormFactory().setVisibleProperties(new String[]{"nome", "posicao"});
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(true);
        this.crud.getDeleteButton().setVisible(false);
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.crud;
    }
}

