/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.importacoes.service;

import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.importacoes.dto.VivoPedidoDTO;
import br.com.system.app.features.importacoes.dto.VivoPedidoItemDTO;
import br.com.system.app.features.importacoes.model.ImportacoesTipoEnum;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import br.com.system.app.features.pedido.model.PedidoItem;
import br.com.system.app.features.pedido.model.PedidoItemSolicitacao;
import br.com.system.app.features.pedido.model.PedidoOrigem;
import br.com.system.app.features.pedido.model.PedidoTipoNegociacaoEnum;
import br.com.system.app.features.pedido.repository.PedidoItemSolicitacaoRepository;
import br.com.system.app.features.pedido.service.PedidoDeleteService;
import br.com.system.app.features.pedido.service.PedidoEtapaService;
import br.com.system.app.features.pedido.service.PedidoItemEtapaService;
import br.com.system.app.features.pedido.service.PedidoItemService;
import br.com.system.app.features.pedido.service.PedidoOrigemService;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.produto.model.Produto;
import br.com.system.app.features.produto.model.ProdutoOrigem;
import br.com.system.app.features.produto.service.ProdutoCategoriaService;
import br.com.system.app.features.produto.service.ProdutoService;
import br.com.system.commons.StringUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImportacaoPersistService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String NOVO = "NOVO";
    private final String PORTADO = "PORTADO";
    private final String MIGRACAO = "MIGRACAO";
    private final String TROCA = "TROCA";
    private final String RENOVACAO = "RENOVACAO";
    private final String MIGRACAO_PP = "MIGRACAO PP";
    private final String TT = "TT";
    private final String MIGRACAO_TROCA = "MIGRACAO + TROCA";
    private final String ATIVACAO_SERVICO = "ATIVA\u00c7\u00c3O DE SERVI\u00c7O";
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private PedidoEtapaService pedidoEtapaService;
    @Autowired
    private PedidoOrigemService origemService;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private PedidoItemEtapaService pedidoItemEtapaService;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private ProdutoCategoriaService produtoCategoriaService;
    @Autowired
    private PedidoItemSolicitacaoRepository pedidoItemSolicitacaoRepository;
    @Autowired
    private PedidoItemService pedidoItemService;
    @Autowired
    private PedidoDeleteService pedidoDeleteService;

    public String gravar(Set<VivoPedidoDTO> lista, EstruturaUsuario eu, EstruturaUsuario master, boolean forcar, ImportacoesTipoEnum tipo) {
        StringBuilder log = new StringBuilder();
        PedidoOrigem origemVivocorp = this.origemService.getOrigemByNome(master.getEstrutura().getEstruturaTipo(), this.getNomeOrigem(tipo));
        for (VivoPedidoDTO d : lista) {
            try {
                Pedido pedido = null;
                if ((pedido = pedido == null && tipo.equals((Object)ImportacoesTipoEnum.VIVO_MVP) ? this.getPedidoMvp(d, eu, log) : this.getPedido(d, eu, log)) == null && tipo.equals((Object)ImportacoesTipoEnum.VIVO_MVP)) continue;
                if (pedido == null || forcar) {
                    this.createAndUpdate(master, pedido, d, null, origemVivocorp, tipo);
                    continue;
                }
                LocalDate data = pedido.getDataHoraOperadora() == null ? pedido.getDataHoraAtualizacao().toLocalDate() : pedido.getDataHoraOperadora().toLocalDate();
                PedidoEtapa pedidoEtapa = this.pedidoEtapaService.getAndCreate(master.getEstrutura(), d.getStatus(), pedido.getPedidoOrigem(), pedido.getPedidoTipo());
                if (d.getDataAtualizacao().isAfter(data) || !pedido.getPedidoEtapa().getId().equals(pedidoEtapa.getId())) {
                    this.createAndUpdate(master, pedido, d, pedidoEtapa, origemVivocorp, tipo);
                    continue;
                }
                Set itens = this.pedidoService.getItens(pedido);
                if (itens.size() != d.getItens().size()) {
                    this.createAndUpdate(master, pedido, d, pedidoEtapa, origemVivocorp, tipo);
                    continue;
                }
                for (PedidoItem item : itens) {
                    boolean atualizar = false;
                    for (VivoPedidoItemDTO id : d.getItens()) {
                        String numero = item.getNumero() == null ? "" : item.getNumero();
                        if (!numero.equals(id.getNumeroLinha()) || !item.getProduto().getNome().equals(id.getPlano()) || item.getPedidoItemEtapa().getNome().equals(id.getStatusLinha())) continue;
                        atualizar = true;
                        break;
                    }
                    if (!atualizar) continue;
                    this.createAndUpdate(master, pedido, d, pedidoEtapa, origemVivocorp, tipo);
                }
            }
            catch (Exception e) {
                log.append(" Erro: ").append(e.getMessage()).append("\n");
            }
        }
        return log.toString();
    }

    private void createAndUpdate(EstruturaUsuario master, Pedido pedido, VivoPedidoDTO dto, PedidoEtapa pedidoEtapa, PedidoOrigem origemVivocorp, ImportacoesTipoEnum tipo) {
        Pedido cotacao;
        if (pedido == null) {
            pedido = new Pedido();
        }
        if (pedido.getNumeroPedidoVinculado() == null && !dto.getNumero().equals(dto.getCotacao()) && (cotacao = this.pedidoService.getByNumeroAndEstrutura(dto.getCotacao(), master.getEstrutura())) != null && !cotacao.getPedidoEtapa().getNome().toUpperCase().equals("ORDEM COLOCADA")) {
            cotacao.setPedidoEtapa(this.pedidoEtapaService.getAndCreate(master.getEstrutura(), "Ordem colocada", origemVivocorp, PedidoTipoEnum.COMERCIAL));
            this.pedidoService.salvar(cotacao, "Atualizado para ORDEM COLOCADA", master, false);
        }
        List<Pedido> origem = new ArrayList();
        if (!tipo.equals((Object)ImportacoesTipoEnum.VIVO_MVP)) {
            Pedido simula;
            Pedido cotacao2;
            origem = this.pedidoService.getByNumeroVinculado(master.getEstrutura(), dto.getNumero());
            if (origem.size() <= 0 && !dto.getCotacao().isEmpty() && (cotacao2 = this.pedidoService.getPedidoByNumeroCotacao(master, dto.getCotacao())) != null) {
                origem.add(cotacao2);
            }
            if (origem.size() <= 0 && !dto.getNumeroSimulacao().isEmpty() && (simula = this.pedidoService.getPedidoByNumeroSimulacao(master, dto.getNumeroSimulacao())) != null) {
                origem.add(simula);
            }
            if (origem.size() <= 0 && !dto.getNumero().isEmpty()) {
                List ped = this.pedidoService.getByNumeroVinculado(master.getEstrutura(), dto.getNumero());
                origem.addAll(ped);
            }
            for (Pedido ori : origem) {
                PedidoEtapa etapaOrigem;
                if (!ori.getPedidoEtapa().isSincronizavel() || (etapaOrigem = this.pedidoEtapaService.getAndCreate(ori.getEstruturaUsuario().getEstrutura(), dto.getStatus(), ori.getPedidoOrigem(), ori.getPedidoTipo())).getId().equals(ori.getPedidoEtapa().getId()) && ori.getNumeroPedidoVinculado().equals(dto.getNumero())) continue;
                Object msg = "";
                if (!etapaOrigem.getId().equals(ori.getPedidoEtapa().getId())) {
                    msg = "Atualizado de " + ori.getPedidoEtapa().getNome() + " para " + etapaOrigem.getNome();
                    ori.setPedidoEtapa(etapaOrigem);
                    ori.setDataHoraUltimaMov(LocalDateTime.now());
                    if (etapaOrigem.getAtualizaDataReferencia().booleanValue()) {
                        this.pedidoItemService.updateData(ori.getId(), LocalDate.now());
                    }
                }
                ori.setNumeroPedidoVinculado(dto.getNumero());
                if (!((String)msg).isEmpty()) {
                    this.pedidoService.salvar(ori, (String)msg, master, false);
                    continue;
                }
                this.pedidoService.salvar(ori);
            }
        }
        if (pedido.getPedidoEtapa() != null && !pedido.getPedidoEtapa().isSincronizavel()) {
            return;
        }
        Object msg = "";
        PedidoEtapa pedidoEtapa2 = pedidoEtapa = pedidoEtapa != null ? pedidoEtapa : this.pedidoEtapaService.getAndCreate(master.getEstrutura(), dto.getStatus(), origemVivocorp, PedidoTipoEnum.COMERCIAL);
        if (pedido.getId() == null) {
            pedido = new Pedido();
            pedido.setCliente(this.clienteService.getAndCreateCliente(master, dto.getCpfCnpj(), new ClienteContato[0]));
            pedido.setNumero(dto.getNumero());
            pedido.setPedidoOrigem(origemVivocorp);
            pedido.setPedidoTipo(PedidoTipoEnum.COMERCIAL);
            pedido.setDataCadastro(LocalDate.now());
            msg = (String)msg + "Inserindo pedido";
        } else if (tipo.equals((Object)ImportacoesTipoEnum.VIVO_MVP)) {
            if (pedidoEtapa.getAtualizaDataReferencia().booleanValue()) {
                if (dto.getDataAtualizacao() != null) {
                    this.pedidoItemService.updateData(pedido.getId(), dto.getDataAtualizacao());
                } else {
                    this.pedidoItemService.updateData(pedido.getId(), LocalDate.now());
                }
            }
        } else {
            this.pedidoDeleteService.deleteItens(pedido);
        }
        if (!tipo.equals((Object)ImportacoesTipoEnum.VIVO_MVP) && origem != null && !origem.isEmpty()) {
            pedido.setEstruturaUsuario(((Pedido)origem.get(0)).getEstruturaUsuario());
            pedido.setNumeroPedidoOrigem(((Pedido)origem.get(0)).getNumero());
            pedido.setEstruturaUsuarioAdm(((Pedido)origem.get(0)).getEstruturaUsuarioAdm());
            pedido.setNotasFiscais(((Pedido)origem.get(0)).getNotasFiscais());
            pedido.setTipoNegociacao(((Pedido)origem.get(0)).getTipoNegociacao());
            pedido.setTags(((Pedido)origem.get(0)).getTags());
            pedido.setEstruturaSenhas(((Pedido)origem.get(0)).getEstruturaSenhas());
            pedido.setLoginOperadora(((Pedido)origem.get(0)).getLoginOperadora());
        } else if (pedido.getId() == null) {
            pedido.setEstruturaUsuario(master);
            pedido.setTipoNegociacao(dto.isCnpjFresh() ? PedidoTipoNegociacaoEnum.NOVO : PedidoTipoNegociacaoEnum.BASE);
        }
        if (pedido.getPedidoEtapa() != null && !pedido.getPedidoEtapa().getId().equals(pedidoEtapa.getId())) {
            msg = (String)msg + "Atualizado de " + pedido.getPedidoEtapa().getNome() + " para " + pedidoEtapa.getNome();
            pedido.setDataHoraUltimaMov(LocalDateTime.now());
        }
        pedido.setDataHoraAtualizacao(LocalDateTime.now());
        pedido.setDataHoraOperadora(dto.getDataAtualizacao() == null ? LocalDateTime.now() : dto.getDataAtualizacao().atStartOfDay());
        pedido.setNomeConsultorOperadora(dto.getVendedor());
        pedido.setPedidoEtapa(pedidoEtapa);
        if (tipo.equals((Object)ImportacoesTipoEnum.VIVO_MVP)) {
            if (dto.getNumeroPedidoVivocorp() != null && !dto.getNumeroPedidoVivocorp().isEmpty() && !dto.getNumeroPedidoVivocorp().equals(dto.getCotacao())) {
                pedido.setNumeroPedidoVinculado(dto.getNumeroPedidoVivocorp());
            }
            if (dto.getCotacao() != null && !dto.getCotacao().isEmpty()) {
                pedido.setCotacao(dto.getCotacao());
            }
            if (dto.getNumeroSimulacao() != null && !dto.getNumeroSimulacao().isEmpty()) {
                pedido.setNumeroSimulacao(dto.getNumeroSimulacao());
            }
        } else {
            pedido.setItens(this.createItens(pedido, dto, tipo));
        }
        if (dto.getNotaFiscal() != null) {
            pedido.setNotasFiscais(dto.getNotaFiscal());
        }
        if (((String)msg).isEmpty()) {
            this.pedidoService.salvar(pedido);
        } else {
            this.pedidoService.salvar(pedido, (String)msg, master, false);
        }
    }

    private Set<PedidoItem> createItens(Pedido pedido, VivoPedidoDTO dto, ImportacoesTipoEnum tipo) {
        HashSet<PedidoItem> itens = new HashSet<PedidoItem>();
        for (VivoPedidoItemDTO i : dto.getItens()) {
            String nomeProduto;
            if (i.getStatusLinha().isEmpty()) continue;
            PedidoItemSolicitacao sol = this.getSolicitacao(pedido.getEstruturaUsuario().getEstrutura(), i);
            String string = nomeProduto = i.getPlano() != null && !i.getPlano().isEmpty() && !i.getPlano().contains("PL BASE") && !i.getPlano().contains("PLINTERNETBOX") ? i.getPlano() : i.getPacote();
            if (sol != null && sol.getNome().equals("TT")) {
                nomeProduto = "Transfer\u00eancia de Titularidade de linha m\u00f3vel";
            }
            Produto produto = null;
            if (nomeProduto != null && !nomeProduto.isEmpty()) {
                produto = this.produtoService.getAndCreate(pedido, pedido.getEstruturaUsuario().getEstrutura(), tipo.equals((Object)ImportacoesTipoEnum.VIVO_FIXA) ? ProdutoOrigem.SMARTVENDAS : ProdutoOrigem.VIVO_CORP, this.produtoCategoriaService.getCategoriaGenerica(pedido.getEstruturaUsuario().getEstrutura()), nomeProduto, "Via importacao");
            }
            PedidoItem item = new PedidoItem();
            item.setPedidoItemSolicitacao(sol);
            item.setDescontoPorItem(BigDecimal.ZERO);
            item.setConsiderarProducao(Boolean.TRUE);
            item.setDataHoraAtualizacao(LocalDateTime.now());
            item.setPedido(pedido);
            if (item.getPedidoItemSolicitacao().getNome().equals("PORTADO")) {
                item.setDataPortabilidade(i.getDataPortabilidade());
            }
            item.setDataReferencia(i.getDataAtualizacao());
            item.setDdd(Integer.valueOf(StringUtil.toInt((String)i.getDdd())));
            item.setNumero(i.getNumeroLinha());
            item.setPedidoItemEtapa(this.pedidoItemEtapaService.getAndCreate(pedido.getEstruturaUsuario().getEstrutura(), i.getStatusLinha(), pedido.getPedidoOrigem()));
            item.setQuantidade(Integer.valueOf(StringUtil.toInt((String)i.getQuantidade())));
            item.setValorUnitario(BigDecimal.valueOf(i.getValor()));
            if (produto != null && item.getDataReferencia() != null) {
                item.setProduto(produto);
                if (produto.getValorAdicional() != null) {
                    item.setValorUnitario(item.getValorUnitario().add(produto.getValorAdicional()));
                }
                itens.add(item);
            }
            if (i.getAparelho() != null && !i.getAparelho().isEmpty()) {
                itens.add(this.outrosItens(i, item, i.getValorAparelho(), i.getAparelho()));
            }
            if (i.getApontador() != null && !i.getApontador().isEmpty()) {
                itens.add(this.outrosItens(i, item, Double.valueOf(0.0), i.getApontador()));
            }
            if (i.getGestaoEquipe() != null && !i.getGestaoEquipe().isEmpty()) {
                itens.add(this.outrosItens(i, item, Double.valueOf(0.0), i.getGestaoEquipe()));
            }
            if (i.getOffice365() != null && !i.getOffice365().isEmpty()) {
                itens.add(this.outrosItens(i, item, Double.valueOf(0.0), i.getOffice365()));
            }
            if (i.getOneDrive() != null && !i.getOneDrive().isEmpty()) {
                itens.add(this.outrosItens(i, item, Double.valueOf(0.0), i.getOneDrive()));
            }
            if (i.getPresencaDigital() != null && !i.getPresencaDigital().isEmpty()) {
                itens.add(this.outrosItens(i, item, Double.valueOf(0.0), i.getPresencaDigital()));
            }
            if (i.getSegMult() != null && !i.getSegMult().isEmpty()) {
                itens.add(this.outrosItens(i, item, Double.valueOf(0.0), i.getSegMult()));
            }
            if (i.getSegProtecao() != null && !i.getSegProtecao().isEmpty()) {
                itens.add(this.outrosItens(i, item, Double.valueOf(0.0), i.getSegProtecao()));
            }
            if (i.getVgi() != null && !i.getVgi().isEmpty()) {
                itens.add(this.outrosItens(i, item, Double.valueOf(0.0), i.getVgi()));
            }
            if (i.getVpol() == null || i.getVpol().isEmpty()) continue;
            itens.add(this.outrosItens(i, item, Double.valueOf(0.0), i.getVpol()));
        }
        return itens;
    }

    private PedidoItemSolicitacao getSolicitacao(Estrutura estrutura, VivoPedidoItemDTO dto) {
        if (dto.getTipo().contains("Alta") && dto.getOperadoraDoadora() != null && !dto.getOperadoraDoadora().trim().isEmpty()) {
            return this.getTipoSolicitacaoByNome(estrutura, "PORTADO");
        }
        if (dto.getTipo().contains("Alta") && (dto.getOperadoraDoadora() == null || dto.getOperadoraDoadora().isEmpty())) {
            return this.getTipoSolicitacaoByNome(estrutura, "NOVO");
        }
        if (dto.getTipo().equals("Troca") && dto.isMigracao()) {
            return this.getTipoSolicitacaoByNome(estrutura, "MIGRACAO + TROCA");
        }
        if (dto.getTipo().equals("Troca") && !dto.isMigracao()) {
            return this.getTipoSolicitacaoByNome(estrutura, "TROCA");
        }
        if (dto.getTipo().equals("Troca_sem_aparelho") && !dto.isMigracao() && dto.getPlano().isEmpty()) {
            return this.getTipoSolicitacaoByNome(estrutura, "ATIVA\u00c7\u00c3O DE SERVI\u00c7O");
        }
        if (dto.getTipo().equals("Troca_sem_aparelho") && !dto.isMigracao()) {
            return this.getTipoSolicitacaoByNome(estrutura, "MIGRACAO PP");
        }
        if (dto.getTipo().equals("Troca_sem_aparelho") && dto.isMigracao()) {
            return this.getTipoSolicitacaoByNome(estrutura, "MIGRACAO");
        }
        if (dto.getTipo().equals("TT")) {
            return this.getTipoSolicitacaoByNome(estrutura, "TT");
        }
        if (dto.getTipo().equals("RENOVACAO")) {
            return this.getTipoSolicitacaoByNome(estrutura, "RENOVACAO");
        }
        if (dto.isMigracao()) {
            return this.getTipoSolicitacaoByNome(estrutura, "MIGRACAO");
        }
        return this.getTipoSolicitacaoByNome(estrutura, "NOVO");
    }

    private PedidoItemSolicitacao getTipoSolicitacaoByNome(Estrutura estrutura, String nome) {
        return this.pedidoItemSolicitacaoRepository.findByEstruturaTipoAndNome(estrutura.getEstruturaTipo(), nome);
    }

    private PedidoItem outrosItens(VivoPedidoItemDTO dto, PedidoItem iOriginal, Double valor, String nomeProduto) {
        PedidoItem i = new PedidoItem();
        i.setPedidoItemSolicitacao(iOriginal.getPedidoItemSolicitacao());
        i.setConsiderarProducao(Boolean.TRUE);
        i.setDataHoraAtualizacao(LocalDateTime.now());
        i.setDataReferencia(dto.getDataAtualizacao());
        i.setPedidoItemEtapa(iOriginal.getPedidoItemEtapa());
        i.setNumero(iOriginal.getNumero());
        i.setPedido(iOriginal.getPedido());
        Produto produto = this.produtoService.getAndCreate(iOriginal.getPedido(), iOriginal.getPedido().getEstruturaUsuario().getEstrutura(), ProdutoOrigem.VIVO_CORP, this.produtoCategoriaService.getCategoriaGenerica(iOriginal.getPedido().getEstruturaUsuario().getEstrutura()), nomeProduto, "Via importacao");
        i.setProduto(produto);
        i.setQuantidade(Integer.valueOf(StringUtil.toInt((String)dto.getQuantidade())));
        i.setValorUnitario(BigDecimal.valueOf(valor));
        if (produto.getValorAdicional() != null) {
            i.setValorUnitario(i.getValorUnitario().add(produto.getValorAdicional()));
        }
        i.setDescontoPorItem(BigDecimal.ZERO);
        return i;
    }

    private String getNomeOrigem(ImportacoesTipoEnum tipo) {
        if (tipo.equals((Object)ImportacoesTipoEnum.VIVO_FIXA)) {
            return "SMARTVENDAS";
        }
        if (tipo.equals((Object)ImportacoesTipoEnum.VIVO_MVP)) {
            return "NEOCRM";
        }
        return "VIVO-CORP";
    }

    private Pedido getPedido(VivoPedidoDTO d, EstruturaUsuario eu, StringBuilder log) {
        Pedido pedido;
        d.setNumeroSimulacao(d.getNumeroSimulacao().trim());
        if (d.getNumeroPedidoVivocorp() != null && !d.getNumeroPedidoVivocorp().isEmpty() && (pedido = this.pedidoService.getByNumeroAndEstrutura(d.getNumeroPedidoVivocorp(), eu.getEstrutura())) != null) {
            log.append("Pedido: ").append(d.getNumeroPedidoVivocorp()).append("<BR>");
            return pedido;
        }
        if (d.getCotacao() != null && !d.getCotacao().isEmpty() && (pedido = this.pedidoService.getByNumeroAndEstrutura(d.getCotacao(), eu.getEstrutura())) != null) {
            log.append("Cota\u00e7\u00e3o: ").append(d.getCotacao()).append("<BR>");
            return pedido;
        }
        if (d.getNumeroSimulacao() != null && !d.getNumeroSimulacao().isEmpty() && (pedido = this.pedidoService.getByNumeroAndEstrutura(d.getNumeroSimulacao(), eu.getEstrutura())) != null) {
            log.append(" Simula\u00e7\u00e3o: ").append(d.getNumeroSimulacao()).append("<BR>");
            return pedido;
        }
        if (d.getNumeroPedidoVivocorp() != null) {
            return null;
        }
        log.append(" Simula\u00e7\u00e3o/Cota\u00e7\u00e3o/Pedido ").append(d.getNumero()).append(" n\u00e3o vinculada em atividade\n");
        return null;
    }

    private Pedido getPedidoMvp(VivoPedidoDTO d, EstruturaUsuario eu, StringBuilder log) {
        Pedido pedido;
        List pedidos;
        if (d.getNumeroPedidoVivocorp() != null && !d.getNumeroPedidoVivocorp().isEmpty() && !(pedidos = this.pedidoService.getByNumeroVinculado(eu.getEstrutura(), d.getNumeroPedidoVivocorp())).isEmpty()) {
            log.append("Pedido: ").append(d.getNumeroPedidoVivocorp()).append("<BR>");
            return (Pedido)pedidos.get(0);
        }
        if (d.getCotacao() != null && !d.getCotacao().isEmpty() && (pedido = this.pedidoService.getPedidoByNumeroCotacao(eu, d.getCotacao())) != null) {
            log.append("Cota\u00e7\u00e3o: ").append(d.getCotacao()).append("<BR>");
            return pedido;
        }
        if (d.getNumeroSimulacao() != null && !d.getNumeroSimulacao().isEmpty() && (pedido = this.pedidoService.getPedidoByNumeroSimulacao(eu, d.getNumeroSimulacao())) != null) {
            log.append(" Simula\u00e7\u00e3o: ").append(d.getNumeroSimulacao()).append("<BR>");
            return pedido;
        }
        log.append(" Simula\u00e7\u00e3o/Cota\u00e7\u00e3o/Pedido ").append(d.getNumero()).append(" n\u00e3o vinculada em atividade\n");
        return null;
    }
}

