/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.mailing.service;

import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.model.TipoContatoEnum;
import br.com.system.app.features.cliente.service.ClienteCopyMailing;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.mailing.model.Mailing;
import br.com.system.app.features.mailing.model.MailingContato;
import br.com.system.app.features.mailing.projection.MailingLimited;
import br.com.system.app.features.mailing.repository.MailingRepository;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.receitafederal.model.ReceitaSincroniaDTO;
import br.com.system.app.features.receitafederal.service.ReceitawsService;
import br.com.system.app.features.shared.exception.BusinessException;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MailingReceitaService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private MailingRepository mailingRepository;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private ReceitawsService receitawsService;
    @Autowired
    private NotificacoesService notificacoesService;

    @Async(value="asyncDefault")
    public void forcarReceita(String cnpj, EstruturaUsuario eu, Consumer<ReceitaSincroniaDTO> listener) {
        Thread.currentThread().setName("asyncDefault-mailing-receita");
        try {
            ReceitaSincroniaDTO d = new ReceitaSincroniaDTO();
            d.setCpfCnpj(cnpj);
            d.setMailing(this.forcarReceita(cnpj, eu));
            listener.accept(d);
        }
        catch (Exception e) {
            ReceitaSincroniaDTO d = new ReceitaSincroniaDTO();
            d.setCpfCnpj(cnpj);
            d.setErro(e.getMessage());
            listener.accept(d);
        }
    }

    @Async(value="asyncDefault")
    public void forcarReceita(List<MailingLimited> lista, EstruturaUsuario eu) {
        StringBuilder sb = new StringBuilder();
        for (MailingLimited selectedItem : lista) {
            try {
                sb.append("Processando ").append(selectedItem.getCnpj());
                this.forcarReceita(selectedItem.getCnpj(), eu);
                sb.append(" processado com sucesso\n");
            }
            catch (Exception ex) {
                sb.append(" erro ").append(ex.getMessage()).append("\n");
            }
        }
        this.notificacoesService.notify(eu, "Sincronizar Receita Federal", sb.toString());
    }

    public Mailing forcarReceita(String cnpj, EstruturaUsuario eu) {
        try {
            Mailing mailing = this.mailingRepository.findByDocument(cnpj);
            if (mailing == null) {
                mailing = new Mailing();
            } else if (!eu.getUsuario().isMaster() && mailing.getDataHoraAtualizacao().toLocalDate().isAfter(LocalDate.now().minusDays(7L))) {
                throw new Exception("Sincronizado menos de 7 dias");
            }
            Mailing mailingReceita = this.receitawsService.sincronizar(cnpj, mailing.getCpfCnpj() != null);
            if (mailingReceita == null) {
                throw new BusinessException("Sistema de sincronia da receita fora do ar, tente mais tarde");
            }
            mailing.getAtividades().clear();
            mailing.getContatos().clear();
            mailing.getSocios().clear();
            BeanUtils.copyProperties((Object)mailingReceita, (Object)mailing, (String[])new String[]{"id", "atividades", "contatos", "socios", "pessoas"});
            this.childrens(mailingReceita, mailing);
            mailing = this.persist(mailing);
            this.saveClient(mailing, eu);
            return mailing;
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao sincronizar receita " + e.getMessage());
        }
    }

    private void childrens(Mailing mr, Mailing m) {
        m.getAtividades().addAll(mr.getAtividades());
        m.getContatos().addAll(mr.getContatos());
        m.getSocios().addAll(mr.getSocios());
    }

    @Transactional
    private Mailing persist(Mailing mailing) {
        mailing.getAtividades().forEach(item -> item.setMailing(mailing));
        mailing.getContatos().forEach(item -> item.setMailing(mailing));
        mailing.getSocios().forEach(item -> item.setMailing(mailing));
        return (Mailing)this.mailingRepository.save((Object)mailing);
    }

    private Cliente saveClient(Mailing mailing, EstruturaUsuario eu) {
        Cliente cliente = this.clienteService.getAndCreateCliente(eu, mailing.getCpfCnpj(), new ClienteContato[0]);
        if (cliente != null) {
            Cliente clienteMailing = new ClienteCopyMailing().convertMailingToCliente(mailing);
            cliente.setDataHoraAtualizacao(LocalDateTime.now());
            BeanUtils.copyProperties((Object)clienteMailing, (Object)cliente, (String[])new String[]{"id", "estrutura", "pessoas", "clienteContato", "clienteResponsavel", "tags"});
            HashSet<ClienteContato> novosContatos = new HashSet<ClienteContato>();
            for (MailingContato mc : mailing.getContatos()) {
                novosContatos.add(new ClienteContato(TipoContatoEnum.valueOf((String)mc.getTipo().name()), mc.getValor()));
            }
            this.clienteService.salvar(cliente, eu, novosContatos);
        }
        return cliente;
    }
}

