/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.marketing;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.FlexBoxLayout;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.marketing.MarketingForm;
import br.com.system.app.features.marketing.model.Marketing;
import br.com.system.app.features.marketing.model.MarketingItem;
import br.com.system.app.features.marketing.model.MarketingStatus;
import br.com.system.app.features.marketing.service.MarketingSendService;
import br.com.system.app.features.marketing.service.MarketingService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.service.WhatsAppContaService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.StringUtil;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="marketing", layout=MainLayout.class)
@PageTitle(value="Campanhas de Marketing")
@RolesAllowed(value={"MARKETING_VIEW"})
public class MarketingView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final MarketingService marketingService;
    private final MarketingForm marketingForm;
    private final MarketingSendService marketingSendService;
    private final WhatsAppContaService whatsappContaService;
    private GridCrud<Marketing> crud;
    private HorizontalContainer containerContas;
    private Boolean apiOficial;
    private DownloadDialog dd;

    @Autowired
    public MarketingView(MarketingService marketingService, MarketingForm marketingForm, MarketingSendService marketingSendService, WhatsAppContaService whatsappContaService) {
        this.marketingService = marketingService;
        this.whatsappContaService = whatsappContaService;
        this.marketingSendService = marketingSendService;
        this.marketingForm = marketingForm;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        this.dd = new DownloadDialog();
        this.containerContas = new HorizontalContainer(new Component[0]).setSpacingOn();
        this.marketingForm.addOpenedChangeListener((ComponentEventListener & Serializable)e -> {
            if (!e.isOpened()) {
                this.crud.refreshGrid();
            }
        });
        this.povoaContas();
        Button btnPausar = UIUtils.createSmallButton((String)"Pausar Campanha", (VaadinIcon)VaadinIcon.PAUSE);
        btnPausar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() <= 0) {
                this.showNotification("Selecione uma campanha para pausar");
                return;
            }
            Marketing m = (Marketing)this.crud.getGrid().getSelectedItems().iterator().next();
            if (!m.getStatus().equals((Object)MarketingStatus.PROCESSANDO)) {
                this.showNotification("S\u00f3 consigo pausar campanhas no status PROCESSANDO");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Pausar", "Confirma PAUSA da campanha?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)ec -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)ec -> {
                this.marketingService.pausarCampanha(m);
                this.showNotification("Campanha pausada com sucesso");
                cd.close();
                this.crud.refreshGrid();
            });
        });
        Button btnIniciar = UIUtils.createSmallButton((String)"Iniciar Campanha", (VaadinIcon)VaadinIcon.START_COG);
        btnIniciar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() <= 0) {
                this.showNotification("Selecione uma campanha para iniciar");
                return;
            }
            Marketing m = (Marketing)this.crud.getGrid().getSelectedItems().iterator().next();
            if (!m.getStatus().equals((Object)MarketingStatus.EM_CRIACAO) && !m.getStatus().equals((Object)MarketingStatus.PAUSADA)) {
                this.showNotification("S\u00f3 consigo iniciar campanhas no status EM_CRIACAO e PAUSADA");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Iniciar", "Confirma inicio da campanha?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)ec -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)ec -> {
                try {
                    List contas = this.whatsappContaService.getContaByEstruturaMarketing(m.getEstruturaUsuario().getEstrutura());
                    if (contas == null || contas.size() <= 0) {
                        throw new BusinessException("N\u00e3o h\u00e1 instancias de marketing configuradas, por favor contacte o suporte");
                    }
                    if (((WhatsAppConta)contas.get(0)).getApiOficial().booleanValue()) {
                        if (m.getWhatsappConta() != null) {
                            this.marketingSendService.iniciarCampanha(m, m.getWhatsappConta());
                        } else {
                            this.marketingSendService.iniciarCampanha(m, (WhatsAppConta)contas.get(0));
                        }
                    } else {
                        this.marketingService.iniciarCampanhaNormal(m);
                    }
                    this.showNotification("Campanha iniciada com sucesso");
                    this.crud.refreshGrid();
                }
                catch (Exception ex) {
                    this.showNotification(ex.getMessage());
                }
                cd.close();
                this.crud.refreshGrid();
            });
        });
        Button btnAdd = UIUtils.createSmallButton((String)"Nova Campanha", (VaadinIcon)VaadinIcon.PLUS, (String)"Nova Campanha");
        btnAdd.addClickListener((ComponentEventListener & Serializable)e -> this.marketingForm.show(this.getEu(), null, this.apiOficial.booleanValue()));
        Button btnEdit = UIUtils.createSmallButton((String)"Editar Campanha", (VaadinIcon)VaadinIcon.PENCIL, (String)"Editar Campanha");
        btnEdit.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() <= 0) {
                this.showNotification("Selecione uma campanha para iniciar");
                return;
            }
            Marketing m = (Marketing)this.crud.getGrid().getSelectedItems().iterator().next();
            this.marketingForm.show(this.getEu(), m, this.apiOficial.booleanValue());
        });
        Button btnTeste = UIUtils.createSmallButton((String)"Testar", (VaadinIcon)VaadinIcon.BUG, (String)"Testar envio");
        btnTeste.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() <= 0) {
                this.showNotification("Selecione uma campanha para iniciar");
                return;
            }
            Marketing m = (Marketing)this.crud.getGrid().getSelectedItems().iterator().next();
            if (!m.getStatus().equals((Object)MarketingStatus.EM_CRIACAO)) {
                this.showNotification("S\u00f3 consigo Testar campanhas no status EM_CRIACAO");
                return;
            }
            this.showTeste(m);
        });
        Button btnExportar = UIUtils.createSmallButton((String)"Exportar", (VaadinIcon)VaadinIcon.TABLE, (String)"Exportar itens");
        btnExportar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() <= 0) {
                this.showNotification("Selecione uma campanha para EXPORTAR");
                return;
            }
            Marketing m = (Marketing)this.crud.getGrid().getSelectedItems().iterator().next();
            String url = this.marketingService.exportar(m);
            this.dd.open(url, "Exportacao-itens-marketing.xlsx", true);
        });
        this.crud = new GridCrud(Marketing.class);
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getNomeCampanha()))).setHeader("Nome").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getFilename()))).setHeader("Arquivo").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getTipo().name())).setHeader("Tipo").setFlexGrow(0).setWidth("150px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getStatus().name())).setHeader("Status").setFlexGrow(0).setWidth("200px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataHoraCriacao().format(FormatDate.DATETIME_BR.toDTF()))).setHeader("Inicio").setFlexGrow(0).setWidth("180px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataHoraFim() == null ? "" : p.getDataHoraFim().format(FormatDate.DATETIME_BR.toDTF()))).setHeader("Fim").setFlexGrow(0).setWidth("180px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getObservacao()))).setHeader("Observa\u00e7\u00e3o").setFlexGrow(0).setWidth("250px");
        this.crud.getCrudFormFactory().setVisibleProperties(new String[0]);
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(this.hasPermission("MARKETING_DELETE"));
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        Button btnContas = UIUtils.createSmallButton((String)"Verificar Canais");
        btnContas.addClickListener((ComponentEventListener & Serializable)e -> {
            for (WhatsAppConta wc : this.whatsappContaService.getContaByEstruturaMarketing(this.getEstrutura())) {
                this.whatsappContaService.checkIntegration(wc);
            }
            this.povoaContas();
        });
        FlexBoxLayout main = new FlexBoxLayout(FlexLayout.FlexDirection.COLUMN, new Component[0]);
        main.setHeightFull();
        main.add(new Component[]{new HorizontalContainer(new Component[]{btnAdd, btnEdit, btnIniciar, btnPausar, btnTeste, btnExportar}).setTransparent()});
        main.add(new Component[]{new Span("Meus Canais")});
        main.add(new Component[]{new HorizontalContainer(new Component[]{this.containerContas, btnContas})});
        main.add(new Component[]{this.crud});
        return main;
    }

    private void povoaContas() {
        this.containerContas.removeAll();
        this.apiOficial = false;
        for (WhatsAppConta wc : this.whatsappContaService.getContaByEstruturaMarketing(this.getEstrutura())) {
            if (wc.getApiOficial().booleanValue()) {
                this.apiOficial = true;
            }
            TextField tf = new TextField();
            tf.setReadOnly(true);
            tf.setValue(wc.getNumero() + " " + (wc.isAtivo() ? "Ativo" : "Inativo") + " " + (wc.getObservacao() == null ? "" : wc.getObservacao()) + " ");
            if (!wc.isAtivo()) {
                tf.setWidth("300px");
                UIUtils.setBackgroundColor((Color)Color.LIGHTYELLOW, (Component[])new Component[]{tf});
            }
            this.containerContas.add(new Component[]{tf});
        }
    }

    private void showTeste(Marketing m) {
        List itens = this.marketingService.getByMarketing(m);
        Dialog d = new Dialog();
        d.add(new Component[]{UIUtils.createSmallSpan((String)"Informe o n\u00famero para teste")});
        d.add(new Component[]{UIUtils.createSmallSpan((String)"*Tem que estar na planilha")});
        TextField txtTel = new TextField("");
        Button btnTest = UIUtils.createSmallButton((String)"Testar");
        btnTest.addClickListener((ComponentEventListener & Serializable)e -> {
            String numero = StringUtil.numbersOnly((String)txtTel.getValue());
            for (MarketingItem mi : itens) {
                if (!mi.getNumero().equals(numero)) continue;
                if ((mi = this.marketingSendService.enviar(mi, null)).getErro() != null) {
                    this.showNotification("Erro ao enviar: " + mi.getErro());
                } else {
                    this.showNotification("Enviado com sucesso");
                }
                this.marketingService.checkFinish(m);
                return;
            }
            this.showNotification("N\u00famero n\u00e3o encontrado na planilha.");
        });
        Button btnClose = UIUtils.createSmallButton((String)"Fechar");
        btnClose.addClickListener((ComponentEventListener & Serializable)e -> d.close());
        d.add(new Component[]{new HorizontalContainer(new Component[]{txtTel, btnTest}).setTransparent()});
        d.add(new Component[]{new FooterContainer(new Component[]{btnClose})});
        d.open();
    }
}

