/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.materialapoio.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.materialapoio.model.MaterialApoio;
import br.com.system.app.features.materialapoio.model.MaterialApoioDTO;
import br.com.system.app.features.materialapoio.repository.MaterialApoioRepository;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.commons.FileUtil;
import br.com.system.commons.HashUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class MaterialApoioService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private MaterialApoioRepository materialApoioRepository;

    public List<MaterialApoioDTO> getByEstruturaAndNome(EstruturaUsuario eu, String nome, Pageable pageable) {
        return this.materialApoioRepository.findByEstruturaAndNome(eu, nome, pageable);
    }

    public long countByEstruturaAndNome(EstruturaUsuario eu, String nome) {
        return this.materialApoioRepository.countByEstruturaAndNome(eu, nome);
    }

    public void delete(Long maId) {
        this.materialApoioRepository.deleteById((Object)maId);
    }

    public void deleteByEstrutura(Estrutura estrutura) {
        this.materialApoioRepository.deleteByEstruturaUsuarioEstrutura(estrutura);
    }

    public MaterialApoio getById(Long id) {
        return (MaterialApoio)this.materialApoioRepository.findById((Object)id).get();
    }

    public MaterialApoio upload(EstruturaUsuario eu, String nomeArquivo, String descricao, String perfis, InputStream is) {
        try {
            MaterialApoio ma = new MaterialApoio();
            ma.setDataUpload(LocalDate.now());
            ma.setDescricao(descricao);
            ma.setPerfis(perfis);
            ma.setNomeArquivo(nomeArquivo);
            ma.setEstruturaUsuario(eu);
            String extensao = FileUtil.getExtension((String)nomeArquivo);
            String hash = HashUtil.getUUI() + extensao;
            ma.setHashArquivo(hash);
            StorageUtil.uploadObjectInputStream((String)hash, (InputStream)is);
            return this.salvar(ma);
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao gravar arquivo " + e.getMessage());
        }
    }

    public MaterialApoio salvar(MaterialApoio ma) {
        if (ma.getEstruturaUsuario() == null) {
            throw new BusinessException("EU obrigat\u00f3rio");
        }
        if (ma.getDataUpload() == null) {
            ma.setDataUpload(LocalDate.now());
        }
        if (ma.getHashArquivo() == null || ma.getHashArquivo().isBlank()) {
            ma.setHashArquivo(HashUtil.getUUI());
        }
        return (MaterialApoio)this.materialApoioRepository.save((Object)ma);
    }
}

