/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoAnexo;
import br.com.system.app.features.pedido.repository.PedidoAnexoRepository;
import br.com.system.app.features.pedido.service.PedidoLogService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.util.TempFileMultiBuffer;
import br.com.system.commons.FileUtil;
import br.com.system.commons.HashUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PedidoAnexoService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private PedidoAnexoRepository pedidoAnexoRepository;
    @Autowired
    private PedidoLogService pedidoLogService;

    public PedidoAnexo save(PedidoAnexo pedidoAnexo) {
        if (pedidoAnexo.getEstruturaUsuario() == null) {
            throw new BusinessException("Estrutura Usuario obrigatorio");
        }
        if (pedidoAnexo.getHashArquivo().isBlank()) {
            throw new BusinessException("Hash obrigatorio");
        }
        if (pedidoAnexo.getPedido() == null) {
            throw new BusinessException("Pedido obrigatorio");
        }
        return (PedidoAnexo)this.pedidoAnexoRepository.save((Object)pedidoAnexo);
    }

    public void save(Pedido pedido, EstruturaUsuario eu, InputStream file, String nomeArquivo) {
        String extensao = FileUtil.getExtension((String)nomeArquivo);
        String hash = HashUtil.getUUI();
        try {
            StorageUtil.uploadObjectInputStream((String)(hash + extensao), (InputStream)file);
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao gravar arquivo: " + e.getMessage());
        }
        PedidoAnexo pa = new PedidoAnexo();
        pa.setHashArquivo(hash);
        pa.setEstruturaUsuario(eu);
        pa.setDataHora(LocalDateTime.now());
        pa.setNomeArquivo(nomeArquivo);
        pa.setPedido(pedido);
        this.save(pa);
        this.pedidoLogService.salvar(pa.getPedido(), eu, "Inserido anexo: " + pa.getNomeArquivo());
    }

    public void save(Pedido pedido, EstruturaUsuario euContext, TempFileMultiBuffer buffer) {
        for (String file : buffer.getFiles()) {
            this.save(pedido, euContext, buffer.getInputStream(file), buffer.getFileData(file).getFileName());
        }
    }

    @Transactional
    public void deleteByPedido(Pedido pedido, Boolean excluirAnexoBucket) throws Exception {
        for (PedidoAnexo pa : this.pedidoAnexoRepository.findByPedidoId(pedido.getId())) {
            this.delete(pa, null, excluirAnexoBucket);
        }
    }

    public void delete(PedidoAnexo pa, EstruturaUsuario eu, Boolean excluirAnexoBucket) throws Exception {
        if (excluirAnexoBucket.booleanValue()) {
            StorageUtil.deleteObject((String)pa.getHashArquivo());
        }
        this.pedidoAnexoRepository.delete((Object)pa);
        if (eu != null) {
            this.pedidoLogService.salvar(pa.getPedido(), eu, "Exclus\u00e3o anexo: " + pa.getNomeArquivo());
        }
    }

    public List<PedidoAnexo> getAnexoByPedidoAndNome(Pedido pedido, String nomeArquivo) {
        return this.pedidoAnexoRepository.findByPedidoAndNomeArquivo(pedido, nomeArquivo);
    }

    public List<PedidoAnexo> getAnexo(Pedido pedido) {
        if (pedido.getNumeroPedidoOrigem() != null && !pedido.getNumeroPedidoOrigem().isBlank()) {
            List lista = this.pedidoAnexoRepository.findByPedidoId(pedido.getId());
            lista.addAll(this.pedidoAnexoRepository.findByPedidoNumero(pedido.getNumeroPedidoOrigem()));
            return lista;
        }
        return this.pedidoAnexoRepository.findByPedidoId(pedido.getId());
    }

    public List<PedidoAnexo> getByEstrutura(Estrutura estrutura) {
        return this.pedidoAnexoRepository.findByEstruturaUsuarioEstrutura(estrutura);
    }

    public List<PedidoAnexo> getByHash(String hash) {
        return this.pedidoAnexoRepository.findByHashArquivo(hash);
    }
}

