/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.view;

import br.com.system.app.components.Card;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.features.estrutura.model.EstruturaSenhas;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaSenhasService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.size.FontSize;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoTipoNegociacaoEnum;
import br.com.system.app.features.pedido.service.PedidoVinculoService;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import java.util.Collection;

public class DialogVincularVivo
extends Dialog
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Pedido pedido;
    private final EstruturaUsuario euContext;
    private final PedidoVinculoService pedidoVinculoService;
    private final EstruturaSenhasService estruturaSenhasService;

    public DialogVincularVivo(Pedido pedido, EstruturaUsuario euContext, PedidoVinculoService pedidoVinculoService, EstruturaSenhasService estruturaSenhasService) {
        this.pedido = pedido;
        this.euContext = euContext;
        this.pedidoVinculoService = pedidoVinculoService;
        this.estruturaSenhasService = estruturaSenhasService;
    }

    public Pedido getPedido() {
        return this.pedido;
    }

    public void create() {
        Card card = new Card();
        card.setHeader("Vincular");
        ComboBox cbSenhas = new ComboBox("Login", (Collection)this.estruturaSenhasService.getAtivosByEstrutura(this.euContext.getEstrutura()));
        cbSenhas.setItemLabelGenerator(EstruturaSenhas::getNomeAndSistema);
        cbSenhas.setValue((Object)this.pedido.getEstruturaSenhas());
        this.setWidth("400px");
        cbSenhas.setWidth("300px");
        TextField numeroPedido = new TextField("Pedido Operadora");
        numeroPedido.setWidth("200px");
        numeroPedido.setValue(this.pedido.getNumeroPedidoVinculado() == null ? "" : this.pedido.getNumeroPedidoVinculado());
        TextField nroSimulacao = new TextField("N\u00famero Simula\u00e7\u00e3o");
        nroSimulacao.setWidth("200px");
        nroSimulacao.setValue(this.pedido.getNumeroSimulacao() == null ? "" : this.pedido.getNumeroSimulacao());
        TextField cotacao = new TextField("Cota\u00e7\u00e3o");
        cotacao.setWidth("200px");
        cotacao.setValue(this.pedido.getCotacao() == null ? "" : this.pedido.getCotacao());
        TextField codigoPortabilidade = new TextField("Codigo Portabilidade");
        codigoPortabilidade.setWidth("200px");
        codigoPortabilidade.setValue(this.pedido.getCodigoPortabilidade() == null ? "" : this.pedido.getCodigoPortabilidade());
        RadioButtonGroup rbNegociacao = new RadioButtonGroup();
        rbNegociacao.setItems((Object[])PedidoTipoNegociacaoEnum.values());
        rbNegociacao.setLabel("Cliente base ou Novo");
        rbNegociacao.setValue((Object)(this.pedido.getTipoNegociacao() == null ? PedidoTipoNegociacaoEnum.NOVO : this.pedido.getTipoNegociacao()));
        Button btnDescincular = UIUtils.createSmallButton((String)"Desvincular", (VaadinIcon)VaadinIcon.UNLINK);
        btnDescincular.addClickListener((ComponentEventListener & Serializable)e -> {
            ConfirmationDialog cd = new ConfirmationDialog("Desvincular", "Confirma desvincular Pedido?");
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)confirm -> {
                this.pedido = this.pedidoVinculoService.desvincular(this.pedido, this.euContext);
                this.close();
                cd.close();
                UIUtils.showNotification((String)"Desvinculado com sucesso.");
            });
        });
        Button btn = UIUtils.createSmallButton((String)"Vincular", (VaadinIcon)VaadinIcon.CHECK);
        btn.addClickListener((ComponentEventListener & Serializable)e -> {
            if (numeroPedido.isEmpty() && nroSimulacao.isEmpty() && cotacao.getValue().isEmpty() || cbSenhas.getValue() == null) {
                UIUtils.showNotification((String)"Informe o n\u00famero e selecione um login");
                return;
            }
            if (numeroPedido.getValue().equals(this.pedido.getNumero())) {
                UIUtils.showNotification((String)"Voc\u00ea n\u00e3o pode vincular o pedido com ele mesmo.");
                return;
            }
            if (rbNegociacao.getValue() == null) {
                UIUtils.showNotification((String)"Selecione o tipo de negociacao(base ou novo)");
                return;
            }
            try {
                this.pedido = this.pedidoVinculoService.vincularSingle(this.pedido, (EstruturaSenhas)cbSenhas.getValue(), this.euContext, numeroPedido.getValue(), "", (PedidoTipoNegociacaoEnum)rbNegociacao.getValue(), "", Integer.valueOf(0), cotacao.getValue(), codigoPortabilidade.getValue(), null, nroSimulacao.getValue());
                this.close();
                UIUtils.showNotification((String)"Vinculado com sucesso");
            }
            catch (Exception ex) {
                UIUtils.showNotification((String)("Erro: " + ex.getMessage()));
            }
        });
        Button btnClose = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
        btnClose.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        card.setContent(new Component[]{UIUtils.createSpan((FontSize)FontSize.S, (String)("Pedido: " + this.pedido.getNumero())), UIUtils.createSpan((FontSize)FontSize.S, (String)("Cliente: " + this.pedido.getCliente().getNome())), cbSenhas, rbNegociacao, nroSimulacao, cotacao, numeroPedido, codigoPortabilidade});
        card.setFooter(new Component[]{btnClose, btnDescincular, btn});
        card.getFooterBox().setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        this.add(new Component[]{card});
        this.open();
    }
}

