/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.view;

import br.com.system.app.MainLayout;
import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.layout.size.FontSize;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import br.com.system.app.features.pedido.model.PedidoOrigem;
import br.com.system.app.features.pedido.service.PedidoEtapaService;
import br.com.system.app.features.pedido.service.PedidoOrigemService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.CrudOperation;
import org.vaadin.crudui.crud.impl.GridCrud;
import org.vaadin.crudui.form.FieldProvider;

@Route(value="atividade-etapas", layout=MainLayout.class)
@PageTitle(value="Etapa das atividades")
@RolesAllowed(value={"MASTER"})
public class PedidoEtapaView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final PedidoEtapaService pes;
    private final PedidoOrigemService pos;

    public PedidoEtapaView(PedidoEtapaService pes, PedidoOrigemService pos) {
        this.pes = pes;
        this.pos = pos;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado() && this.isMaster()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        GridCrud crud = new GridCrud(PedidoEtapa.class);
        RadioButtonGroup rbTipo = new RadioButtonGroup();
        rbTipo.setItems((Object[])PedidoTipoEnum.values());
        rbTipo.setValue((Object)PedidoTipoEnum.COMERCIAL);
        rbTipo.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> crud.refreshGrid());
        UIUtils.setFontSize((FontSize)FontSize.XXS, (Component[])new Component[]{rbTipo});
        TextField filterName = new TextField();
        filterName.setPlaceholder("Filtrar por nome");
        filterName.setClearButtonVisible(true);
        RadioButtonGroup rbAtivo = new RadioButtonGroup();
        rbAtivo.setItems((Object[])new String[]{"Ativo", "Inativo"});
        rbAtivo.setValue((Object)"Ativo");
        rbAtivo.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> crud.refreshGrid());
        RadioButtonGroup rbSincronizavel = new RadioButtonGroup();
        rbSincronizavel.setItems((Object[])new String[]{"Sincronizavel", "Estatico"});
        rbSincronizavel.setValue((Object)"Sincronizavel");
        rbSincronizavel.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> crud.refreshGrid());
        RadioButtonGroup rbEditavel = new RadioButtonGroup();
        rbEditavel.setItems((Object[])new String[]{"Editavel", "N\u00e3o Editavel"});
        rbEditavel.setValue((Object)"Editavel");
        rbEditavel.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> crud.refreshGrid());
        Button btnExport = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TABLE, (String)"Exportar");
        btnExport.addClickListener((ComponentEventListener & Serializable)e -> {
            List filter = this.pes.filter(this.getEstrutura(), filterName.getValue(), (PedidoTipoEnum)rbTipo.getValue(), Boolean.valueOf(((String)rbAtivo.getValue()).equals("Ativo")), Boolean.valueOf(((String)rbSincronizavel.getValue()).equals("Sincronizavel")), Boolean.valueOf(((String)rbEditavel.getValue()).equals("Editavel")), null);
            String hash = this.pes.exportar(this.getEu(), filter);
            DownloadDialog dd = new DownloadDialog();
            dd.open(hash, "Etapa.xlsx", true);
        });
        crud.getCrudLayout().addToolbarComponent((Component)new HorizontalContainer(new Component[]{btnExport, filterName, rbTipo, rbAtivo, rbSincronizavel, rbEditavel}));
        crud.getAddButton().setText("Adicionar");
        crud.getGrid().setColumns(new String[0]);
        crud.getGrid().addColumn("nome").setFlexGrow(0).setWidth("380px");
        crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.isAtivo() ? "ATIVO" : "INATIVO")).setHeader("Status").setFlexGrow(0).setWidth("130px");
        crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.isSincronizavel() ? "SINCRONIZAVEL" : "ESTATICO")).setHeader("Sincronia").setFlexGrow(0).setWidth("160px");
        crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.isEditavel() ? "SIM" : "N\u00c3O")).setHeader("Edit\u00e1vel").setFlexGrow(0).setWidth("160px");
        crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getPedidoOrigem().getNome())).setHeader("Origem").setFlexGrow(0).setWidth("180px");
        crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getAtualizaDataReferencia() == null ? "NAO" : (p.getAtualizaDataReferencia() != false ? "SIM" : "N\u00c3O"))).setHeader("Atualiza Data Ref").setFlexGrow(0).setWidth("180px");
        crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getPedidoTipo().name())).setHeader("Tipo").setFlexGrow(0).setWidth("150px");
        crud.getGrid().addColumn("slaHoras").setFlexGrow(0).setWidth("120px");
        crud.getGrid().setColumnReorderingAllowed(true);
        crud.getCrudFormFactory().setUseBeanValidation(true);
        crud.getCrudFormFactory().setVisibleProperties(new String[]{"nome", "descricao", "ativo", "editavel", "pedidoOrigem", "slaHoras", "sincronizavel", "pedidoTipo", "obrigaTagRetornoFuturo", "atualizaDataReferencia"});
        crud.getCrudFormFactory().setVisibleProperties(CrudOperation.UPDATE, new String[]{"nome", "descricao", "ativo", "editavel", "pedidoOrigem", "slaHoras", "sincronizavel", "pedidoTipo", "obrigaTagRetornoFuturo", "atualizaDataReferencia"});
        crud.getCrudFormFactory().setFieldProvider("pedidoOrigem", (FieldProvider & Serializable)() -> {
            ComboBox cb = new ComboBox("Origem", (Collection)this.pos.getByEstruturaTipo(this.getEstrutura().getEstruturaTipo()));
            cb.setItemLabelGenerator(PedidoOrigem::getNome);
            return cb;
        });
        crud.getCrudFormFactory().setFieldProvider("pedidoTipo", (FieldProvider & Serializable)() -> {
            ComboBox cb = new ComboBox("Tipo", (Object[])PedidoTipoEnum.values());
            cb.setItemLabelGenerator(Enum::name);
            return cb;
        });
        crud.getAddButton().setVisible(this.hasPermission("ATIVIDADE_ETAPA_SAVE"));
        crud.getUpdateButton().setVisible(this.hasPermission("ATIVIDADE_ETAPA_SAVE"));
        crud.getDeleteButton().setVisible(this.hasPermission("ATIVIDADE_ETAPA_DELETE"));
        crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        filterName.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> crud.refreshGrid());
        return crud;
    }
}

