/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.producaopainel.views.cadastro;

import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.pedido.model.PedidoItemEtapa;
import br.com.system.app.features.pedido.repository.PedidoItemEtapaRepository;
import br.com.system.app.features.producaopainel.model.ProducaoColunas;
import br.com.system.app.features.producaopainel.model.ProducaoPedidoItemEtapa;
import br.com.system.app.features.producaopainel.repository.ProducaoPedidoItemEtapaRepository;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.VaadinIcon;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class ProducaoItemEtapaView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final EstruturaUsuario eu;
    private final ProducaoColunas coluna;
    private final ProducaoPedidoItemEtapaRepository ppier;
    private final PedidoItemEtapaRepository pier;

    public ProducaoItemEtapaView(EstruturaUsuario eu, ProducaoColunas coluna, ProducaoPedidoItemEtapaRepository ppier, PedidoItemEtapaRepository pier) {
        this.eu = eu;
        this.coluna = coluna;
        this.ppier = ppier;
        this.pier = pier;
        this.createContent();
    }

    private void createContent() {
        if (this.coluna == null) {
            UIUtils.showNotification((String)"Linha esta nula");
            return;
        }
        this.setWidth("600px");
        this.setHeight("650px");
        MultiComboBox cbItemEtapa = new MultiComboBox("Etapa do Item", (Collection)this.pier.findByEstrutura(this.eu.getEstrutura()));
        cbItemEtapa.setItemLabelGenerator(PedidoItemEtapa::getNomeAndOrigem);
        List listaItem = this.ppier.findByProducaoColunas(this.coluna);
        if (listaItem.size() > 0) {
            HashSet<PedidoItemEtapa> value = new HashSet<PedidoItemEtapa>();
            for (ProducaoPedidoItemEtapa ppie : listaItem) {
                value.add(ppie.getPedidoItemEtapa());
            }
            cbItemEtapa.setValue(value);
        }
        Button salvar = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.INBOX, (String)"Salvar registro");
        salvar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (cbItemEtapa.getValue() == null || cbItemEtapa.getValue().size() <= 0) {
                UIUtils.showNotification((String)"Selecione pelo menos uma etapa do item");
                return;
            }
            this.ppier.deleteByProducaoColunas(this.coluna);
            for (PedidoItemEtapa pie : cbItemEtapa.getValue()) {
                ProducaoPedidoItemEtapa ppie = new ProducaoPedidoItemEtapa();
                ppie.setPedidoItemEtapa(pie);
                ppie.setProducaoColunas(this.coluna);
                this.ppier.save((Object)ppie);
            }
            UIUtils.showNotification((String)"Atualizado com sucesso");
            this.close();
        });
        Button close = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE, (String)"");
        close.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        this.add(new Component[]{new VerticalContainer(new Component[]{cbItemEtapa, new HorizontalContainer(new Component[]{close, salvar})})});
    }
}

