/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.produto.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.produto.model.ProdutoCategoria;
import br.com.system.app.features.produto.repository.ProdutoCategoriaRepository;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProdutoCategoriaService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ProdutoCategoriaRepository produtoCategoriaRepository;

    public ProdutoCategoria getById(Long id) {
        return (ProdutoCategoria)this.produtoCategoriaRepository.findById((Object)id).get();
    }

    public ProdutoCategoria save(ProdutoCategoria pc) {
        return (ProdutoCategoria)this.produtoCategoriaRepository.save((Object)pc);
    }

    @Transactional
    public void delete(ProdutoCategoria pc) {
        this.produtoCategoriaRepository.delete((Object)pc);
    }

    public List<ProdutoCategoria> getByEstrutura(Estrutura estrutura) {
        return this.getByEstrutura(estrutura, null);
    }

    public List<ProdutoCategoria> getByEstrutura(Estrutura estrutura, Pageable pageable) {
        if (estrutura.getEstruturaTipo().isProdutoExclusivo()) {
            return this.produtoCategoriaRepository.findByEstrutura(estrutura, pageable);
        }
        return this.produtoCategoriaRepository.findByEstruturaTipo(estrutura.getEstruturaTipo(), pageable);
    }

    public ProdutoCategoria getByEstruturaAndNome(Estrutura estrutura, String nome) {
        if (estrutura.getEstruturaTipo().isProdutoExclusivo()) {
            return this.produtoCategoriaRepository.findByEstruturaAndNome(estrutura, nome);
        }
        return this.produtoCategoriaRepository.findByEstruturaTipoAndNome(estrutura.getEstruturaTipo(), nome);
    }

    public long countByEstrutura(Estrutura estrutura) {
        if (estrutura.getEstruturaTipo().isProdutoExclusivo()) {
            return this.produtoCategoriaRepository.countByEstrutura(estrutura);
        }
        return this.produtoCategoriaRepository.countByEstruturaTipo(estrutura.getEstruturaTipo());
    }

    public List<ProdutoCategoria> getByEstruturaAndNomeContains(Estrutura estrutura, String nome, Pageable pageable) {
        if (estrutura.getEstruturaTipo().isProdutoExclusivo()) {
            return this.produtoCategoriaRepository.findByEstruturaAndNomeContains(estrutura, nome, pageable);
        }
        return this.produtoCategoriaRepository.findByEstruturaTipoAndNomeContains(estrutura.getEstruturaTipo(), nome, pageable);
    }

    public long countByEstruturaAndNomeContains(Estrutura estrutura, String nome) {
        if (estrutura.getEstruturaTipo().isProdutoExclusivo()) {
            return this.produtoCategoriaRepository.countByEstruturaAndNomeContains(estrutura, nome);
        }
        return this.produtoCategoriaRepository.countByEstruturaTipoAndNomeContains(estrutura.getEstruturaTipo(), nome);
    }

    public ProdutoCategoria getCategoriaGenerica(Estrutura estrutura) {
        ProdutoCategoria categoria = this.getByEstruturaAndNome(estrutura, "GENERICO");
        if (categoria == null) {
            categoria = new ProdutoCategoria();
            if (estrutura.getEstruturaTipo().isProdutoExclusivo()) {
                categoria.setEstrutura(estrutura);
            }
            categoria.setEstruturaTipo(estrutura.getEstruturaTipo());
            categoria.setNome("GENERICO");
            categoria.setVisivelPainel(Boolean.TRUE);
            categoria = (ProdutoCategoria)this.produtoCategoriaRepository.save((Object)categoria);
        }
        return categoria;
    }
}

