/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.produto.service;

import br.com.system.app.features.email.service.SendMailService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaTipo;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.produto.dto.ProdutoDTO;
import br.com.system.app.features.produto.model.Produto;
import br.com.system.app.features.produto.model.ProdutoCategoria;
import br.com.system.app.features.produto.model.ProdutoOrigem;
import br.com.system.app.features.produto.repository.ProdutoRepository;
import br.com.system.app.features.produto.service.ProdutoCategoriaService;
import br.com.system.app.features.shared.exception.BusinessException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProdutoService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ProdutoRepository produtoRepository;
    @Autowired
    private ProdutoCategoriaService produtoCategoriaService;
    @Autowired
    private SendMailService sendMail;

    public List<ProdutoDTO> buscarProdutos(EstruturaTipo estruturaTipo, String nome, ProdutoCategoria categoria, Boolean ativo, Pageable pageable) {
        return this.produtoRepository.findProdutos(estruturaTipo, nome, categoria, ativo, pageable);
    }

    public List<Produto> getProdutos(Estrutura estrutura) {
        if (estrutura.getEstruturaTipo().isProdutoExclusivo()) {
            return this.produtoRepository.findByEstrutura(estrutura);
        }
        return this.produtoRepository.findByEstruturaTipo(estrutura.getEstruturaTipo());
    }

    public List<Produto> getProdutosByOrigem(Estrutura estrutura, ProdutoOrigem origem) {
        if (estrutura.getEstruturaTipo().isProdutoExclusivo()) {
            return this.produtoRepository.findByEstruturaAndOrigemAndAtivo(estrutura, origem, Boolean.valueOf(true));
        }
        return this.produtoRepository.findByEstruturaTipoAndOrigemAndAtivo(estrutura.getEstruturaTipo(), origem, Boolean.valueOf(true));
    }

    public List<Produto> getProdutosByOrigemAndCategoria(Estrutura estrutura, ProdutoOrigem origem, ProdutoCategoria categoria) {
        if (estrutura.getEstruturaTipo().isProdutoExclusivo()) {
            return this.produtoRepository.findByEstruturaAndOrigemAndCategoriaAndAtivo(estrutura, origem, categoria, Boolean.valueOf(true));
        }
        return this.produtoRepository.findByEstruturaTipoAndOrigemAndCategoriaAndAtivo(estrutura.getEstruturaTipo(), origem, categoria, Boolean.valueOf(true));
    }

    public List<Produto> getProdutosByCategoria(Estrutura estrutura, ProdutoCategoria categoria) {
        if (estrutura.getEstruturaTipo().isProdutoExclusivo()) {
            return this.produtoRepository.findByEstruturaAndCategoria(estrutura, categoria);
        }
        return this.produtoRepository.findByEstruturaTipoAndCategoria(estrutura.getEstruturaTipo(), categoria);
    }

    public Produto getById(Long id) {
        return (Produto)this.produtoRepository.findById((Object)id).get();
    }

    public void deletar(Produto produto) {
        this.produtoRepository.delete((Object)produto);
    }

    public Produto getAndCreate(Pedido pedido, Estrutura estrutura, ProdutoOrigem produtoOrigem, ProdutoCategoria produtoCategoria, String nome, String descricao) {
        List lista;
        if ((nome = nome.replace("  ", " ").trim()).isEmpty()) {
            throw new BusinessException("Nome do produo n\u00e3o informado");
        }
        String[] arr = nome.split("-");
        if (arr.length > 1) {
            nome = arr[0];
        }
        if ((lista = this.produtoRepository.findByEstruturaTipoAndNomeAndOrigem(estrutura.getEstruturaTipo(), nome, produtoOrigem)).size() <= 0) {
            if (produtoCategoria == null) {
                produtoCategoria = this.produtoCategoriaService.getCategoriaGenerica(estrutura);
            }
            String msg = "Parceiro: " + estrutura.getNome() + " Nome Produto: " + nome + " Atividade: " + (pedido.getNumero() == null ? "" : pedido.getNumero());
            this.sendMail.sendNoReply(null, "neocrmoficial@gmail.com", "Novo Produto " + nome, msg);
            Produto produto = new Produto();
            if (estrutura.getEstruturaTipo().isProdutoExclusivo()) {
                produto.setEstrutura(estrutura);
            }
            produto.setCategoria(produtoCategoria);
            produto.setDescricao(descricao);
            produto.setEstruturaTipo(estrutura.getEstruturaTipo());
            produto.setNome(nome);
            produto.setDescontoPrateleira(BigDecimal.ZERO);
            produto.setOrigem(produtoOrigem);
            produto.setValor(BigDecimal.ZERO);
            produto.setSomaQuantidade(Boolean.TRUE);
            produto.setCompromissoMensal(Boolean.FALSE);
            produto.setAtivo(Boolean.TRUE);
            return (Produto)this.produtoRepository.save((Object)produto);
        }
        return (Produto)lista.get(0);
    }

    public List<ProdutoCategoria> getByEstrutura(Estrutura estrutura) {
        return this.produtoCategoriaService.getByEstrutura(estrutura);
    }

    @Transactional
    @Modifying
    public void deleteByEstrutura(Estrutura e) {
        List categorias = this.getByEstrutura(e);
        for (ProdutoCategoria categoria : categorias) {
            this.produtoCategoriaService.delete(categoria);
        }
        this.produtoRepository.deleteByEstrutura(e);
    }
}

