/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.receitafederal.service;

import br.com.system.app.features.cep.model.CepLocalidade;
import br.com.system.app.features.cep.model.CepTipoLocalidadeEnum;
import br.com.system.app.features.cep.model.CepUf;
import br.com.system.app.features.cep.repository.CepLocalidadeRepository;
import br.com.system.app.features.cep.repository.CepUfRepository;
import br.com.system.app.features.cnae.model.Cnae;
import br.com.system.app.features.cnae.repository.CnaeRepository;
import br.com.system.app.features.mailing.model.Mailing;
import br.com.system.app.features.mailing.model.MailingAtividade;
import br.com.system.app.features.mailing.model.MailingContato;
import br.com.system.app.features.mailing.model.MailingSocio;
import br.com.system.app.features.mailing.model.MailingSocioTipoEnum;
import br.com.system.app.features.mailing.model.MailingTipoContatoEnum;
import br.com.system.commons.SleepUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.datetime.DateTimeUtil;
import br.com.system.commons.datetime.FormatDate;
import br.com.system.integreation.conexaoExterna.ExternalConnection;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReceitawsService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private CepUfRepository cepUfRepository;
    @Autowired
    private CepLocalidadeRepository cepLocalidadeRepository;
    @Autowired
    private CnaeRepository cnaeRepository;

    public static void main(String[] args) {
        new ReceitawsService().sincronizar("61507093000130", true);
    }

    public Mailing sincronizar(String cnpj, boolean forcar) {
        try {
            CepLocalidade loc;
            Mailing m = new Mailing();
            ExternalConnection conexao = new ExternalConnection();
            conexao.addHeader("Authorization", "Bearer 7bc90d870c6a8bd4f2db8d77b50a512b5a38c65fd3ac7ba10d795dbcc07a4a1b");
            int retry = 0;
            JSONObject j = null;
            while (retry < 3) {
                String html = conexao.executeGet("https://www.receitaws.com.br/v1/cnpj/" + cnpj + "/days/" + (forcar ? 1 : 30)).getReturnedHtml();
                j = new JSONObject(html);
                if (j.toString().contains("Too many requests, please")) {
                    SleepUtil.inSeconds((Integer)10);
                    ++retry;
                    continue;
                }
                retry = 99;
            }
            if (j == null || j.optString("cnpj") == null || !cnpj.equals(StringUtil.numbersOnly((String)j.optString("cnpj")))) {
                return null;
            }
            Set lma = this.getAtividades(m, j, "atividade_principal");
            lma.addAll(this.getAtividades(m, j, "atividades_secundarias"));
            m.setAtividades(lma);
            m.setBairro(j.optString("bairro"));
            m.setCapitalSocial(j.has("capital_social") ? j.getBigDecimal("capital_social") : null);
            m.setCep(StringUtil.numbersOnly((String)j.optString("cep")));
            m.setCidade(j.optString("municipio").replace("'", ""));
            m.setComplemento(j.optString("complemento"));
            m.setContatos(this.getContatos(m, j));
            m.setCpfCnpj(cnpj);
            m.setDataAbertura(DateTimeUtil.toDate((String)j.optString("abertura"), (FormatDate)FormatDate.DATE_BR));
            m.setDataHoraAtualizacao(LocalDateTime.now());
            m.setDataSituacao(DateTimeUtil.toDate((String)j.optString("data_situacao"), (FormatDate)FormatDate.DATE_BR));
            m.setDataSituacaoEspecial(DateTimeUtil.toDate((String)j.optString("data_situacao_especial"), (FormatDate)FormatDate.DATE_BR));
            m.setEstado(j.optString("uf"));
            m.setLogradouro(j.optString("logradouro"));
            m.setMatrizFilial(j.optString("tipo"));
            m.setMotivoSituacaoEspecial(j.optString("situacao_especial"));
            m.setNaturezaJuridica(this.getNaturezaJuridica(j));
            m.setNome(j.optString("nome"));
            m.setNomeFantasia(j.optString("fantasia"));
            m.setNumero(j.optString("numero"));
            m.setOpcaoMei(null);
            m.setPorte(j.optString("porte"));
            m.setSituacao(j.optString("situacao"));
            m.setSituacaoEspecial(j.optString("situacao_especial"));
            m.setSocios(this.getSocios(m, j));
            CepUf cepUf = this.cepUfRepository.findBySigla(m.getEstado());
            if (cepUf != null && (loc = this.cepLocalidadeRepository.findByUfAndNome(cepUf, m.getCidade().replaceAll("-", ""), CepTipoLocalidadeEnum.MUNICIPIO)) != null) {
                m.setDdd(Integer.valueOf(StringUtil.toInt((String)loc.getDdd())));
            }
            return m;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Set<MailingAtividade> getAtividades(Mailing m, JSONObject j, String tipo) {
        HashSet<MailingAtividade> retorno = new HashSet<MailingAtividade>();
        JSONArray arrP = j.optJSONArray(tipo);
        if (arrP != null && arrP.length() > 0) {
            for (int i = 0; i < arrP.length(); ++i) {
                Cnae cnaePrincipal;
                JSONObject o = arrP.optJSONObject(i);
                if (o == null || (cnaePrincipal = this.cnaeRepository.findByCodigo(o.optString("code"))) == null) continue;
                MailingAtividade atv = new MailingAtividade();
                atv.setCnae(cnaePrincipal);
                atv.setMailing(m);
                atv.setPrincipal(Boolean.valueOf(tipo.equals("atividade_principal")));
                retorno.add(atv);
            }
        }
        return retorno;
    }

    private Set<MailingContato> getContatos(Mailing m, JSONObject j) {
        HashSet<MailingContato> retorno = new HashSet<MailingContato>();
        retorno.add(new MailingContato(m, MailingTipoContatoEnum.EMAIL, j.optString("email")));
        retorno.add(new MailingContato(m, MailingTipoContatoEnum.TELEFONE, j.optString("telefone")));
        return retorno;
    }

    private String getNaturezaJuridica(JSONObject j) {
        String jn = j.optString("natureza_juridica");
        if (jn == null) {
            return "";
        }
        String[] arr = jn.split(" ");
        if (arr.length <= 0) {
            return "";
        }
        return StringUtil.numbersOnly((String)arr[0]);
    }

    private Set<MailingSocio> getSocios(Mailing m, JSONObject j) {
        HashSet<MailingSocio> retorno = new HashSet<MailingSocio>();
        JSONArray arrP = j.optJSONArray("qsa");
        if (arrP != null && arrP.length() > 0) {
            for (int i = 0; i < arrP.length(); ++i) {
                JSONObject o = arrP.optJSONObject(i);
                if (o == null) continue;
                MailingSocio ms = new MailingSocio();
                ms.setMailing(m);
                ms.setNome(o.optString("nome"));
                ms.setQualificacao(Integer.valueOf(StringUtil.numbersOnly((String)o.optString("qual"))));
                ms.setMailingSocioTipo(MailingSocioTipoEnum.FISICA);
                retorno.add(ms);
            }
        }
        return retorno;
    }
}

