/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.receitafederal.view;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.ProgressBar;
import br.com.system.app.features.cep.service.CepService;
import br.com.system.app.features.cnae.service.CnaeService;
import br.com.system.app.features.configurations.model.ConfigurationEnum;
import br.com.system.app.features.configurations.service.ConfigurationsService;
import br.com.system.app.features.enriquecimento.service.EnriquecimentoService;
import br.com.system.app.features.estrutura.service.EstruturaTipoService;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.FlexBoxLayout;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.mailing.projection.MailingLimited;
import br.com.system.app.features.mailing.repository.filter.MailingFilter;
import br.com.system.app.features.mailing.service.MailingReceitaService;
import br.com.system.app.features.mailing.service.MailingService;
import br.com.system.app.features.oportunidade.service.OportunidadeService;
import br.com.system.app.features.pedido.service.PedidoTagsService;
import br.com.system.app.features.receitafederal.service.ReceitaFederalService;
import br.com.system.app.features.receitafederal.view.ReceitaAtividadeView;
import br.com.system.app.features.receitafederal.view.ReceitaFilterView;
import br.com.system.app.features.receitafederal.view.ReceitaGridView;
import br.com.system.app.features.receitafederal.view.ReceitaView;
import br.com.system.app.features.shared.model.TipoProcessoEnum;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.features.vivo.model.VivoProspectBiDTO;
import br.com.system.app.features.vivo.service.VivoProspectBiService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.Command;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

@Route(value="receita-federal", layout=MainLayout.class)
@PageTitle(value="Base Receita Federal")
@RolesAllowed(value={"RECEITA_FEDERAL_VIEW"})
public class ReceitaView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final CepService cepService;
    private final CnaeService cnaeService;
    private final MailingService mailingService;
    private final OportunidadeService oportunidadeService;
    private final EstruturaUsuarioService eus;
    private final EstruturaTipoService estruturaTipoService;
    private final MailingReceitaService mailingReceitaService;
    private final EnriquecimentoService enriquecimentoService;
    private final ReceitaFederalService receitaFederalService;
    private final ConfigurationsService configurationsService;
    private final UsuarioHierarquiaService hierarquiaService;
    private final VivoProspectBiService vivoProspectBiService;
    private final PedidoTagsService pedidoTagsService;
    private final ProgressBar progressBar = new ProgressBar(Boolean.TRUE);
    private ReceitaFilterView filter;
    private ReceitaGridView receitaGridView;
    private Integer disp = 0;
    private Button btnFilterView;
    private Checkbox cbWhats;
    private Checkbox cbSocios;
    private DownloadDialog dd;
    private MailingFilter mailigFilter;
    private int page;

    @Autowired
    public ReceitaView(CepService cepService, CnaeService cnaeService, MailingService mailingService, OportunidadeService oportunidadeService, EstruturaUsuarioService eus, MailingReceitaService mailingReceitaService, EnriquecimentoService enriquecimentoService, ReceitaFederalService receitaFederalService, ConfigurationsService configurationsService, UsuarioHierarquiaService hierarquiaService, VivoProspectBiService vivoProspectBiService, EstruturaTipoService estruturaTipoService, PedidoTagsService pedidoTagsService) {
        this.pedidoTagsService = pedidoTagsService;
        this.estruturaTipoService = estruturaTipoService;
        this.vivoProspectBiService = vivoProspectBiService;
        this.hierarquiaService = hierarquiaService;
        this.cepService = cepService;
        this.configurationsService = configurationsService;
        this.receitaFederalService = receitaFederalService;
        this.enriquecimentoService = enriquecimentoService;
        this.mailingReceitaService = mailingReceitaService;
        this.cnaeService = cnaeService;
        this.mailingService = mailingService;
        this.oportunidadeService = oportunidadeService;
        this.eus = eus;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        }
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.filter.clear();
    }

    private Component createContent() {
        this.page = 0;
        this.dd = new DownloadDialog();
        this.cbWhats = new Checkbox("Consultar Se Tem Whatsapp R$ " + String.valueOf(this.configurationsService.get(ConfigurationEnum.VALOR_TEM_WHATS).getBigDecimal()) + " por n\u00famero");
        this.cbWhats.setVisible(false);
        this.cbWhats.setValue((Object)false);
        this.cbSocios = new Checkbox("Consultar Socios", true);
        this.receitaGridView = new ReceitaGridView(this.mailingService);
        this.receitaGridView.create();
        FlexBoxLayout mainContainer = new FlexBoxLayout(FlexLayout.FlexDirection.COLUMN, new Component[0]).setSpacingS();
        this.receitaGridView.getBtnOportunidade().addClickListener((ComponentEventListener & Serializable)e -> this.openDialog(ProcessoEnum.OPORTUNIDADE));
        this.receitaGridView.getBtnProspectBi().addClickListener((ComponentEventListener & Serializable)e -> this.openDialog(ProcessoEnum.PROSPECT_BI));
        this.receitaGridView.getBtnAtividade().addClickListener((ComponentEventListener & Serializable)e -> this.openDialog(ProcessoEnum.ATIVIDADE));
        this.receitaGridView.getBtnEnriquecimento().addClickListener((ComponentEventListener & Serializable)e -> this.openDialog(ProcessoEnum.ENRIQUECIMENTO));
        this.receitaGridView.getBtnNextPage().addClickListener((ComponentEventListener & Serializable)e -> {
            ++this.page;
            this.povoa();
        });
        this.receitaGridView.getBtnPrevPage().addClickListener((ComponentEventListener & Serializable)e -> {
            int n;
            if (this.page-- <= 0) {
                n = 0;
            } else {
                int n2 = this.page;
                n = n2;
                this.page = n2 - 1;
            }
            this.page = n;
            this.povoa();
        });
        this.receitaGridView.getBtnSincronia().addClickListener((ComponentEventListener & Serializable)e -> {
            if (!this.isMaster() && this.receitaGridView.getGrid().getSelectedItems().size() != 1) {
                this.showNotification("Sincroniza\u00e7\u00e3o s\u00f3 pode ser feita em 1 cnpj por vez");
                return;
            }
            Set selectedItems = this.receitaGridView.getGrid().getSelectedItems();
            ArrayList lista = selectedItems.size() <= 0 ? this.mailingService.filter(this.filter.getMailigFilter(), this.getEu(), (Pageable)PageRequest.of((int)0, (int)10000)) : new ArrayList(selectedItems);
            this.mailingReceitaService.forcarReceita(lista, this.getEu());
            UIUtils.showProcessNotification();
        });
        this.filter = new ReceitaFilterView(this.cepService, this.cnaeService, this.getEu(), this.configurationsService, this.estruturaTipoService);
        this.filter.getBtnPesquisar().addClickListener((ComponentEventListener & Serializable)e -> {
            if (!(this.filter.getCbUf() != null && this.filter.getCbUf().getValue() != null || this.filter.getMailigFilter().getFilterCep() != null && !this.filter.getMailigFilter().getFilterCep().isEmpty() || this.filter.getListaCpfCnpj() != null && !this.filter.getListaCpfCnpj().isEmpty())) {
                this.showNotification("Selecione o estado");
            } else {
                this.receitaGridView.getBtnEnriquecimento().setEnabled(true);
                this.receitaGridView.getBtnOportunidade().setEnabled(true);
                this.receitaGridView.getBtnAtividade().setEnabled(true);
                this.receitaGridView.getBtnProspectBi().setEnabled(true);
                this.receitaGridView.getBtnContar().setEnabled(true);
                this.receitaGridView.getBtnSincronia().setEnabled(true);
                this.receitaGridView.getBtnNextPage().setEnabled(true);
                this.receitaGridView.getBtnPrevPage().setEnabled(true);
                this.povoa();
            }
            this.receitaGridView.getLabelRowCont().setText("");
            this.filter.getBtnPesquisar().setEnabled(true);
        });
        this.btnFilterView = UIUtils.createSmallButton((String)"Esconder Filtro", (String)"");
        this.btnFilterView.setWidthFull();
        this.btnFilterView.addClickListener((ComponentEventListener & Serializable)e -> this.changeFilterView());
        this.receitaGridView.getBtnContar().addClickListener((ComponentEventListener & Serializable)e -> {
            ConfirmationDialog cd = new ConfirmationDialog("Contagem de registros", "Este processo pode ser extremamente demorado. Tem certeza que deseja continuar?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                cd.close();
                this.contar();
            });
        });
        mainContainer.add(new Component[]{this.filter.getCard(), this.btnFilterView, this.receitaGridView.getView()});
        mainContainer.setHeightFull();
        return mainContainer;
    }

    private void contar() {
        this.mailingService.count(this.mailigFilter, this.getEu(), arg_0 -> this.listenerCount(arg_0));
        this.progressBar.setText("Contando Registros, aguarde").open();
    }

    private void listenerCount(Long total) {
        ((UI)this.getUI().get()).access((Command & Serializable)() -> {
            this.progressBar.close();
            this.receitaGridView.getLabelRowCont().setText(UIUtils.formatThousand((int)total.intValue()));
        });
    }

    private void povoa() {
        try {
            this.mailigFilter = this.filter.getMailigFilter();
            if (this.mailigFilter.getDocsFilters() != null && this.mailigFilter.getDocsFilters().size() == 1) {
                this.mailingService.buscarCnpj((String)this.mailigFilter.getDocsFilters().get(0));
            }
            this.mailingService.filter(this.mailigFilter, this.getEu(), (Pageable)PageRequest.of((int)this.page, (int)60), arg_0 -> this.listenerPopulate(arg_0));
            this.progressBar.setText("Buscando registros, aguarde...").open();
        }
        catch (Exception e) {
            UIUtils.showNotification((String)("Erro ao povoar grid " + e.getMessage()));
        }
    }

    public void listenerPopulate(List<MailingLimited> lista) {
        ((UI)this.getUI().get()).access((Command & Serializable)() -> {
            this.receitaGridView.getBtnContar().setVisible(true);
            this.progressBar.close();
            this.receitaGridView.getGrid().setItems((Collection)lista);
            this.receitaGridView.getBtnNextPage().setEnabled(!lista.isEmpty());
            this.receitaGridView.getBtnPrevPage().setEnabled(this.page > 0);
        });
    }

    private void openDialog(ProcessoEnum processo) {
        Set selectedItems = this.receitaGridView.getGrid().getSelectedItems();
        Dialog dialog = new Dialog();
        this.disp = processo.equals((Object)ProcessoEnum.OPORTUNIDADE) ? this.oportunidadeService.getLimiteDisponivel(this.getEu().getEstrutura()) : (processo.equals((Object)ProcessoEnum.ENRIQUECIMENTO) ? Integer.valueOf(50000) : (processo.equals((Object)ProcessoEnum.ATIVIDADE) ? this.receitaFederalService.temLimiteAtividade(this.getEstrutura()) : (processo.equals((Object)ProcessoEnum.PROSPECT_BI) ? this.vivoProspectBiService.getLimit(this.getEu()) : Integer.valueOf(0))));
        Span label = UIUtils.createSmallSpan((String)("Limite disponivel: " + this.disp + (processo.equals((Object)ProcessoEnum.ENRIQUECIMENTO) ? "(limitado a seu saldo)" : "")));
        NumberField quantos = new NumberField("Quantos?");
        quantos.setMax((double)this.disp.intValue());
        quantos.setMin(1.0);
        TextField nome = new TextField("Nome Campanha");
        TextArea descricao = new TextArea("Informa\u00e7\u00f5es");
        descricao.setHeight("100px");
        Button btn = UIUtils.createSmallButton((String)(processo.equals((Object)ProcessoEnum.ATIVIDADE) ? "Continuar" : "Criar"), (String)"");
        btn.setDisableOnClick(true);
        btn.addClickListener((ComponentEventListener & Serializable)e -> {
            btn.setEnabled(true);
            if (nome.isEmpty() && (processo.equals((Object)ProcessoEnum.OPORTUNIDADE) || processo.equals((Object)ProcessoEnum.ENRIQUECIMENTO))) {
                this.showNotification("Informe um nome para a campanha");
                return;
            }
            if (descricao.isEmpty() && processo.equals((Object)ProcessoEnum.ATIVIDADE)) {
                this.showNotification("Informe uma descri\u00e7\u00e3o para a atividade");
                return;
            }
            if (selectedItems.size() <= 0 && (quantos.getValue() == null || (Double)quantos.getValue() <= 0.0)) {
                this.showNotification("Selecione alguns itens ou informe a quantidade que deseja selecionar automaticamente");
                return;
            }
            if (selectedItems.size() <= 0 && ((Double)quantos.getValue()).intValue() > this.disp) {
                this.showNotification("Limite ultrapassado.");
                return;
            }
            HashSet<String> listaCnpj = new HashSet<String>();
            ArrayList lista = selectedItems.size() <= 0 ? this.mailingService.filter(this.filter.getMailigFilter(), this.getEu(), (Pageable)PageRequest.of((int)0, (int)((Double)quantos.getValue()).intValue())) : new ArrayList(selectedItems);
            for (Object selectedItem : lista) {
                listaCnpj.add(selectedItem.getCnpj());
            }
            if (processo.equals((Object)ProcessoEnum.ATIVIDADE)) {
                new ReceitaAtividadeView(lista, this.getEu(), this.eus, descricao.getValue(), this.receitaFederalService, this.hierarquiaService, this.pedidoTagsService);
            } else if (processo.equals((Object)ProcessoEnum.OPORTUNIDADE)) {
                this.oportunidadeService.exportacao(listaCnpj, this.getEu(), nome.getValue(), TipoProcessoEnum.CNPJ, (Boolean)this.cbWhats.getValue());
            } else if (processo.equals((Object)ProcessoEnum.ENRIQUECIMENTO)) {
                this.enriquecimentoService.processar(this.getEu(), listaCnpj, nome.getValue(), TipoProcessoEnum.CNPJ, ((Boolean)this.cbWhats.getValue()).booleanValue(), ((Boolean)this.cbSocios.getValue()).booleanValue(), false);
            } else if (processo.equals((Object)ProcessoEnum.PROSPECT_BI)) {
                ArrayList<VivoProspectBiDTO> listaDto = new ArrayList<VivoProspectBiDTO>();
                for (MailingLimited m : lista) {
                    VivoProspectBiDTO d = new VivoProspectBiDTO();
                    d.setCep(m.getCep());
                    d.setCnpj(m.getCnpj());
                    d.setNumero(m.getNumero());
                    listaDto.add(d);
                }
                String url = this.vivoProspectBiService.gerarArquivo(this.getEu(), listaDto);
                this.dd.open(url, "ProspectBi.csv", true);
            }
            this.mailingService.registerMailingView(lista, this.getEu());
            dialog.close();
        });
        FlexBoxLayout dLay = new FlexBoxLayout(FlexLayout.FlexDirection.COLUMN, new Component[0]).setSpacingS();
        dLay.add(new Component[]{label});
        if (processo.equals((Object)ProcessoEnum.ATIVIDADE)) {
            dLay.add(new Component[]{descricao});
        } else if (processo.equals((Object)ProcessoEnum.ENRIQUECIMENTO) || processo.equals((Object)ProcessoEnum.OPORTUNIDADE)) {
            dLay.add(new Component[]{nome});
        }
        if (selectedItems.size() <= 0) {
            dLay.add(new Component[]{quantos});
        }
        if (!processo.equals((Object)ProcessoEnum.PROSPECT_BI) && !processo.equals((Object)ProcessoEnum.ATIVIDADE)) {
            dLay.add(new Component[]{this.cbWhats});
            if (processo.equals((Object)ProcessoEnum.ENRIQUECIMENTO)) {
                dLay.add(new Component[]{this.cbSocios});
            }
        }
        dLay.add(new Component[]{btn});
        dialog.add(new Component[]{dLay});
        dialog.open();
    }

    private void changeFilterView() {
        if (this.btnFilterView.getText().equals("Esconder Filtro")) {
            this.btnFilterView.setText("Mostrar Filtro");
            this.filter.getCard().setVisible(false);
        } else {
            this.btnFilterView.setText("Esconder Filtro");
            this.filter.getCard().setVisible(true);
        }
    }
}

