/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.resumoAbr.service;

import br.com.system.app.features.configurations.model.ConfigurationEnum;
import br.com.system.app.features.configurations.service.ConfigurationsService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.portabilidade.model.Portabilidade;
import br.com.system.app.features.portabilidade.service.PortabilidadeConsultaService;
import br.com.system.app.features.resumoAbr.model.ResumoAbrDTO;
import br.com.system.app.features.resumoAbr.model.ResumoAbrFile;
import br.com.system.app.features.resumoAbr.repository.ResumoAbrRepository;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.shared.model.StatusProcessoEnum;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.commons.HashUtil;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.TelefoneUtil;
import br.com.system.commons.datetime.FormatDate;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Set;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ResumoAbrService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ResumoAbrRepository resumoAbrRepository;
    @Autowired
    private UsuarioHierarquiaService hierarquiaService;
    @Autowired
    private PortabilidadeConsultaService portabilidadeService;
    @Autowired
    private ConfigurationsService configurationsService;

    public ResumoAbrDTO consultaIndividual(String telefone) {
        ResumoAbrDTO rad = new ResumoAbrDTO();
        Portabilidade portabilidade = this.portabilidadeService.getPortabilidade(StringUtil.toLong((String)telefone));
        rad.setTelefone(telefone);
        rad.setOperadora(portabilidade.getOperadora().getNome());
        rad.setPortabilidade(portabilidade.getDataHora().format(FormatDate.DATE_BR.toDTF()));
        return rad;
    }

    @Async(value="asyncDefault")
    public void processar(EstruturaUsuario estruturaUsuario, Set<String> listaTelefones, String originalFilename) {
        Thread.currentThread().setName("asyncDefault-resumo-abr");
        originalFilename = StringUtil.normalize((String)originalFilename);
        ResumoAbrFile resumoAbrFile = new ResumoAbrFile();
        resumoAbrFile.setDataHoraImportacao(LocalDateTime.now());
        resumoAbrFile.setEstruturaUsuario(estruturaUsuario);
        resumoAbrFile.setNomeArquivo(originalFilename);
        resumoAbrFile.setStatusProcesso(StatusProcessoEnum.PROCESSANDO);
        resumoAbrFile.setTotalRegistros(Integer.valueOf(listaTelefones.size()));
        resumoAbrFile = (ResumoAbrFile)this.resumoAbrRepository.save((Object)resumoAbrFile);
        this.importacaoFile(resumoAbrFile, listaTelefones);
    }

    public Page<ResumoAbrFile> listFiles(EstruturaUsuario estruturaUsuario, String nome, Pageable pageable) {
        Long[] hierarquia = this.hierarquiaService.getHierarquiaLongArray(estruturaUsuario);
        if (nome.isEmpty()) {
            return this.resumoAbrRepository.findByHierarquia(hierarquia, pageable);
        }
        return this.resumoAbrRepository.findByHierarquiaAndNomeArquivo(hierarquia, nome, pageable);
    }

    public long count(EstruturaUsuario estruturaUsuario, String nome) {
        Long[] hierarquia = this.hierarquiaService.getHierarquiaLongArray(estruturaUsuario);
        if (nome.isEmpty()) {
            return this.resumoAbrRepository.countByHierarquia(hierarquia);
        }
        return this.resumoAbrRepository.countByHierarquiaAndNomeArquivo(hierarquia, nome);
    }

    @Transactional
    public void deleteFile(ResumoAbrFile raf) {
        this.resumoAbrRepository.delete((Object)raf);
    }

    private void importacaoFile(ResumoAbrFile resumoAbrFile, Set<String> listaTelefones) {
        InputStream is = null;
        XSSFWorkbook xls = null;
        try {
            is = StorageUtil.getObject((String)"ResumoABR-v1.xlsx");
            xls = new XSSFWorkbook(is);
            Sheet aba = xls.getSheetAt(0);
            int size = listaTelefones.size();
            int limite = this.configurationsService.get(ConfigurationEnum.LIMITE_CONSULTA_ABR).getIntValue();
            if (size > limite) {
                resumoAbrFile.setStatusProcesso(StatusProcessoEnum.FINALIZADO_COM_ERRO);
                resumoAbrFile.setObservacao("Limite maximo de " + limite + " por arquivo");
                this.resumoAbrRepository.save((Object)resumoAbrFile);
                throw new BusinessException("Maximo 5000 por importa\u00e7\u00e3o");
            }
            int iRow = 1;
            for (String t : listaTelefones) {
                Portabilidade portabilidade;
                String telefone = TelefoneUtil.normalize((String)t);
                if (telefone.length() < 10 || telefone.length() > 11 || (portabilidade = this.portabilidadeService.getPortabilidade(StringUtil.toLong((String)telefone))) == null) continue;
                Row row = aba.createRow(iRow);
                row.createCell(0).setCellValue(telefone);
                row.createCell(1).setCellValue(portabilidade.getOperadora() == null ? "" : portabilidade.getOperadora().getNome());
                row.createCell(2).setCellValue(portabilidade.getDataHora() == null ? "" : portabilidade.getDataHora().format(FormatDate.DATETIME_BR.toDTF()));
                ++iRow;
            }
            String hashFile = HashUtil.getUUI() + ".xlsx";
            InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)xls);
            String hash = StorageUtil.uploadObjectInputStream((String)hashFile, (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
            resumoAbrFile.setUrlArquivo(hash);
            resumoAbrFile.setStatusProcesso(StatusProcessoEnum.FINALIZADO);
            resumoAbrFile.setDataHoraImportacao(LocalDateTime.now());
            this.resumoAbrRepository.save((Object)resumoAbrFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            resumoAbrFile.setStatusProcesso(StatusProcessoEnum.FINALIZADO_COM_ERRO);
            this.resumoAbrRepository.save((Object)resumoAbrFile);
            throw new BusinessException("Problemas ao exportar: " + e.getMessage());
        }
        finally {
            try {
                xls.close();
                is.close();
            }
            catch (Exception exception) {}
        }
    }
}

