/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.sac.service;

import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.sac.model.SacChamado;
import br.com.system.app.features.sac.model.SacTipo;
import br.com.system.app.features.sac.repository.SacRepository;
import br.com.system.app.features.sac.service.SacTipoService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.shared.exception.ResourceNotFoundException;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.service.UsuarioService;
import java.io.Serializable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SacService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private SacRepository sacRepository;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private SacTipoService sacTipoService;

    public SacChamado salvar(SacChamado sac) {
        SacChamado sacSalvo = this.sacRepository.findById((Object)sac.getId()).orElse(null);
        BeanUtils.copyProperties((Object)sac, (Object)sacSalvo, (String[])new String[]{"id"});
        Usuario usuario = (Usuario)this.usuarioService.getById(sac.getUsuario().getId()).orElseThrow(() -> new BusinessException("exceptions.usuario.not-found"));
        Cliente cliente = this.clienteService.buscarPeloId(sac.getCliente().getId());
        SacTipo sacTipo = this.sacTipoService.buscarPeloId(sac.getSacTipo().getId());
        sac.setUsuario(usuario);
        sac.setCliente(cliente);
        sac.setSacTipo(sacTipo);
        sac.setEtapa(sacTipo.getEtapaInicial());
        return (SacChamado)this.sacRepository.save((Object)sac);
    }

    public SacChamado buscarPeloId(Long id) {
        SacChamado sac = this.sacRepository.findById((Object)id).orElse(null);
        if (sac == null) {
            throw new ResourceNotFoundException();
        }
        return sac;
    }
}

