/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.sessions.repository;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.sessions.model.SessionsDTO;
import br.com.system.app.features.sessions.repository.SessionsRepositoryQuery;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.commons.StringUtil;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public class SessionsRepositoryImpl
implements SessionsRepositoryQuery {
    @PersistenceContext
    private EntityManager manager;
    @Autowired
    private UsuarioHierarquiaService hierarquiaService;

    @Transactional(readOnly=true)
    public List<SessionsDTO> getSessions(EstruturaUsuario eu, Boolean activeOnly, LocalDate dataInicial, LocalDate dataFinal, String userFilter, Pageable pageable) {
        Query query = this.getQuery(false, eu, activeOnly, dataInicial, dataFinal, userFilter, pageable);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public Long countSessions(EstruturaUsuario eu, Boolean activeOnly, LocalDate dataInicial, LocalDate dataFinal, String userFilter) {
        Query query = this.getQuery(true, eu, activeOnly, dataInicial, dataFinal, userFilter, null);
        return StringUtil.toLong((String)query.getSingleResult().toString());
    }

    public Query getQuery(boolean count, EstruturaUsuario eu, Boolean activeOnly, LocalDate dataInicial, LocalDate dataFinal, String userFilter, Pageable pageable) {
        Query query;
        StringBuilder sql = new StringBuilder();
        if (count) {
            sql.append("select count(*) as total");
        } else {
            sql.append("select sessions.id,session_id,data_hora_criacao,last_heartbeat,ip_address,browser,");
            sql.append(" user_agent,os,ativa,usuario.nome nome_usuario,usuario.login login_usuario,sessions.hostname");
        }
        sql.append(" from sessions,estrutura_usuario,usuario");
        sql.append(" where sessions.estrutura_usuario_id=estrutura_usuario.id");
        sql.append(" and estrutura_usuario.usuario_id=usuario.id");
        if (!eu.getUsuario().isMaster()) {
            sql.append(" and estrutura_usuario_id in :hierarquia");
        }
        if (!userFilter.isEmpty()) {
            sql.append(" and usuario.login like :userFilter");
        }
        if (activeOnly.booleanValue()) {
            sql.append(" and sessions.ativa=1");
            sql.append(" and last_heartbeat >='").append(LocalDateTime.now().minusMinutes(10L)).append("'");
        } else {
            if (dataInicial != null) {
                sql.append(" and data_hora_criacao>=:dataInicial");
            }
            if (dataFinal != null) {
                sql.append(" and data_hora_criacao<=:dataFinal");
            }
        }
        if (count) {
            query = this.manager.createNativeQuery(sql.toString());
        } else {
            if (pageable != null) {
                sql.append(" limit :limit offset :offset");
            }
            query = this.manager.createNativeQuery(sql.toString(), SessionsDTO.class);
        }
        if (!userFilter.isEmpty()) {
            query.setParameter("userFilter", (Object)("%" + userFilter + "%"));
        }
        if (!activeOnly.booleanValue()) {
            if (dataInicial != null) {
                query.setParameter("dataInicial", (Object)LocalDateTime.of(dataInicial, LocalTime.MIN));
            }
            if (dataFinal != null) {
                query.setParameter("dataFinal", (Object)LocalDateTime.of(dataFinal, LocalTime.MAX));
            }
        }
        if (!eu.getUsuario().isMaster()) {
            query.setParameter("hierarquia", (Object)this.hierarquiaService.getHierarquia(eu));
        }
        if (!count && pageable != null) {
            query.setParameter("limit", (Object)pageable.getPageSize());
            query.setParameter("offset", (Object)pageable.getOffset());
        }
        return query;
    }
}

