/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.usuario.service;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.shared.model.OperacaoFinanceiraEnum;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.model.UsuarioFinanceiro;
import br.com.system.app.features.usuario.repository.UsuarioFinanceiroRepository;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.commons.decimal.DecimalNumber;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UsuarioFinanceiroService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private UsuarioFinanceiroRepository usuarioFinanceiroRepository;

    public void validaSaldo(EstruturaUsuario eu, BigDecimal valorDebito) {
        Usuario usuario;
        usuario.setSaldo((usuario = eu.getUsuario()).getSaldo() == null ? BigDecimal.ZERO : usuario.getSaldo());
        DecimalNumber saldoUsuario = new DecimalNumber(usuario.getSaldo(), 2);
        if (saldoUsuario.minus(valorDebito).result().compareTo(BigDecimal.ZERO) <= 0) {
            throw new BusinessException("Usu\u00e1rio sem limite de consultas.");
        }
    }

    public void debitarValor(EstruturaUsuario eu, BigDecimal valorDebito, String descricao) {
        Usuario usuario = eu.getUsuario();
        usuario.setSaldo(new DecimalNumber(usuario.getSaldo()).minus(valorDebito).result());
        this.usuarioService.salvar(usuario, eu);
        this.logFinanceiro(usuario, valorDebito, OperacaoFinanceiraEnum.DEBITO, descricao);
    }

    public void creditarValor(EstruturaUsuario eu, BigDecimal valorCredito, String descricao) {
        Usuario usuario = eu.getUsuario();
        usuario.setSaldo(new DecimalNumber(usuario.getSaldo()).plus(valorCredito).result());
        this.usuarioService.salvar(usuario, eu);
        this.logFinanceiro(usuario, valorCredito, OperacaoFinanceiraEnum.CREDITO, descricao);
    }

    private void logFinanceiro(Usuario usuario, BigDecimal valor, OperacaoFinanceiraEnum operacao, String descricao) {
        UsuarioFinanceiro uf = new UsuarioFinanceiro();
        uf.setDataHora(LocalDateTime.now());
        uf.setDescricao(descricao);
        uf.setOperacao(operacao);
        uf.setValor(valor);
        uf.setUsuario(usuario);
        this.usuarioFinanceiroRepository.save((Object)uf);
    }
}

