/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.usuario.service;

import br.com.system.app.features.configurations.model.ConfigurationEnum;
import br.com.system.app.features.configurations.service.ConfigurationsService;
import br.com.system.app.features.email.service.SendMailService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.EstruturaUsuarioRepository;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.sessions.model.Sessions;
import br.com.system.app.features.sessions.service.SessionsClientInfo;
import br.com.system.app.features.sessions.service.SessionsService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.usuario.dto.UsuarioBIDTO;
import br.com.system.app.features.usuario.dto.UsuarioCopyTypeEnum;
import br.com.system.app.features.usuario.dto.UsuarioDTO;
import br.com.system.app.features.usuario.dto.UsuarioTemaEnum;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.model.UsuarioPerfilEnum;
import br.com.system.app.features.usuario.model.UsuarioTag;
import br.com.system.app.features.usuario.repository.UsuarioRepository;
import br.com.system.app.features.usuario.service.UsuarioCopyService;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.features.usuario.service.UsuarioSenhaService;
import br.com.system.app.features.usuario.service.UsuarioTagService;
import br.com.system.app.features.whatsapp.service.WhatsAppContaService;
import br.com.system.app.security.CustomUserDetails;
import br.com.system.app.security.Roles;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.HashUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.TelefoneUtil;
import br.com.system.commons.ValidationUtil;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinSession;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UsuarioService
implements Serializable,
SecurityContext {
    private static final long serialVersionUID = 1L;
    @Autowired
    private UsuarioHierarquiaService usuarioHierarquiaService;
    private final String SECRET_CODE = "6ad7a94c-f315-42ad-a5ba-b4be4357b717";
    @Autowired
    private UsuarioRepository usuarioRepository;
    @Autowired
    private EstruturaUsuarioRepository estruturaUsuarioRepository;
    @Autowired
    private UsuarioTagService usuarioTagService;
    @Autowired
    private SessionsService sessionsService;
    @Autowired
    private NotificacoesService notificacoesService;
    @Autowired
    private UsuarioCopyService usuarioCopyService;
    @Autowired
    private WhatsAppContaService whatsappContaService;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private SendMailService sendMailService;
    @Autowired
    private ConfigurationsService configurationsService;
    @Autowired
    private UsuarioSenhaService usuarioSenhaService;

    public void setTipoPedidoDefault(Usuario u, PedidoTipoEnum tipo) {
        if (u == null || u.getId() == null || tipo == null) {
            return;
        }
        this.usuarioRepository.updateTipoPedido(u.getId(), tipo.name());
    }

    public Usuario getByRamal(String ramal) {
        return this.usuarioRepository.findByRamal(ramal);
    }

    public void changeTheme(EstruturaUsuario eu, UsuarioTemaEnum theme) {
        if (theme == null) {
            return;
        }
        Usuario u = eu.getUsuario();
        u.setTema(theme);
        this.salvar(u, eu);
    }

    public void autenticar(String user, String pass) throws Exception {
        if (this.configurationsService.get(ConfigurationEnum.MANUTENCAO).getValor().equals("true")) {
            throw new Exception("Estamos em manutencao, por favor tente mais tarde");
        }
        VaadinServletRequest request = VaadinServletRequest.getCurrent();
        if (request == null) {
            throw new Exception("Erro ao logar");
        }
        try {
            request.login(user, pass);
        }
        catch (ServletException e) {
            throw new Exception(e.getMessage());
        }
        CustomUserDetails cud = (CustomUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        VaadinSession.getCurrent().setAttribute(EstruturaUsuario.class, (Object)cud.getEu());
        if (cud.getEu().getUsuario().isSessaoUnica()) {
            List ativas = this.sessionsService.getAtivaByEu(cud.getEu());
            for (Sessions ativa : ativas) {
                ativa.setAtiva(false);
                this.notificacoesService.notify(ativa.getEstruturaUsuario(), "Voc\u00ea foi Desconectado", "Seu login foi utilizado em outra maquina", Boolean.valueOf(true));
                this.sessionsService.encerrarSessao(ativa);
            }
        }
        SessionsClientInfo sci = new SessionsClientInfo((HttpServletRequest)request);
        String sessionId = request.getSession().getId();
        Sessions sessions = this.sessionsService.getBySessionId(sessionId);
        if (sessions == null) {
            sessions = new Sessions();
        }
        sessions.setBrowser(sci.getClientBrowser());
        sessions.setDataHoraCriacao(LocalDateTime.now());
        sessions.setEstruturaUsuario(cud.getEu());
        sessions.setIpAddress(sci.getClientIpAddr());
        sessions.setLastHeartbeat(LocalDateTime.now());
        sessions.setUserAgent(sci.getUserAgent());
        sessions.setOs(sci.getClientOS());
        sessions.setSessionId(request.getSession().getId());
        sessions.setAtiva(true);
        sessions.setHostname(System.getenv("HOSTNAME"));
        this.sessionsService.save(sessions);
        Usuario usuario = cud.getEu().getUsuario();
        usuario.setUltimoLogin(LocalDateTime.now());
        this.usuarioRepository.save((Object)usuario);
    }

    public void atualizarToken() {
        List u = this.usuarioRepository.findForSetToken();
        for (Usuario usuario : u) {
            if (usuario.getTokenIntegration() != null && !usuario.getTokenIntegration().isBlank()) continue;
            usuario.setTokenIntegration(HashUtil.getUUI());
            this.usuarioRepository.save((Object)usuario);
        }
    }

    public BigDecimal saveCreditos(EstruturaUsuario eu, BigDecimal valor) {
        Usuario usuario = eu.getUsuario();
        BigDecimal saldo = this.getCreditos(usuario).add(valor);
        usuario.setSaldoCreditos(saldo);
        this.salvar(usuario, eu);
        return saldo;
    }

    public BigDecimal getCreditos(Usuario usuario) {
        BigDecimal creditos = ((Usuario)this.usuarioRepository.findById((Object)usuario.getId()).get()).getSaldoCreditos();
        if (creditos == null) {
            return BigDecimal.ZERO;
        }
        return creditos;
    }

    @Transactional
    public void saveTags(EstruturaUsuario eu, String tags) {
        this.usuarioTagService.saveTags(tags, eu);
    }

    @Transactional
    public void deleteTags(EstruturaUsuario eu, Set<UsuarioTag> tags) {
        List hierarquiaDto = this.usuarioHierarquiaService.getHierarquiaDto(eu, "", tags, new HashSet(), Boolean.valueOf(false));
        this.saveTags(new HashSet(hierarquiaDto), tags, false, false);
    }

    @Transactional
    public void saveTags(Set<HierarquiaDTO> lh, Set<UsuarioTag> tags, boolean inserir, boolean limpar) {
        ArrayList<String> ls = new ArrayList<String>();
        for (HierarquiaDTO h : lh) {
            ls.add(h.getUsuarioId().toString());
        }
        String listaIds = StringUtils.join(ls, (String)",");
        if (limpar) {
            this.usuarioRepository.removeAllTags(listaIds);
        } else {
            for (UsuarioTag tag : tags) {
                this.usuarioRepository.updateTags(listaIds, tag.getTag(), Boolean.valueOf(inserir));
            }
        }
    }

    public String getStringtags(Set<UsuarioTag> tags) {
        return this.usuarioTagService.getStringtags(tags);
    }

    @Transactional
    public Usuario salvar(Usuario usuario, EstruturaUsuario eu) throws BusinessException {
        if (usuario.getPerfil() == null) {
            throw new BusinessException("Perfil obrigatorio");
        }
        if (usuario.getLogin().isBlank()) {
            throw new BusinessException("Login obrigatorio");
        }
        if (usuario.getNome().isBlank()) {
            throw new BusinessException("Nome obrigatorio");
        }
        usuario.setTags(this.usuarioTagService.saveTags(usuario.getTags(), eu));
        if (usuario.getTokenIntegration() == null || usuario.getTokenIntegration().isBlank()) {
            usuario.setTokenIntegration(HashUtil.getUUI());
        }
        if (usuario.getSecretCode() == null) {
            usuario.setSecretCode(HashUtil.getUUI());
        }
        if (usuario.getSenha() == null && usuario.getId() != null) {
            usuario.setSenha(((Usuario)this.getById(usuario.getId()).get()).getSenha());
        }
        if (usuario.getTema() == null) {
            usuario.setTema(UsuarioTemaEnum.DARK);
        }
        if (usuario.getTipoPedidoDefault() == null) {
            usuario.setTipoPedidoDefault(PedidoTipoEnum.COMERCIAL);
        }
        if (usuario.getCelular() != null) {
            usuario.setCelular(StringUtil.numbersOnly((String)usuario.getCelular()));
        }
        if (usuario.getCelularAlternativo() != null) {
            usuario.setCelularAlternativo(StringUtil.numbersOnly((String)usuario.getCelularAlternativo()));
        }
        if (usuario.isMaster()) {
            usuario.setSessaoUnica(false);
        } else {
            usuario.setSessaoUnica(true);
        }
        if (usuario.getVendedor() == null && usuario.getPerfil().equals((Object)UsuarioPerfilEnum.COMERCIAL)) {
            usuario.setVendedor(Boolean.valueOf(true));
        } else {
            usuario.setVendedor(Boolean.valueOf(false));
        }
        usuario.setDataHoraAtualizacao(LocalDateTime.now());
        return (Usuario)this.usuarioRepository.save((Object)usuario);
    }

    public Optional<Usuario> getById(Long id) {
        return Optional.ofNullable(this.usuarioRepository.findById((Object)id)).orElse(null);
    }

    public List<Usuario> getByCelular(String celular) {
        return this.usuarioRepository.findByCelular(TelefoneUtil.normalize((String)celular));
    }

    public Usuario getByLogin(String login) {
        return this.usuarioRepository.findByLogin(login);
    }

    public Optional<EstruturaUsuario> getByUsuarioAndEstrutura(Usuario usuario, Estrutura estrutura) {
        return Optional.ofNullable(this.estruturaUsuarioRepository.findByUsuarioAndEstrutura(usuario, estrutura));
    }

    public UsuarioDTO insertMaster(Estrutura estrutura) {
        UsuarioDTO dto = new UsuarioDTO();
        dto.setAtivo(Boolean.TRUE);
        dto.setCelular("");
        dto.setDataCadastro(LocalDate.now());
        dto.setEmail("neocrmoficial@gmail.com");
        dto.setLogin("master");
        dto.setNome("Usu\u00e1rio Master");
        dto.setPerfil(UsuarioPerfilEnum.PROPRIETARIO);
        dto.setTags("#master");
        dto.setMaster(Boolean.valueOf(true));
        dto = this.saveAndCreate(dto, estrutura);
        Usuario u = (Usuario)this.getById(dto.getId()).get();
        u.setMaster(true);
        u.setSecretCode("6ad7a94c-f315-42ad-a5ba-b4be4357b717");
        u.setSessaoUnica(false);
        u.setSaldoCreditos(BigDecimal.valueOf(90L));
        this.usuarioRepository.save((Object)u);
        return dto;
    }

    public UsuarioDTO saveAndCreate(UsuarioDTO dto, Estrutura estrutura) {
        return this.saveAndCreate(dto, estrutura, null);
    }

    @Transactional
    public UsuarioDTO saveAndCreate(UsuarioDTO dto, Estrutura estrutura, EstruturaUsuario euModelo) {
        if (!ValidationUtil.isValidEmail((String)dto.getEmail())) {
            throw new BusinessException("Email: " + dto.getEmail() + " \u00e9 inv\u00e1lido");
        }
        if (dto.getCpf() != null && !dto.getCpf().isEmpty() && !ValidationUtil.isValidCPF((String)dto.getCpf())) {
            throw new BusinessException("CPF inv\u00e1lido");
        }
        boolean novo = false;
        Usuario usuario = dto.getId() == null ? null : (Usuario)this.getById(dto.getId()).get();
        String senhaHash = HashUtil.getUUI();
        if (usuario == null) {
            novo = true;
            String senha = this.passwordEncoder.encode((CharSequence)senhaHash);
            usuario = new Usuario();
            usuario.setDataCadastro(LocalDate.now());
            usuario.setSenha(senha);
            usuario.setSecretCode(HashUtil.getUUI());
        }
        dto.setLogin(this.validaLogin(dto, estrutura.getNome()));
        if (usuario.isMaster()) {
            usuario.setSessaoUnica(false);
        } else {
            usuario.setSessaoUnica(true);
        }
        usuario.setCelular(dto.getCelular());
        usuario.setCelularAlternativo(dto.getCelularAlternativo());
        usuario.setConfirmado(false);
        usuario.setEmail(dto.getEmail().toLowerCase().trim());
        usuario.setEmailAlternativo(dto.getEmailAlternativo() == null ? "" : dto.getEmailAlternativo().toLowerCase().trim());
        usuario.setLogin(dto.getLogin().toLowerCase().trim());
        usuario.setNome(dto.getNome());
        usuario.setSaldo(dto.getSaldo());
        usuario.setTags(dto.getTags() == null ? "" : StringUtil.normalizeTags((String)dto.getTags()));
        usuario.setPerfil(dto.getPerfil());
        usuario.setUrlBi(dto.getUrlBi());
        usuario.setCpf(dto.getCpf());
        usuario.setRg(dto.getRg());
        usuario.setSalario(dto.getSalario());
        usuario.setValeRefeicao(dto.getValeRefeicao());
        usuario.setAjudaCusto(dto.getAjudaCusto());
        usuario.setDataAdmissao(dto.getDataAdmissao());
        if (euModelo != null) {
            usuario.setVendedor(euModelo.getUsuario().getVendedor());
            usuario.setRecebeNotificacaoWhats(euModelo.getUsuario().getRecebeNotificacaoWhats());
        } else {
            usuario.setVendedor(dto.getVendedor());
            usuario.setRecebeNotificacaoWhats(dto.getRecebeNotificacaoWhats());
        }
        usuario.setIpFixo(dto.getIpFixo() == null || dto.getIpFixo().isEmpty() ? null : dto.getIpFixo());
        usuario.setRamal(dto.getRamal());
        usuario.setTipoPedidoDefault(PedidoTipoEnum.COMERCIAL);
        if (usuario.getTema() == null) {
            usuario.setTema(UsuarioTemaEnum.DARK);
        }
        usuario.setWhatsappConta(dto.getWhatsappContaId() != null ? this.whatsappContaService.getById(dto.getWhatsappContaId()) : null);
        usuario.setDataHoraAtualizacao(LocalDateTime.now());
        usuario.setTravaQrcode(dto.getTravaQrcode());
        usuario.setNotificacaoNaView(dto.getNotificacaoNaView());
        usuario = (Usuario)this.usuarioRepository.save((Object)usuario);
        EstruturaUsuario eu = this.estruturaUsuarioRepository.findByUsuarioAndEstrutura(usuario, estrutura);
        if (eu == null) {
            eu = new EstruturaUsuario();
            eu.setAtivo(dto.getAtivo().booleanValue());
            eu.setEstrutura(estrutura);
            eu.setUsuario(usuario);
            eu.setRules(this.normalizeRules(dto.getRules()));
        } else {
            eu.setAtivo(dto.getAtivo().booleanValue());
        }
        eu = (EstruturaUsuario)this.estruturaUsuarioRepository.save((Object)eu);
        if (!dto.getAtivo().booleanValue()) {
            this.sessionsService.encerrarSessao(eu);
        }
        dto.setEstruturaUsuarioId(eu.getId());
        dto.setId(usuario.getId());
        if (novo) {
            if (euModelo != null) {
                this.usuarioCopyService.copiar(this.getEu(), eu, euModelo, UsuarioCopyTypeEnum.TUDO);
            }
            this.sendCredentials(eu, usuario, senhaHash, "Seu cadastro foi criado, segue suas credenciais");
        }
        this.usuarioTagService.saveTags(usuario.getTags(), eu);
        return dto;
    }

    private String validaLogin(UsuarioDTO dto, String dominio) throws BusinessException {
        Usuario optU;
        Object login = StringUtil.normalize((String)dto.getLogin().toLowerCase().trim());
        if (((String)(login = StringUtil.removeLineBreaks((String)login))).contains("@")) {
            String[] arr = ((String)login).split("@");
            if (!arr[1].equals(dominio)) {
                throw new BusinessException("Dominio inv\u00e1lido");
            }
        } else {
            login = (String)login + "@" + dominio;
        }
        if ((optU = this.getByLogin((String)login)) != null && !optU.getId().equals(dto.getId())) {
            throw new BusinessException("Login: " + (String)login + " j\u00e1 est\u00e1 em uso");
        }
        return login;
    }

    private String normalizeRules(String rules) {
        Object retorno = "";
        if (rules == null || rules.isBlank()) {
            return retorno;
        }
        String[] arr = rules.split(",");
        for (int i = 0; i < arr.length; ++i) {
            try {
                String s = arr[i];
                s = StringUtil.normalize((String)s).trim().replaceAll(" ", "_").toUpperCase();
                if (s.isBlank() || !new Roles().getAll().add(s)) continue;
                retorno = (String)retorno + s;
                if (i >= arr.length - 1) continue;
                retorno = (String)retorno + ",";
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retorno;
    }

    public void changeDomain(Estrutura e, String oldDomain, String newDomain) {
        if (e == null || oldDomain.isEmpty() || newDomain.isEmpty()) {
            throw new BusinessException("Estrutura, dominio antigo e dominio novo s\u00e3o obrigatorios");
        }
        this.usuarioRepository.changeDominio(e.getId(), oldDomain, oldDomain, newDomain);
    }

    public String setSecretCode(EstruturaUsuario eu) {
        Usuario u = eu.getUsuario();
        String secret = u.isMaster() ? "6ad7a94c-f315-42ad-a5ba-b4be4357b717" : HashUtil.getUUI();
        u.setSecretCode(secret);
        this.salvar(u, eu);
        return secret;
    }

    public Usuario getByIntegrationToken(String token) {
        Usuario usuario = this.usuarioRepository.findByTokenIntegration(token);
        if (usuario == null) {
            throw new BusinessException("Usu\u00e1rio n\u00e3o encontrado ou inativo");
        }
        return usuario;
    }

    public List<UsuarioBIDTO> getForBi(Long estruturaId, LocalDateTime dataHoraUltimaCarga) {
        return this.usuarioRepository.findForBi(estruturaId, dataHoraUltimaCarga);
    }

    private String getMsgSenha(Estrutura estrutura, Usuario usuario, String senhaHash) {
        String msg = "Ol\u00e1 <B>" + usuario.getNome() + "</B> seja bem vindo!!!<BR><BR>Seguem suas credenciais:<BR>login: <B>" + usuario.getLogin() + "</B><BR>Senha: <B>" + senhaHash + "</B><BR><BR>Acesse: https://" + estrutura.getNome() + ".neosales.com.br <BR><BR>Voc\u00ea tem 48 horas para cadastrar seu autenticador de dois fatores at\u00e9 l\u00e1 voc\u00ea conseguir\u00e1 acessar normalmente apenas com login e senha.<BR>Para cadastrar o 2FA, voc\u00ea pode assistir a este video: " + this.configurationsService.get(ConfigurationEnum.URL_YOUTUBE_2FA).getValor() + " ou ainda entrar em contato com nosso suporte para que eles acompanhem o cadastro.<BR><BR>Atenciosamente<BR>Equipe suporte<BR>";
        return msg;
    }

    public void sendCredentials(EstruturaUsuario euContext, Usuario usuario, String senhaHash, String titulo) {
        if (senhaHash == null) {
            senhaHash = HashUtil.getUUI();
        }
        this.usuarioSenhaService.atualizarSenha(usuario, senhaHash);
        this.sendMailService.sendNoReply(euContext, usuario.getEmail(), titulo, this.getMsgSenha(euContext.getEstrutura(), usuario, senhaHash));
    }
}

