/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.whatsapp.model.WhatsAppResposta;
import br.com.system.app.features.whatsapp.model.WhatsAppRespostaCategoria;
import br.com.system.app.features.whatsapp.service.WhatsAppRespostaService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.spring.annotation.SpringComponent;
import com.vdurmont.emoji.EmojiParser;
import java.io.Serializable;
import java.util.Collection;

@SpringComponent
public class WhatsAppRespostaDialog
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final WhatsAppRespostaService respostaService;
    private String mensagem;
    private ComboBox<WhatsAppRespostaCategoria> cbCategoria;
    private Grid<WhatsAppResposta> grid;
    private TextField txtResp;

    public WhatsAppRespostaDialog(WhatsAppRespostaService respostaService) {
        this.respostaService = respostaService;
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public String getMensagem() {
        return this.mensagem;
    }

    public void show() {
        this.mensagem = null;
        this.removeAll();
        this.setWidth("600px");
        VerticalContainer main = new VerticalContainer(new Component[0]);
        main.setWidthFull();
        main.setHeightFull();
        main.add(new Component[]{UIUtils.createHeader((String)"RESPOSTAS PRONTAS")});
        this.grid = new Grid(WhatsAppResposta.class);
        this.cbCategoria = new ComboBox("Categoria", (Collection)this.respostaService.getCategoria(this.getEstrutura()));
        this.cbCategoria.setItemLabelGenerator(WhatsAppRespostaCategoria::getNome);
        this.cbCategoria.setWidth("200px");
        this.txtResp = new TextField("Resposta");
        Button bPesq = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.SEARCH, (String)"Pesquisar");
        bPesq.addClickListener((ComponentEventListener & Serializable)e -> this.povoar());
        this.grid.setColumns(new String[0]);
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)EmojiParser.parseToUnicode((String)p.getResposta())))).setHeader("Repostas Prontas").setFlexGrow(0).setWidth("500px");
        Button bResp = UIUtils.createSmallButton((String)"Selecionar");
        bResp.setDisableOnClick(true);
        bResp.addClickListener((ComponentEventListener & Serializable)e -> {
            bResp.setEnabled(true);
            if (this.grid.getSelectedItems().size() <= 0) {
                UIUtils.showNotification((String)"Selecione uma resposta para enviar");
                return;
            }
            this.mensagem = ((WhatsAppResposta)this.grid.getSelectedItems().iterator().next()).getResposta();
            this.close();
        });
        Button bClose = UIUtils.createSmallButton((String)"Fechar");
        bClose.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        main.add(new Component[]{new HorizontalContainer(new Component[]{this.cbCategoria, this.txtResp, bPesq}), this.grid, new FooterContainer(new Component[]{bClose, bResp})});
        this.add(new Component[]{main});
        this.open();
        this.povoar();
    }

    private void povoar() {
        this.grid.setItems((Collection)this.respostaService.getRespostas(this.getEstrutura(), (WhatsAppRespostaCategoria)this.cbCategoria.getValue(), this.txtResp.getValue()));
    }
}

