/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.repository;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.whatsapp.dto.WhatsAppAtendimentoDTO;
import br.com.system.app.features.whatsapp.dto.WhatsAppFiltroEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppEtapaEnum;
import br.com.system.app.features.whatsapp.repository.WhatsAppAtendimentoRepositoryQuery;
import br.com.system.commons.datetime.FormatDate;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import org.springframework.transaction.annotation.Transactional;

public class WhatsAppAtendimentoRepositoryImpl
implements WhatsAppAtendimentoRepositoryQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    private EntityManager manager;

    @Transactional(readOnly=true)
    public List<WhatsAppAtendimentoDTO> findAtendimento(LocalDateTime dIni, LocalDateTime dFim, Estrutura estrutura, EstruturaUsuario eu, WhatsAppEtapaEnum etapa, WhatsAppFiltroEnum filtro, Set<String> cnpjs, Set<String> numeros) {
        StringBuilder sql = new StringBuilder();
        sql.append("select w.id wid,wa.id,wa.cnpj,c.nome nome_cliente,w.nome,w.numero,w.email,wa.etapa,wa.data_hora_inicio data_inicio,wa.data_hora_fim data_fim,").append(" wa.data_hora_transferencia data_transf,u.login,wa.ultima_mensagem,u.nome nome_usuario, wa.fechado_inatividade,wa.atendente_id, w.funcao,").append(" wa.data_hora_ultima_mensagem,wa.data_hora_ultimo_envio,wa.pedido_id,wa.escolha_tipo ").append(" from whatsapp_atendimento wa \n").append(" join whatsapp w on (wa.whatsapp_id=w.id) \n").append(" join whatsapp_conta wc on (w.whatsapp_conta_id=wc.id)\n").append(" join estrutura_usuario eu on (wa.atendente_id=eu.id) \n").append(" join usuario u on (eu.usuario_id=u.id)\n").append(" left join cliente c on (wa.cnpj=c.cpf_cnpj and c.estrutura_id=wc.estrutura_id) ").append(" WHERE wc.estrutura_id=:estruturaId");
        if (filtro.equals((Object)WhatsAppFiltroEnum.CADASTROS_COMPLETOS)) {
            if (dIni != null && dFim != null) {
                sql.append(" AND w.data_hora_criacao >=:dIni and w.data_hora_criacao <=:dFim ");
            }
            sql.append(" and w.email is not null and w.cpf_cnpj is not null and w.nome is not null and w.funcao is not null");
        } else if (filtro.equals((Object)WhatsAppFiltroEnum.CADASTROS_INCOMPLETOS)) {
            sql.append(" AND w.data_hora_criacao >=:dIni and w.data_hora_criacao <=:dFim ");
            sql.append(" and (w.email is null or w.cpf_cnpj is null or w.nome is null or w.funcao is null)");
        } else if (filtro.equals((Object)WhatsAppFiltroEnum.MAIS_10MINUTOS)) {
            sql.append(" AND wa.data_hora_ultima_mensagem <:mais10Minutos");
        } else if (dIni != null && dFim != null) {
            sql.append(" AND wa.data_hora_inicio >=:dIni and wa.data_hora_inicio <=:dFim ");
        }
        if (eu != null) {
            sql.append(" AND wa.atendente_id=:euId");
        }
        if (etapa != null) {
            sql.append(" AND wa.etapa=:etapa");
        }
        if (numeros != null && !numeros.isEmpty()) {
            sql.append(" AND w.numero in :numeros");
        }
        boolean filtrarCnpj = false;
        if (filtro.equals((Object)WhatsAppFiltroEnum.CADASTROS_COMPLETOS) || filtro.equals((Object)WhatsAppFiltroEnum.CADASTROS_INCOMPLETOS)) {
            if (cnpjs != null && !cnpjs.isEmpty()) {
                sql.append(" and w.cpf_cnpj in :cnpjs");
                filtrarCnpj = true;
            }
            sql.append(" group by wa.whatsapp_id order by wa.id");
        } else {
            if (cnpjs != null && !cnpjs.isEmpty()) {
                filtrarCnpj = true;
                sql.append(" and wa.cnpj in :cnpjs");
            }
            sql.append(" order by wa.id desc");
        }
        Query query = this.manager.createNativeQuery(sql.toString(), WhatsAppAtendimentoDTO.class);
        query.setParameter("estruturaId", (Object)estrutura.getId());
        if (eu != null) {
            query.setParameter("euId", (Object)eu.getId());
        }
        if (etapa != null) {
            query.setParameter("etapa", (Object)etapa.name());
        }
        if (numeros != null && !numeros.isEmpty()) {
            query.setParameter("numeros", numeros);
        }
        if (filtrarCnpj) {
            query.setParameter("cnpjs", cnpjs);
        }
        if (filtro.equals((Object)WhatsAppFiltroEnum.MAIS_10MINUTOS)) {
            query.setParameter("mais10Minutos", (Object)LocalDateTime.now().minusMinutes(10L).format(FormatDate.MYSQLDATETIME.toDTF()));
        } else if (dIni != null && dFim != null) {
            query.setParameter("dIni", (Object)dIni.format(FormatDate.MYSQLDATETIME.toDTF()));
            query.setParameter("dFim", (Object)dFim.format(FormatDate.MYSQLDATETIME.toDTF()));
        }
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<Long> findInativos(LocalDateTime dataHoraUltimaMensagem) {
        String sql = "SELECT wa.id from whatsapp_atendimento wa,whatsapp w where wa.whatsapp_id=w.id and wa.etapa !='FECHADO' and wa.data_hora_ultima_mensagem <:dataHoraUltimaMensagem";
        Query query = this.manager.createNativeQuery(sql, Long.class);
        query.setParameter("dataHoraUltimaMensagem", (Object)dataHoraUltimaMensagem.format(FormatDate.MYSQLDATETIME.toDTF()));
        return query.getResultList();
    }

    @Transactional
    public void sincronizarPedidoAtendimento(Set<Long> pedidos) {
        String sql = "update whatsapp_atendimento,whatsapp,pedido set  whatsapp_atendimento.atendente_id=pedido.estrutura_usuario_id, whatsapp.ultimo_atendente_id=pedido.estrutura_usuario_id where whatsapp.id=whatsapp_atendimento.whatsapp_id and whatsapp_atendimento.pedido_id=pedido.id and pedido.id in :pedidos";
        Query query = this.manager.createNativeQuery(sql);
        query.setParameter("pedidos", pedidos);
        query.executeUpdate();
    }
}

