/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.commons.strings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WordSplitter {
    private static final int MATCHES_TO_CONSIDER_UPPERCASE = 2;
    private List<String> words = new ArrayList();
    private boolean splitOnCaseAlternance;
    private boolean splitOnNumberAndLetterAlternance;
    private String currWord;
    private char lastChar;

    public WordSplitter setSplitOnCaseAlternance(boolean shouldSplit) {
        this.splitOnCaseAlternance = shouldSplit;
        return this;
    }

    public WordSplitter setSplitOnNumberAndLetterAlternance(boolean shouldSplit) {
        this.splitOnNumberAndLetterAlternance = shouldSplit;
        return this;
    }

    public List<String> split(String text) {
        if (text == null || text.isEmpty()) {
            return Collections.emptyList();
        }
        this.initVariables();
        return this.doSplit(text);
    }

    private void initVariables() {
        this.words = new ArrayList();
        this.currWord = "";
        this.lastChar = '\u0000';
    }

    private List<String> doSplit(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (this.hasNewWord(ch)) {
                this.accumulateCurrentWord();
            }
            this.accumulateChar(ch);
            this.updateLastChar(ch);
        }
        this.accumulateLastWord();
        return this.words;
    }

    private boolean hasNewWord(char currChar) {
        if (Character.isWhitespace(currChar)) {
            return true;
        }
        if (this.splitOnCaseAlternance) {
            if (this.hasChangedFromLowerToUpper(this.lastChar, currChar)) {
                return true;
            }
            if (this.hasChangedFromUpperToLower(this.lastChar, currChar) && this.currentWordConsideredUppercase()) {
                return true;
            }
        }
        if (this.splitOnNumberAndLetterAlternance) {
            if (this.hasChangedFromNumberToLetter(this.lastChar, currChar)) {
                return true;
            }
            if (this.hasChangedFromLetterToNumber(this.lastChar, currChar)) {
                return true;
            }
        }
        return false;
    }

    private boolean hasChangedFromLowerToUpper(char lastChar, char currChar) {
        return Character.isLowerCase(lastChar) && Character.isUpperCase(currChar);
    }

    private boolean hasChangedFromUpperToLower(char lastChar, char currChar) {
        return Character.isUpperCase(lastChar) && Character.isLowerCase(currChar);
    }

    private boolean hasChangedFromLetterToNumber(char lastChar, char currChar) {
        return Character.isLetter(lastChar) && Character.isDigit(currChar);
    }

    private boolean hasChangedFromNumberToLetter(char lastChar, char currChar) {
        return Character.isDigit(lastChar) && Character.isLetter(currChar);
    }

    private boolean currentWordConsideredUppercase() {
        int upperCharsCount = 0;
        for (int i = 0; i < this.currWord.length(); ++i) {
            if (Character.isUpperCase(this.currWord.charAt(i))) {
                ++upperCharsCount;
            }
            if (upperCharsCount != 2) continue;
            return true;
        }
        return false;
    }

    private void accumulateChar(char ch) {
        if (!this.isSplitChar(ch)) {
            this.currWord = this.currWord + ch;
        }
    }

    private boolean isSplitChar(char ch) {
        return Character.isWhitespace(ch) || ch == '\r' || ch == '\n' || ch == '\t';
    }

    private void accumulateCurrentWord() {
        if (!this.currWord.isEmpty()) {
            this.words.add(this.currWord);
            this.currWord = "";
        }
    }

    private void accumulateLastWord() {
        this.accumulateCurrentWord();
    }

    private void updateLastChar(char ch) {
        this.lastChar = ch;
    }
}

