/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.integreation.soap;

import br.com.system.integreation.soap.SoapBuilder;
import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SoapBuilder {
    private final HashMap<String, String> headers = new HashMap();
    private String soapProtocol;
    private String corpoMensagemSoap;
    private ArrayList<String> listaUrlsCabecalho = new ArrayList();

    public SOAPMessage getSoapMessage() throws SOAPException {
        SOAPMessage soapMessage = this.criaMensagemSoap();
        this.setMimeHeaders(soapMessage.getMimeHeaders());
        return soapMessage;
    }

    public SoapBuilder addHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    private void setMimeHeaders(MimeHeaders mimeHeaders) {
        for (Map.Entry entry : this.headers.entrySet()) {
            mimeHeaders.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void setAutenticator(String ususario, String senha) {
        String username = ususario;
        char[] password = senha.toCharArray();
        1 myAuth = new /* Unavailable Anonymous Inner Class!! */;
        Authenticator.setDefault((Authenticator)myAuth);
    }

    public String getSoapProtocol() {
        if (this.soapProtocol == null) {
            return "http://schemas.xmlsoap.org/soap/encoding/";
        }
        return this.soapProtocol;
    }

    public SoapBuilder setSoapProtocol(String soapProtocol) {
        this.soapProtocol = soapProtocol;
        return this;
    }

    public SoapBuilder setCorpoMensagemSoap(String corpoMensagemSoap) {
        this.corpoMensagemSoap = corpoMensagemSoap;
        return this;
    }

    public SoapBuilder addUrlCabecalho(String url) {
        this.listaUrlsCabecalho.add(url);
        return this;
    }

    public SoapBuilder setUrlsCabecalho(ArrayList<String> listaUrlsCabecalho) {
        this.listaUrlsCabecalho = listaUrlsCabecalho;
        return this;
    }

    public String getUrlsCabecalho() {
        if (this.listaUrlsCabecalho.size() > 0) {
            return StringUtils.join((Collection)this.listaUrlsCabecalho, (String)" ");
        }
        return "";
    }

    private String getCorpoMensagemSoap() {
        return this.corpoMensagemSoap;
    }

    private SOAPMessage criaMensagemSoap() throws SOAPException {
        StringBuilder stringSoapMessage = this.montaStringMensagemSoap();
        MessageFactory factory = MessageFactory.newInstance();
        try {
            return factory.createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(stringSoapMessage.toString().getBytes()));
        }
        catch (IOException ioException) {
            throw new SOAPException("PROCOLO SOAP N\u00c3O PERMITIDO");
        }
    }

    private StringBuilder montaStringMensagemSoap() {
        return new StringBuilder().append("<soapenv:Envelope ").append(this.getUrlsCabecalho()).append(">").append("<soapenv:Header/>").append("<soapenv:Body>").append(this.getCorpoMensagemSoap()).append("</soapenv:Body>").append("</soapenv:Envelope>");
    }
}

